# Copyright 2013 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Downloads shared ssh keys previously generated by the hadoop master and
# uses them to configure intra-cluster ssh access.

set -e

mkdir -p ~hadoop/.ssh/

PRIVATE_KEY_NAME='hadoop_master_id_rsa'
PUBLIC_KEY_NAME="${PRIVATE_KEY_NAME}.pub"
LOCAL_PUBLIC_KEY="/home/hadoop/.ssh/${PUBLIC_KEY_NAME}"
REMOTE_PUBLIC_KEY="${BDUTIL_GCS_STAGING_DIR}/${PUBLIC_KEY_NAME}"

gsutil cp ${REMOTE_PUBLIC_KEY} ${LOCAL_PUBLIC_KEY}
cat ${LOCAL_PUBLIC_KEY} >> ~hadoop/.ssh/authorized_keys

echo "Host ${PREFIX}*" >> ~hadoop/.ssh/config
echo '  UserKnownHostsFile /dev/null' >> ~hadoop/.ssh/config
echo '  CheckHostIP no' >> ~hadoop/.ssh/config
echo '  StrictHostKeyChecking no' >> ~hadoop/.ssh/config

chown -R hadoop:hadoop ~hadoop/.ssh/
chmod 700 ~hadoop/.ssh
