# Hexiosec Transfer CLI

Command Line Interface for Hexiosec Transfer.

<!-- toc -->
* [Hexiosec Transfer CLI](#hexiosec-transfer-cli)
* [Prerequisites](#prerequisites)
* [Usage](#usage)
* [Authentication & Configuration](#authentication--configuration)
* [Commands](#commands)
<!-- tocstop -->

# Prerequisites

Use of the [Hexiosec Transfer](https://hexiosec.com/transfer) CLI requires an active subscription to Hexiosec Transfer with API access.

# Usage

<!-- usage -->
```sh-session
$ npm install -g @hexiosec/transfer-cli
$ hxtransfer COMMAND
running command...
$ hxtransfer (--version)
@hexiosec/transfer-cli/0.0.17 linux-x64 node-v22.21.1
$ hxtransfer --help [COMMAND]
USAGE
  $ hxtransfer COMMAND
...
```
<!-- usagestop -->

# Authentication & Configuration

1. Go to [My Account](https://transfer.hexiosec.com/account) in Hexiosec Transfer.
2. Under **Create a new API Key** add a description and choose a validity, then click **Create**.
3. Add the API Key value to your environment under the variable `HXTRANSFER_API_KEY`.
4. If you are using a custom domain, set `HXTRANSFER_BASE_URL` to `https://transfer.your-custom-domain.com`. Your API Key will need to be from this domain as well.
5. Check the configuration using `hxtransfer config`.

## All Configuration Options

| Variable                         |            Default            | Description                                    |
| -------------------------------- | :---------------------------: | ---------------------------------------------- |
| `XDG_CONFIG_HOME`                |      Platform-dependent       | Configuration data store location              |
| `XDG_DATA_HOME`                  |      Platform-dependent       | Transfer data store location                   |
| `HXTRANSFER_API_KEY`             |             None              | User API Key                                   |
| `HXTRANSFER_BASE_URL`            | https://transfer.hexiosec.com | Base URL for the Hexiosec Transfer service     |
| `HXTRANSFER_DEFAULT_DOWNLOADS`   |               5               | Default setting for transfer maximum downloads |
| `HXTRANSFER_DEFAULT_EXPIRY_DAYS` |               7               | Default setting for transfer expiry (days)     |

# Commands

<!-- commands -->
* [`hxtransfer auth`](#hxtransfer-auth)
* [`hxtransfer config`](#hxtransfer-config)
* [`hxtransfer download ID [DESTINATION]`](#hxtransfer-download-id-destination)
* [`hxtransfer help [COMMAND]`](#hxtransfer-help-command)
* [`hxtransfer request ID`](#hxtransfer-request-id)
* [`hxtransfer request create SUBJECT`](#hxtransfer-request-create-subject)
* [`hxtransfer request download ID [DESTINATION]`](#hxtransfer-request-download-id-destination)
* [`hxtransfer request edit ID`](#hxtransfer-request-edit-id)
* [`hxtransfer request exportkey ID`](#hxtransfer-request-exportkey-id)
* [`hxtransfer request files ID`](#hxtransfer-request-files-id)
* [`hxtransfer request importkey ID KEYFILE`](#hxtransfer-request-importkey-id-keyfile)
* [`hxtransfer request list`](#hxtransfer-request-list)
* [`hxtransfer send ID`](#hxtransfer-send-id)
* [`hxtransfer send files [FILES]`](#hxtransfer-send-files-files)
* [`hxtransfer send list`](#hxtransfer-send-list)
* [`hxtransfer send message [MESSAGE]`](#hxtransfer-send-message-message)
* [`hxtransfer version`](#hxtransfer-version)

## `hxtransfer auth`

Show authentication information.

```
USAGE
  $ hxtransfer auth [--json]

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Show authentication information.
```

## `hxtransfer config`

Show current configuration.

```
USAGE
  $ hxtransfer config [--json]

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Show current configuration.
```

## `hxtransfer download ID [DESTINATION]`

Download a transfer by ID.

```
USAGE
  $ hxtransfer download ID [DESTINATION] [--json]

ARGUMENTS
  ID             Transfer ID (case-insensitive prefix match)
  [DESTINATION]  [default: .] Destination folder or file output path

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Download a transfer by ID.


  Downloads a specific file by ID to the given destination path.
```

## `hxtransfer help [COMMAND]`

Display help for hxtransfer.

```
USAGE
  $ hxtransfer help [COMMAND...] [-n]

ARGUMENTS
  [COMMAND...]  Command to show help for.

FLAGS
  -n, --nested-commands  Include all nested commands in the output.

DESCRIPTION
  Display help for hxtransfer.
```

_See code: [@oclif/plugin-help](https://github.com/oclif/plugin-help/blob/v6.2.36/src/commands/help.ts)_

## `hxtransfer request ID`

Show details of an existing sharing request.

```
USAGE
  $ hxtransfer request ID [--json]

ARGUMENTS
  ID  Request ID (case-insensitive prefix match)

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Show details of an existing sharing request.
```

## `hxtransfer request create SUBJECT`

Create a new sharing request.

```
USAGE
  $ hxtransfer request create SUBJECT [--json] [-d <value>] [-e <value>]

ARGUMENTS
  SUBJECT  Subject

FLAGS
  -d, --deadline=<value>        Request deadline (format: yyyy/MM/dd HH:mm)
  -e, --deadline-epoch=<value>  Request deadline (epoch time)

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Create a new sharing request.
```

## `hxtransfer request download ID [DESTINATION]`

Download received files from an existing sharing request.

```
USAGE
  $ hxtransfer request download ID [DESTINATION] [--json] [--force]

ARGUMENTS
  ID             Request ID (case-insensitive prefix match)
  [DESTINATION]  [default: .] Destination folder

FLAGS
  --force  Skip confirmation prompt.

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Download received files from an existing sharing request.


  All uploaded files for the sharing request will be downloaded to the given destination folder.
  Files that already exist will be skipped, unless --force is specified.
```

## `hxtransfer request edit ID`

Edit settings of an existing sharing request.

```
USAGE
  $ hxtransfer request edit ID [--json] [-a] [--clear-deadline] [-d <value>] [-e <value>] [-s <value>]
    [--unarchive]

ARGUMENTS
  ID  Request ID (case-insensitive prefix match)

FLAGS
  -a, --archive                 Archive the request
  -d, --deadline=<value>        Set request deadline (format: yyyy/MM/dd HH:mm)
  -e, --deadline-epoch=<value>  Request deadline (epoch time)
  -s, --subject=<value>         New request subject
      --clear-deadline          Remove the request deadline
      --unarchive               Unarchive the request

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Edit settings of an existing sharing request.
```

## `hxtransfer request exportkey ID`

Export keys for an existing sharing request to enable file download from a browser.

```
USAGE
  $ hxtransfer request exportkey ID [--json]

ARGUMENTS
  ID  Request ID (case-insensitive prefix match)

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Export keys for an existing sharing request to enable file download from a browser.
```

## `hxtransfer request files ID`

Show received files of an existing sharing request.

```
USAGE
  $ hxtransfer request files ID [--json]

ARGUMENTS
  ID  Request ID (case-insensitive prefix match)

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Show received files of an existing sharing request.
```

## `hxtransfer request importkey ID KEYFILE`

Import keys for an existing sharing request to enable file download.

```
USAGE
  $ hxtransfer request importkey ID KEYFILE [--json]

ARGUMENTS
  ID       Request ID (case-insensitive prefix match)
  KEYFILE  Path to backup file created by the web application

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Import keys for an existing sharing request to enable file download.
```

## `hxtransfer request list`

List active requests.

```
USAGE
  $ hxtransfer request list [--json] [--archived]

FLAGS
  --archived  Show archived requests.

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  List active requests.
```

## `hxtransfer send ID`

Show details of an existing transfer.

```
USAGE
  $ hxtransfer send ID [--json]

ARGUMENTS
  ID  Transfer ID (case-insensitive prefix match)

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Show details of an existing transfer.
```

## `hxtransfer send files [FILES]`

Send one or more files.

```
USAGE
  $ hxtransfer send files [FILES...] [--json] [-c <value>] [-d <value>] [-e <value>] [--add-password]
    [--generate-password] [-r <value>...] [-v]

FLAGS
  -c, --count=<value>         Maximum download count
  -d, --desc=<value>          [default: Secure Files 17/12/2025] Transfer description
  -e, --exp=<value>           Expiry duration (days)
  -r, --recipient=<value>...  Allowed recipients (Either full email address, or an allowed email domain. Implies -v)
  -v, --verify                Require email verification
      --add-password          Supply a custom password
      --generate-password     Generate a random password

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Send one or more files.

ALIASES
  $ hxtransfer send file
```

## `hxtransfer send list`

List active transfers.

```
USAGE
  $ hxtransfer send list [--json] [-e <value>]

FLAGS
  -e, --expiredDays=<value>  Expired days to include

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  List active transfers.
```

## `hxtransfer send message [MESSAGE]`

Send a secure message, either by specifying the message as a command argument or reading data from stdin.

```
USAGE
  $ hxtransfer send message [MESSAGE] [--json] [-c <value>] [-d <value>] [-e <value>] [--add-password]
    [--generate-password] [-r <value>...] [-v] [-s <value>] [--format plain|markdown]

ARGUMENTS
  [MESSAGE]  Message body (will be read from stdin if empty)

FLAGS
  -c, --count=<value>         Maximum download count
  -d, --desc=<value>          [default: Secure Message 17/12/2025] Transfer description
  -e, --exp=<value>           Expiry duration (days)
  -r, --recipient=<value>...  Allowed recipients (Either full email address, or an allowed email domain. Implies -v)
  -s, --subject=<value>       [default: Secure Message] Message subject
  -v, --verify                Require email verification
      --add-password          Supply a custom password
      --format=<option>       [default: plain] Message format
                              <options: plain|markdown>
      --generate-password     Generate a random password

GLOBAL FLAGS
  --json  Format output as json.

DESCRIPTION
  Send a secure message, either by specifying the message as a command argument or reading data from stdin.

ALIASES
  $ hxtransfer send msg
```

## `hxtransfer version`

```
USAGE
  $ hxtransfer version [--json] [--verbose]

FLAGS
  --verbose  Show additional information about the CLI.

GLOBAL FLAGS
  --json  Format output as json.

FLAG DESCRIPTIONS
  --verbose  Show additional information about the CLI.

    Additionally shows the architecture, node version, operating system, and versions of plugins that the CLI is using.
```

_See code: [@oclif/plugin-version](https://github.com/oclif/plugin-version/blob/v2.2.36/src/commands/version.ts)_
<!-- commandsstop -->
