import { Command, Interfaces } from '@oclif/core';
import { AuthResponse, FileResponse, InviteResponse, SDK } from '@trebuchet/sdk-nodejs';
export type UserConfig = {
    apiKey: string;
    baseUrl: string;
    dateFormat: 'DATETIME_FULL';
    defaultDownloads: number;
    defaultExpiryDays: number;
};
export type Flags<T extends typeof Command> = Interfaces.InferredFlags<(typeof BaseCommand)['baseFlags'] & T['flags']>;
export type Args<T extends typeof Command> = Interfaces.InferredArgs<T['args']>;
export declare const REQUEST_PARTIAL_ID: Interfaces.Arg<string, Record<string, unknown>>;
export declare const TRANSFER_PARTIAL_ID: Interfaces.Arg<string, Record<string, unknown>>;
export declare abstract class BaseCommand<T extends typeof Command> extends Command {
    protected args: Args<T>;
    protected auth: AuthResponse;
    protected flags: Flags<T>;
    protected kek?: CryptoKey;
    protected key?: CryptoKey;
    protected parsedArgv: string[];
    protected sdk: SDK;
    protected userConfig: UserConfig;
    protected catch(err: any): Promise<void>;
    protected dateToString(val?: Date, fallback?: string): string;
    protected ensureConfigDirExists(...paths: string[]): Promise<string>;
    protected getInvite(publicId: string): Promise<unknown>;
    protected getRequestsCache(): Promise<string>;
    protected getTransfer(publicId: string): Promise<unknown>;
    protected getTransfersCache(): Promise<string>;
    protected init(): Promise<void>;
    protected logInvite(inv: InviteResponse): Promise<InviteResponse & {
        code: string;
        keys: boolean;
        link: string;
    }>;
    protected logTransfer(file: FileResponse): Promise<FileResponse & {
        code: string;
        link: string;
    }>;
    protected matchInvite(id: string): Promise<InviteResponse>;
    protected matchTransfer(id: string): Promise<FileResponse>;
    protected setInvite(publicId: string, data: unknown): Promise<void>;
    protected setTransfer(publicId: string, data: unknown): Promise<void>;
}
