import { Flags } from '@oclif/core';
import { DateTime } from 'luxon';
import { BaseCommand, REQUEST_PARTIAL_ID } from '../../base.js';
export default class RequestEdit extends BaseCommand {
    static args = {
        id: REQUEST_PARTIAL_ID,
    };
    static description = 'Edit settings of an existing sharing request.';
    static enableJsonFlag = true;
    static flags = {
        archive: Flags.boolean({ char: 'a', description: 'Archive the request' }),
        'clear-deadline': Flags.boolean({ description: 'Remove the request deadline' }),
        deadline: Flags.string({ char: 'd', description: 'Set request deadline (format: yyyy/MM/dd HH:mm)' }),
        'deadline-epoch': Flags.integer({ char: 'e', summary: 'Request deadline (epoch time)' }),
        subject: Flags.string({ char: 's', description: 'New request subject' }),
        unarchive: Flags.boolean({ description: 'Unarchive the request' }),
    };
    async run() {
        const res = await this.matchInvite(this.args.id);
        const inviteUpdateRequest = {};
        if (this.flags.archive) {
            inviteUpdateRequest.state = 'archived';
        }
        else if (this.flags.unarchive) {
            inviteUpdateRequest.state = 'active';
        }
        if (this.flags.subject) {
            inviteUpdateRequest.subject = this.flags.subject;
        }
        if (this.flags.deadline) {
            inviteUpdateRequest.exp = DateTime.fromFormat(this.flags.deadline, 'yyyy/MM/dd HH:mm').toJSDate();
        }
        else if (this.flags['deadline-epoch']) {
            inviteUpdateRequest.exp = DateTime.fromSeconds(this.flags['deadline-epoch']).toJSDate();
        }
        else if (this.flags['clear-deadline']) {
            inviteUpdateRequest.clearExp = true;
        }
        const upd = await this.sdk.invitesApi.updateInvite({ inviteId: res.publicId, inviteUpdateRequest });
        return this.logInvite(upd);
    }
}
