import { DateTime } from 'luxon';
import table from 'tty-table';
import { BaseCommand, REQUEST_PARTIAL_ID } from '../../base.js';
export default class RequestFiles extends BaseCommand {
    static args = {
        id: REQUEST_PARTIAL_ID,
    };
    static description = 'Show received files of an existing sharing request.';
    static enableJsonFlag = true;
    async run() {
        const inv = await this.matchInvite(this.args.id);
        const res = await this.sdk.filesApi.getFiles({ flags: 2, inviteId: inv.id, state: ['write_complete'] });
        const header = [
            { value: 'ID' },
            { value: 'Description' },
            { value: 'Size' },
            {
                formatter: (val) => DateTime.fromJSDate(val).toLocaleString(DateTime.DATETIME_FULL),
                value: 'Created',
            },
            {
                formatter: (val) => DateTime.fromJSDate(val).toLocaleString(DateTime.DATETIME_FULL),
                value: 'Expires',
            },
        ];
        const rows = res.map((row) => [row.publicId, row.description, row.size, row.created, row.exp]);
        this.log(table(header, rows).render());
        return res;
    }
}
