import { Command, Plugin } from '@oclif/core';
import Plugins from '../../plugins.js';
type Dependencies = Record<string, {
    from: string | undefined;
    version: string;
}>;
type PluginWithDeps = Omit<Plugin, '_commandsDir' | '_debug' | '_manifest' | 'addErrorScope' | 'commandIDs' | 'commandsDir' | 'findCommand' | 'flexibleTaxonomy' | 'load' | 'topics' | 'warn' | 'warned'> & {
    deps: Dependencies;
};
export default class PluginsInspect extends Command {
    static args: {
        plugin: import("@oclif/core/interfaces").Arg<string, Record<string, unknown>>;
    };
    static description: string;
    static enableJsonFlag: boolean;
    static examples: string[];
    static flags: {
        help: import("@oclif/core/interfaces").BooleanFlag<void>;
        verbose: import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static strict: boolean;
    static usage: string;
    plugins: Plugins;
    findDep(plugin: Plugin, dependency: string): Promise<{
        pkgPath: null | string;
        version: null | string;
    }>;
    findPlugin(pluginName: string): Plugin;
    inspect(pluginName: string, verbose?: boolean): Promise<PluginWithDeps>;
    run(): Promise<PluginWithDeps[]>;
}
export {};
