import { Interfaces } from '@oclif/core';
import { LogLevel } from './log-level.js';
import { NPM } from './npm.js';
type Plugin = Interfaces.LinkedPlugin | Interfaces.UserPlugin;
type NormalizedUserPJSON = {
    dependencies: Record<string, string>;
    oclif: {
        plugins: Plugin[];
        schema: number;
    };
    private: boolean;
};
export default class Plugins {
    config: Interfaces.Config;
    readonly npm: NPM;
    private readonly debug;
    private readonly logLevel;
    constructor(options: {
        config: Interfaces.Config;
        logLevel?: LogLevel;
    });
    private get pjsonPath();
    add(...plugins: Plugin[]): Promise<void>;
    friendlyName(name: string): string;
    hasPlugin(name: string): Promise<false | Plugin>;
    install(name: string, { force, tag }?: {
        force?: boolean | undefined;
        tag?: string | undefined;
    }): Promise<Interfaces.Config>;
    link(p: string, { install }: {
        install: boolean;
    }): Promise<Interfaces.Config>;
    list(): Promise<Plugin[]>;
    maybeUnfriendlyName(name: string): Promise<string>;
    pjson(): Promise<NormalizedUserPJSON>;
    remove(name: string): Promise<void>;
    unfriendlyName(name: string): string | undefined;
    uninstall(name: string): Promise<void>;
    update(): Promise<void>;
    private ensurePJSON;
    private isValidPlugin;
    private maybeCleanUp;
    private npmHasPackage;
    private readPJSON;
    private savePJSON;
}
export {};
