/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { AuthEmailCodeRequest, AuthEmailVerifyRequest, AuthFinishOIDCRequest, AuthResponse, AuthSignOutResponse, AuthStartOIDCResponse } from '../models/index.js';
export interface FinishOIDCRequest {
    authFinishOIDCRequest: AuthFinishOIDCRequest;
}
export interface GetEmailCodeRequest {
    authEmailCodeRequest: AuthEmailCodeRequest;
}
export interface VerifyEmailCodeRequest {
    authEmailVerifyRequest: AuthEmailVerifyRequest;
}
/**
 *
 */
export declare class AuthApi extends runtime.BaseAPI {
    /**
     * Clear a verified email session
     */
    clearVerifiedEmailRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Clear a verified email session
     */
    clearVerifiedEmail(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Finishes OIDC flow
     */
    finishOIDCRaw(requestParameters: FinishOIDCRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Finishes OIDC flow
     */
    finishOIDC(requestParameters: FinishOIDCRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get the auth state and associated user for the request
     */
    getAuthStateRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthResponse>>;
    /**
     * Get the auth state and associated user for the request
     */
    getAuthState(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthResponse>;
    /**
     * Send a verification code to a chosen email address.
     */
    getEmailCodeRaw(requestParameters: GetEmailCodeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Send a verification code to a chosen email address.
     */
    getEmailCode(requestParameters: GetEmailCodeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Sign out of current session
     */
    signOutRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthSignOutResponse>>;
    /**
     * Sign out of current session
     */
    signOut(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthSignOutResponse>;
    /**
     * Starts OIDC flow
     */
    startOIDCRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthStartOIDCResponse>>;
    /**
     * Starts OIDC flow
     */
    startOIDC(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthStartOIDCResponse>;
    /**
     * Verify an email address for the current session.
     */
    verifyEmailCodeRaw(requestParameters: VerifyEmailCodeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Verify an email address for the current session.
     */
    verifyEmailCode(requestParameters: VerifyEmailCodeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
}
