/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { FileCreateRequest, FileResponse, FileStartUploadRequest, FileStartUploadResponse, FileURLResponse, FileUpdateRequest, FileVerifyUploadRequest } from '../models/index.js';
export interface CreateFileRequest {
    fileCreateRequest: FileCreateRequest;
}
export interface DeleteFileRequest {
    fileId: string;
}
export interface GetContentUrlRequest {
    fileId: string;
    trebuchetChallenge: string;
}
export interface GetFileRequest {
    fileId: string;
    expand?: Array<GetFileExpandEnum>;
}
export interface GetFileEventsRequest {
    fileId: string;
}
export interface GetFilesRequest {
    flags?: number;
    state?: Array<GetFilesStateEnum>;
    expiredDays?: number;
    matchId?: string;
    inviteId?: string;
}
export interface GetMetaUrlRequest {
    fileId: string;
    trebuchetChallenge: string;
}
export interface StartFileUploadRequest {
    fileId: string;
    fileStartUploadRequest: FileStartUploadRequest;
}
export interface UpdateFileRequest {
    fileId: string;
    fileUpdateRequest: FileUpdateRequest;
}
export interface VerifyFileUploadRequest {
    fileId: string;
    fileVerifyUploadRequest: FileVerifyUploadRequest;
}
/**
 *
 */
export declare class FilesApi extends runtime.BaseAPI {
    /**
     * Create an upload
     */
    createFileRaw(requestParameters: CreateFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FileResponse>>;
    /**
     * Create an upload
     */
    createFile(requestParameters: CreateFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FileResponse>;
    /**
     * Delete a file by ID
     */
    deleteFileRaw(requestParameters: DeleteFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Delete a file by ID
     */
    deleteFile(requestParameters: DeleteFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get the download URL for the encrypted content
     */
    getContentUrlRaw(requestParameters: GetContentUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FileURLResponse>>;
    /**
     * Get the download URL for the encrypted content
     */
    getContentUrl(requestParameters: GetContentUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FileURLResponse>;
    /**
     * Get the metadata associated with a specific file
     */
    getFileRaw(requestParameters: GetFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FileResponse>>;
    /**
     * Get the metadata associated with a specific file
     */
    getFile(requestParameters: GetFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FileResponse>;
    /**
     * Get the events for a file
     */
    getFileEventsRaw(requestParameters: GetFileEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<object>>>;
    /**
     * Get the events for a file
     */
    getFileEvents(requestParameters: GetFileEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<object>>;
    /**
     * Get files for the current user
     */
    getFilesRaw(requestParameters: GetFilesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<FileResponse>>>;
    /**
     * Get files for the current user
     */
    getFiles(requestParameters?: GetFilesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<FileResponse>>;
    /**
     * Get the download URL for the encrypted metadata
     */
    getMetaUrlRaw(requestParameters: GetMetaUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FileURLResponse>>;
    /**
     * Get the download URL for the encrypted metadata
     */
    getMetaUrl(requestParameters: GetMetaUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FileURLResponse>;
    /**
     * Get the download URL for the encrypted metadata
     */
    startFileUploadRaw(requestParameters: StartFileUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FileStartUploadResponse>>;
    /**
     * Get the download URL for the encrypted metadata
     */
    startFileUpload(requestParameters: StartFileUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FileStartUploadResponse>;
    /**
     * Update a file
     */
    updateFileRaw(requestParameters: UpdateFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FileResponse>>;
    /**
     * Update a file
     */
    updateFile(requestParameters: UpdateFileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FileResponse>;
    /**
     * Verify the upload was successful
     */
    verifyFileUploadRaw(requestParameters: VerifyFileUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Verify the upload was successful
     */
    verifyFileUpload(requestParameters: VerifyFileUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
}
/**
 * @export
 */
export declare const GetFileExpandEnum: {
    readonly User: "user";
    readonly Invite: "invite";
};
export type GetFileExpandEnum = (typeof GetFileExpandEnum)[keyof typeof GetFileExpandEnum];
/**
 * @export
 */
export declare const GetFilesStateEnum: {
    readonly Created: "created";
    readonly UploadStarted: "upload_started";
    readonly WriteComplete: "write_complete";
    readonly Deleted: "deleted";
};
export type GetFilesStateEnum = (typeof GetFilesStateEnum)[keyof typeof GetFilesStateEnum];
