/* tslint:disable */
/* eslint-disable */
/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import { FileCreateRequestToJSON, FileResponseFromJSON, FileStartUploadRequestToJSON, FileStartUploadResponseFromJSON, FileURLResponseFromJSON, FileUpdateRequestToJSON, FileVerifyUploadRequestToJSON, } from '../models/index.js';
/**
 *
 */
export class FilesApi extends runtime.BaseAPI {
    /**
     * Create an upload
     */
    async createFileRaw(requestParameters, initOverrides) {
        if (requestParameters['fileCreateRequest'] == null) {
            throw new runtime.RequiredError('fileCreateRequest', 'Required parameter "fileCreateRequest" was null or undefined when calling createFile().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FileCreateRequestToJSON(requestParameters['fileCreateRequest']),
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => FileResponseFromJSON(jsonValue));
    }
    /**
     * Create an upload
     */
    async createFile(requestParameters, initOverrides) {
        const response = await this.createFileRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Delete a file by ID
     */
    async deleteFileRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling deleteFile().');
        }
        const queryParameters = {};
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.VoidApiResponse(response);
    }
    /**
     * Delete a file by ID
     */
    async deleteFile(requestParameters, initOverrides) {
        await this.deleteFileRaw(requestParameters, initOverrides);
    }
    /**
     * Get the download URL for the encrypted content
     */
    async getContentUrlRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling getContentUrl().');
        }
        if (requestParameters['trebuchetChallenge'] == null) {
            throw new runtime.RequiredError('trebuchetChallenge', 'Required parameter "trebuchetChallenge" was null or undefined when calling getContentUrl().');
        }
        const queryParameters = {};
        const headerParameters = {};
        if (requestParameters['trebuchetChallenge'] != null) {
            headerParameters['Trebuchet-Challenge'] = String(requestParameters['trebuchetChallenge']);
        }
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}/content`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => FileURLResponseFromJSON(jsonValue));
    }
    /**
     * Get the download URL for the encrypted content
     */
    async getContentUrl(requestParameters, initOverrides) {
        const response = await this.getContentUrlRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get the metadata associated with a specific file
     */
    async getFileRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling getFile().');
        }
        const queryParameters = {};
        if (requestParameters['expand'] != null) {
            queryParameters['expand'] = requestParameters['expand'];
        }
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => FileResponseFromJSON(jsonValue));
    }
    /**
     * Get the metadata associated with a specific file
     */
    async getFile(requestParameters, initOverrides) {
        const response = await this.getFileRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get the events for a file
     */
    async getFileEventsRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling getFileEvents().');
        }
        const queryParameters = {};
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}/events`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response);
    }
    /**
     * Get the events for a file
     */
    async getFileEvents(requestParameters, initOverrides) {
        const response = await this.getFileEventsRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get files for the current user
     */
    async getFilesRaw(requestParameters, initOverrides) {
        const queryParameters = {};
        if (requestParameters['flags'] != null) {
            queryParameters['flags'] = requestParameters['flags'];
        }
        if (requestParameters['state'] != null) {
            queryParameters['state'] = requestParameters['state'];
        }
        if (requestParameters['expiredDays'] != null) {
            queryParameters['expired_days'] = requestParameters['expiredDays'];
        }
        if (requestParameters['matchId'] != null) {
            queryParameters['match_id'] = requestParameters['matchId'];
        }
        if (requestParameters['inviteId'] != null) {
            queryParameters['invite_id'] = requestParameters['inviteId'];
        }
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(FileResponseFromJSON));
    }
    /**
     * Get files for the current user
     */
    async getFiles(requestParameters = {}, initOverrides) {
        const response = await this.getFilesRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get the download URL for the encrypted metadata
     */
    async getMetaUrlRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling getMetaUrl().');
        }
        if (requestParameters['trebuchetChallenge'] == null) {
            throw new runtime.RequiredError('trebuchetChallenge', 'Required parameter "trebuchetChallenge" was null or undefined when calling getMetaUrl().');
        }
        const queryParameters = {};
        const headerParameters = {};
        if (requestParameters['trebuchetChallenge'] != null) {
            headerParameters['Trebuchet-Challenge'] = String(requestParameters['trebuchetChallenge']);
        }
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}/meta`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => FileURLResponseFromJSON(jsonValue));
    }
    /**
     * Get the download URL for the encrypted metadata
     */
    async getMetaUrl(requestParameters, initOverrides) {
        const response = await this.getMetaUrlRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get the download URL for the encrypted metadata
     */
    async startFileUploadRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling startFileUpload().');
        }
        if (requestParameters['fileStartUploadRequest'] == null) {
            throw new runtime.RequiredError('fileStartUploadRequest', 'Required parameter "fileStartUploadRequest" was null or undefined when calling startFileUpload().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}/upload`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FileStartUploadRequestToJSON(requestParameters['fileStartUploadRequest']),
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => FileStartUploadResponseFromJSON(jsonValue));
    }
    /**
     * Get the download URL for the encrypted metadata
     */
    async startFileUpload(requestParameters, initOverrides) {
        const response = await this.startFileUploadRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Update a file
     */
    async updateFileRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling updateFile().');
        }
        if (requestParameters['fileUpdateRequest'] == null) {
            throw new runtime.RequiredError('fileUpdateRequest', 'Required parameter "fileUpdateRequest" was null or undefined when calling updateFile().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: FileUpdateRequestToJSON(requestParameters['fileUpdateRequest']),
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => FileResponseFromJSON(jsonValue));
    }
    /**
     * Update a file
     */
    async updateFile(requestParameters, initOverrides) {
        const response = await this.updateFileRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Verify the upload was successful
     */
    async verifyFileUploadRaw(requestParameters, initOverrides) {
        if (requestParameters['fileId'] == null) {
            throw new runtime.RequiredError('fileId', 'Required parameter "fileId" was null or undefined when calling verifyFileUpload().');
        }
        if (requestParameters['fileVerifyUploadRequest'] == null) {
            throw new runtime.RequiredError('fileVerifyUploadRequest', 'Required parameter "fileVerifyUploadRequest" was null or undefined when calling verifyFileUpload().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/files/{file_id}/verify`.replace(`{${'file_id'}}`, encodeURIComponent(String(requestParameters['fileId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FileVerifyUploadRequestToJSON(requestParameters['fileVerifyUploadRequest']),
        }, initOverrides);
        return new runtime.VoidApiResponse(response);
    }
    /**
     * Verify the upload was successful
     */
    async verifyFileUpload(requestParameters, initOverrides) {
        await this.verifyFileUploadRaw(requestParameters, initOverrides);
    }
}
/**
 * @export
 */
export const GetFileExpandEnum = {
    User: 'user',
    Invite: 'invite',
};
/**
 * @export
 */
export const GetFilesStateEnum = {
    Created: 'created',
    UploadStarted: 'upload_started',
    WriteComplete: 'write_complete',
    Deleted: 'deleted',
};
