/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { InviteCreateRequest, InviteResponse, InviteStartUploadRequest, InviteStartUploadResponse, InviteUpdateRequest, InviteVerifyUploadRequest, UserSummaryResponse } from '../models/index.js';
export interface CreateInviteRequest {
    inviteCreateRequest: InviteCreateRequest;
}
export interface DeleteInviteRequest {
    inviteId: string;
}
export interface GetInviteRequest {
    inviteId: string;
}
export interface GetInviteEventsRequest {
    inviteId: string;
}
export interface GetInviteUserRequest {
    inviteId: string;
}
export interface GetInvitesRequest {
    state?: Array<GetInvitesStateEnum>;
    matchId?: string;
}
export interface StartUploadRequest {
    inviteId: string;
    inviteStartUploadRequest: InviteStartUploadRequest;
}
export interface UpdateInviteRequest {
    inviteId: string;
    inviteUpdateRequest: InviteUpdateRequest;
}
export interface VerifyInviteUploadRequest {
    inviteId: string;
    inviteVerifyUploadRequest: InviteVerifyUploadRequest;
}
/**
 *
 */
export declare class InvitesApi extends runtime.BaseAPI {
    /**
     * Create an invite
     */
    createInviteRaw(requestParameters: CreateInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InviteResponse>>;
    /**
     * Create an invite
     */
    createInvite(requestParameters: CreateInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InviteResponse>;
    /**
     * Delete an invite by ID
     */
    deleteInviteRaw(requestParameters: DeleteInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Delete an invite by ID
     */
    deleteInvite(requestParameters: DeleteInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get the metadata associated with a specific Invite
     */
    getInviteRaw(requestParameters: GetInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InviteResponse>>;
    /**
     * Get the metadata associated with a specific Invite
     */
    getInvite(requestParameters: GetInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InviteResponse>;
    /**
     * Get the events for an invite
     */
    getInviteEventsRaw(requestParameters: GetInviteEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<object>>>;
    /**
     * Get the events for an invite
     */
    getInviteEvents(requestParameters: GetInviteEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<object>>;
    /**
     * Get the user info for an invite
     */
    getInviteUserRaw(requestParameters: GetInviteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSummaryResponse>>;
    /**
     * Get the user info for an invite
     */
    getInviteUser(requestParameters: GetInviteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSummaryResponse>;
    /**
     * Get invites for the current user
     */
    getInvitesRaw(requestParameters: GetInvitesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<InviteResponse>>>;
    /**
     * Get invites for the current user
     */
    getInvites(requestParameters?: GetInvitesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<InviteResponse>>;
    /**
     * Create a file upload in response to a specific Invite
     */
    startUploadRaw(requestParameters: StartUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InviteStartUploadResponse>>;
    /**
     * Create a file upload in response to a specific Invite
     */
    startUpload(requestParameters: StartUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InviteStartUploadResponse>;
    /**
     * Update an invite
     */
    updateInviteRaw(requestParameters: UpdateInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InviteResponse>>;
    /**
     * Update an invite
     */
    updateInvite(requestParameters: UpdateInviteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InviteResponse>;
    /**
     * Complete the file upload associated with a specific Invite
     */
    verifyInviteUploadRaw(requestParameters: VerifyInviteUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Complete the file upload associated with a specific Invite
     */
    verifyInviteUpload(requestParameters: VerifyInviteUploadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
}
/**
 * @export
 */
export declare const GetInvitesStateEnum: {
    readonly Active: "active";
    readonly Archived: "archived";
};
export type GetInvitesStateEnum = (typeof GetInvitesStateEnum)[keyof typeof GetInvitesStateEnum];
