/* tslint:disable */
/* eslint-disable */
/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import { InviteCreateRequestToJSON, InviteResponseFromJSON, InviteStartUploadRequestToJSON, InviteStartUploadResponseFromJSON, InviteUpdateRequestToJSON, InviteVerifyUploadRequestToJSON, UserSummaryResponseFromJSON, } from '../models/index.js';
/**
 *
 */
export class InvitesApi extends runtime.BaseAPI {
    /**
     * Create an invite
     */
    async createInviteRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteCreateRequest'] == null) {
            throw new runtime.RequiredError('inviteCreateRequest', 'Required parameter "inviteCreateRequest" was null or undefined when calling createInvite().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/invites`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: InviteCreateRequestToJSON(requestParameters['inviteCreateRequest']),
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => InviteResponseFromJSON(jsonValue));
    }
    /**
     * Create an invite
     */
    async createInvite(requestParameters, initOverrides) {
        const response = await this.createInviteRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Delete an invite by ID
     */
    async deleteInviteRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling deleteInvite().');
        }
        const queryParameters = {};
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/invites/{invite_id}`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.VoidApiResponse(response);
    }
    /**
     * Delete an invite by ID
     */
    async deleteInvite(requestParameters, initOverrides) {
        await this.deleteInviteRaw(requestParameters, initOverrides);
    }
    /**
     * Get the metadata associated with a specific Invite
     */
    async getInviteRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling getInvite().');
        }
        const queryParameters = {};
        const headerParameters = {};
        const response = await this.request({
            path: `/invites/{invite_id}`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => InviteResponseFromJSON(jsonValue));
    }
    /**
     * Get the metadata associated with a specific Invite
     */
    async getInvite(requestParameters, initOverrides) {
        const response = await this.getInviteRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get the events for an invite
     */
    async getInviteEventsRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling getInviteEvents().');
        }
        const queryParameters = {};
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/invites/{invite_id}/events`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response);
    }
    /**
     * Get the events for an invite
     */
    async getInviteEvents(requestParameters, initOverrides) {
        const response = await this.getInviteEventsRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get the user info for an invite
     */
    async getInviteUserRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling getInviteUser().');
        }
        const queryParameters = {};
        const headerParameters = {};
        const response = await this.request({
            path: `/invites/{invite_id}/user`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => UserSummaryResponseFromJSON(jsonValue));
    }
    /**
     * Get the user info for an invite
     */
    async getInviteUser(requestParameters, initOverrides) {
        const response = await this.getInviteUserRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Get invites for the current user
     */
    async getInvitesRaw(requestParameters, initOverrides) {
        const queryParameters = {};
        if (requestParameters['state'] != null) {
            queryParameters['state'] = requestParameters['state'];
        }
        if (requestParameters['matchId'] != null) {
            queryParameters['match_id'] = requestParameters['matchId'];
        }
        const headerParameters = {};
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/invites`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(InviteResponseFromJSON));
    }
    /**
     * Get invites for the current user
     */
    async getInvites(requestParameters = {}, initOverrides) {
        const response = await this.getInvitesRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Create a file upload in response to a specific Invite
     */
    async startUploadRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling startUpload().');
        }
        if (requestParameters['inviteStartUploadRequest'] == null) {
            throw new runtime.RequiredError('inviteStartUploadRequest', 'Required parameter "inviteStartUploadRequest" was null or undefined when calling startUpload().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/invites/{invite_id}/upload`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: InviteStartUploadRequestToJSON(requestParameters['inviteStartUploadRequest']),
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => InviteStartUploadResponseFromJSON(jsonValue));
    }
    /**
     * Create a file upload in response to a specific Invite
     */
    async startUpload(requestParameters, initOverrides) {
        const response = await this.startUploadRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Update an invite
     */
    async updateInviteRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling updateInvite().');
        }
        if (requestParameters['inviteUpdateRequest'] == null) {
            throw new runtime.RequiredError('inviteUpdateRequest', 'Required parameter "inviteUpdateRequest" was null or undefined when calling updateInvite().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token('APIKey', []);
            if (tokenString) {
                headerParameters['Authorization'] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/invites/{invite_id}`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: InviteUpdateRequestToJSON(requestParameters['inviteUpdateRequest']),
        }, initOverrides);
        return new runtime.JSONApiResponse(response, (jsonValue) => InviteResponseFromJSON(jsonValue));
    }
    /**
     * Update an invite
     */
    async updateInvite(requestParameters, initOverrides) {
        const response = await this.updateInviteRaw(requestParameters, initOverrides);
        return await response.value();
    }
    /**
     * Complete the file upload associated with a specific Invite
     */
    async verifyInviteUploadRaw(requestParameters, initOverrides) {
        if (requestParameters['inviteId'] == null) {
            throw new runtime.RequiredError('inviteId', 'Required parameter "inviteId" was null or undefined when calling verifyInviteUpload().');
        }
        if (requestParameters['inviteVerifyUploadRequest'] == null) {
            throw new runtime.RequiredError('inviteVerifyUploadRequest', 'Required parameter "inviteVerifyUploadRequest" was null or undefined when calling verifyInviteUpload().');
        }
        const queryParameters = {};
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/invites/{invite_id}/verify`.replace(`{${'invite_id'}}`, encodeURIComponent(String(requestParameters['inviteId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: InviteVerifyUploadRequestToJSON(requestParameters['inviteVerifyUploadRequest']),
        }, initOverrides);
        return new runtime.VoidApiResponse(response);
    }
    /**
     * Complete the file upload associated with a specific Invite
     */
    async verifyInviteUpload(requestParameters, initOverrides) {
        await this.verifyInviteUploadRaw(requestParameters, initOverrides);
    }
}
/**
 * @export
 */
export const GetInvitesStateEnum = {
    Active: 'active',
    Archived: 'archived',
};
