/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 * OpenID Connect authentication settings
 * @export
 * @interface OIDCConfig
 */
export interface OIDCConfig {
    /**
     * OIDC provider
     * @type {string}
     * @memberof OIDCConfig
     */
    authority: string;
    /**
     * Client ID configured in the OIDC provider
     * @type {string}
     * @memberof OIDCConfig
     */
    clientId: string;
    /**
     * List of requested scopes
     * @type {string}
     * @memberof OIDCConfig
     */
    scope: string;
    /**
     * Redirect to pass to authorize and end session endpoints
     * @type {string}
     * @memberof OIDCConfig
     */
    redirectUri: string;
    /**
     * Enable registration via prompt=create
     * @type {boolean}
     * @memberof OIDCConfig
     */
    registration?: boolean;
}
/**
 * Check if a given object implements the OIDCConfig interface.
 */
export declare function instanceOfOIDCConfig(value: object): value is OIDCConfig;
export declare function OIDCConfigFromJSON(json: any): OIDCConfig;
export declare function OIDCConfigFromJSONTyped(json: any, ignoreDiscriminator: boolean): OIDCConfig;
export declare function OIDCConfigToJSON(json: any): OIDCConfig;
export declare function OIDCConfigToJSONTyped(value?: OIDCConfig | null, ignoreDiscriminator?: boolean): any;
