import { Keychain } from './keychain.js';
import type { SDK } from './sdk.js';
import { FileResponse } from './api/index.js';
export type DownloadProgressCallback = (bytesDone: number, rate: number) => void;
export type FileMetadata = {
    name: string;
    type: string;
    size: number;
    files?: Array<{
        name: string;
        type: string;
        size: number;
    }>;
};
export declare class Download extends Keychain {
    protected sdk: SDK;
    fileId: string;
    progressCb?: DownloadProgressCallback | undefined;
    info?: FileResponse;
    meta?: FileMetadata;
    private abortController;
    private fetch;
    private bytesDone;
    private startTime;
    private contentType?;
    constructor(sdk: SDK, fileId: string, progressCb?: DownloadProgressCallback | undefined);
    get passwordRequired(): boolean;
    get verifyRecipient(): boolean;
    get urlFragment(): boolean;
    get sharedSecret(): boolean;
    abort(): void;
    getInfo(): Promise<FileResponse>;
    getMeta(): Promise<FileMetadata>;
    getContent(path: string): Promise<void>;
    private signNonce;
    private decryptMetadata;
}
