export declare class Keychain {
    protected salt?: Uint8Array<ArrayBuffer>;
    protected fragment?: Uint8Array<ArrayBuffer>;
    protected password?: string;
    protected passwordBits?: ArrayBuffer;
    protected privateKey?: CryptoKey;
    protected publicKey?: CryptoKey;
    protected peerPublicKey?: CryptoKey;
    protected initialKey?: CryptoKey;
    protected intermediateKey?: CryptoKey;
    protected rawBits?: ArrayBuffer;
    protected metaKey?: CryptoKey;
    protected authKey?: CryptoKey;
    protected rawContentKey?: Uint8Array<ArrayBuffer>;
    keygen(): Promise<void>;
    private reset;
    setPassword(password: string): void;
    setFragment(fragment: string): void;
    setPeerPublicKeyHex(pubKey: string): Promise<void>;
    setPrivateKeyJwk(privKey: JsonWebKey): Promise<void>;
    genKeyPair(): Promise<void>;
    getPublicKeyHex(): Promise<string>;
    getPrivateKeyJwk(): Promise<JsonWebKey>;
    private genSharedSecret;
    private genPasswordBits;
    private genInitialKey;
    private genIntermediateKey;
    private genRawBits;
    private genMetaKey;
    private genAuthKey;
    private genContentKey;
    protected getAuthKeyHex(): Promise<string>;
}
