import { AuthApi, ConfigApi, FilesApi, InvitesApi } from './api/index.js';
import { Configuration } from './api/runtime.js';
export class SDK {
    authApi;
    configApi;
    filesApi;
    invitesApi;
    cachedAuthState;
    config;
    params = {};
    constructor(basePath, apiKey) {
        this.params.basePath = basePath;
        this.params.accessToken = apiKey;
        this.params.middleware = [
            {
                async pre(context) {
                    context.init.headers['Trebuchet-Device'] = '00000000-0000-0000-0000-000000000000';
                },
            },
        ];
        this.config = new Configuration(this.params);
        this.authApi = new AuthApi(this.config);
        this.configApi = new ConfigApi(this.config);
        this.filesApi = new FilesApi(this.config);
        this.invitesApi = new InvitesApi(this.config);
    }
    async getAuthState(reload) {
        if (!this.cachedAuthState || reload) {
            this.cachedAuthState = await this.authApi.getAuthState();
        }
        return this.cachedAuthState;
    }
}
