import { FileHandle } from 'node:fs/promises';
import { ReadableStream } from 'node:stream/web';
export declare function stringStream(data: string, size?: number): ReadableStream<Uint8Array<ArrayBufferLike>>;
export declare function fileStream(fd: FileHandle, size?: number): ReadableStream<Uint8Array<ArrayBufferLike>>;
export declare function concatStream(streams: ReadableStream[]): ReadableStream<Uint8Array<ArrayBufferLike>>;
export declare function transformStream(readable: ReadableStream, transformer: Transformer): ReadableStream<any>;
export declare class StreamSlicer implements Transformer<Uint8Array, Uint8Array> {
    private chunkSize;
    private progressCallback?;
    private partialChunk;
    private offset;
    constructor(chunkSize: number, progressCallback?: ((p: number) => void) | undefined);
    send(buf: Uint8Array, controller: TransformStreamDefaultController<Uint8Array>): void;
    transform(chunk: Uint8Array, controller: TransformStreamDefaultController<Uint8Array>): void;
    flush(controller: TransformStreamDefaultController<Uint8Array>): void;
}
