import table from 'tty-table';
import { BaseCommand } from '../base.js';
export default class Auth extends BaseCommand {
    static description = 'Show authentication information.';
    static enableJsonFlag = true;
    async run() {
        const header = [
            { align: 'left', color: 'yellow', value: '' },
            { align: 'left', value: 'Value' },
        ];
        const rows = [];
        const auth = await this.sdk.getAuthState();
        rows.push(['Authenticated', auth.authenticated], ['Email', auth.user?.email], ['Name', auth.user?.name], ['User ID', auth.user?.publicId]);
        this.log(table(header, rows).render());
        return auth;
    }
}
