import table from 'tty-table';
import { BaseCommand } from '../../base.js';
export default class Config extends BaseCommand {
    static description = 'Show current configuration.';
    static enableJsonFlag = true;
    async run() {
        const header = [
            { align: 'left', color: 'yellow', value: 'Setting' },
            { align: 'left', value: 'Value' },
        ];
        const rows = [];
        rows.push(['XDG_CONFIG_HOME', this.config.configDir], ['XDG_DATA_HOME', this.config.dataDir], [
            this.config.scopedEnvVarKey('API_KEY'),
            this.userConfig.apiKey === 'NONE' ? 'Not set' : 'ID: ' + this.userConfig.apiKey.split('.')[0],
        ], [this.config.scopedEnvVarKey('BASE_URL'), this.userConfig.baseUrl], [this.config.scopedEnvVarKey('DEFAULT_DOWNLOADS'), this.userConfig.defaultDownloads], [this.config.scopedEnvVarKey('DEFAULT_EXPIRY_DAYS'), this.userConfig.defaultExpiryDays]);
        this.log(table(header, rows).render());
        const copy = { ...this.userConfig };
        copy.apiKey = copy.apiKey.split('.')[0];
        return copy;
    }
}
