import { Args, Flags } from '@oclif/core';
import { Keychain } from '@trebuchet/sdk-nodejs';
import { DateTime } from 'luxon';
import { BaseCommand } from '../../base.js';
export default class RequestCreate extends BaseCommand {
    static args = {
        subject: Args.string({
            description: 'Subject',
            required: true,
        }),
    };
    static description = 'Create a new sharing request.';
    static enableJsonFlag = true;
    static flags = {
        deadline: Flags.string({
            char: 'd',
            summary: 'Request deadline (format: yyyy/MM/dd HH:mm)',
        }),
        'deadline-epoch': Flags.integer({
            char: 'e',
            summary: 'Request deadline (epoch time)',
        }),
    };
    async run() {
        let deadline;
        const kc = new Keychain();
        await kc.genKeyPair();
        if (this.flags.deadline) {
            deadline = DateTime.fromFormat(this.flags.exp, 'yyyy/MM/dd HH:mm').toJSDate();
        }
        else if (this.flags['deadline-epoch']) {
            deadline = DateTime.fromSeconds(this.flags['deadline-epoch']).toJSDate();
        }
        const res = await this.sdk.invitesApi.createInvite({
            inviteCreateRequest: {
                exp: deadline,
                publicKey: await kc.getPublicKeyHex(),
                subject: this.args.subject,
            },
        });
        // eslint-disable-next-line camelcase
        await this.setInvite(res.publicId, { private_key: await kc.getPrivateKeyJwk() });
        return this.logInvite(res);
    }
}
