import { Flags } from '@oclif/core';
import table from 'tty-table';
import { BaseCommand } from '../../base.js';
export default class RequestList extends BaseCommand {
    static description = 'List active requests.';
    static enableJsonFlag = true;
    static flags = {
        archived: Flags.boolean({ description: 'Show archived requests.' }),
    };
    async run() {
        const res = await this.sdk.invitesApi.getInvites({ state: [this.flags.archived ? 'archived' : 'active'] });
        const header = [
            { value: 'ID' },
            { value: 'Subject' },
            {
                formatter: (val) => this.dateToString(val),
                value: 'Created',
            },
            {
                formatter: (val) => this.dateToString(val, 'Not set'),
                value: 'Deadline',
            },
            { value: 'Received Files' },
        ];
        const rows = res.map((row) => [row.publicId, row.subject, row.created, row.exp || '', row.files?.activeCount || 0]);
        this.log(table(header, rows).render());
        return res;
    }
}
