import { Flags } from '@oclif/core';
import { colorize } from '@oclif/core/ux';
import table from 'tty-table';
import { BaseCommand } from '../../base.js';
export default class SendList extends BaseCommand {
    static description = 'List active transfers.';
    static enableJsonFlag = true;
    static flags = {
        expiredDays: Flags.integer({
            char: 'e',
            default: 0,
            max: 30,
            min: 0,
            summary: 'Expired days to include',
        }),
    };
    async run() {
        const res = await this.sdk.filesApi.getFiles({
            expiredDays: this.flags.expiredDays,
            flags: 1,
            state: ['write_complete'],
        });
        const header = [
            { value: 'ID' },
            { value: 'Description' },
            { value: 'Size' },
            {
                formatter: (val) => this.dateToString(val),
                value: 'Created',
            },
            { value: 'Max' },
            {
                formatter(cellValue, columnIndex, rowIndex, rowData) {
                    return cellValue >= rowData[rowIndex][columnIndex - 1] ? colorize('red', cellValue) : cellValue;
                },
                value: 'Count',
            },
            {
                formatter: (val) => this.dateToString(val),
                value: 'Expires',
            },
        ];
        const rows = res.map((row) => [row.publicId, row.description, row.size, row.created, row.max, row.count, row.exp]);
        this.log(table(header, rows).render());
        return res;
    }
}
