import { UploadMetadata } from '@trebuchet/sdk-nodejs';
import { BaseCommand } from '../../base.js';
export default class Message extends BaseCommand<typeof Message> {
    static aliases: string[];
    static args: {
        message: import("@oclif/core/interfaces").Arg<string | undefined, Record<string, unknown>>;
    };
    static description: string;
    static enableJsonFlag: boolean;
    static flags: {
        count: import("@oclif/core/interfaces").OptionFlag<number | undefined, import("@oclif/core/interfaces").CustomOptions>;
        desc: import("@oclif/core/interfaces").OptionFlag<string, import("@oclif/core/interfaces").CustomOptions>;
        exp: import("@oclif/core/interfaces").OptionFlag<number | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'add-password': import("@oclif/core/interfaces").BooleanFlag<boolean>;
        'generate-password': import("@oclif/core/interfaces").BooleanFlag<boolean>;
        recipient: import("@oclif/core/interfaces").OptionFlag<string[] | undefined, import("@oclif/core/interfaces").CustomOptions>;
        verify: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        subject: import("@oclif/core/interfaces").OptionFlag<string, import("@oclif/core/interfaces").CustomOptions>;
        format: import("@oclif/core/interfaces").OptionFlag<string, import("@oclif/core/interfaces").CustomOptions>;
    };
    run(): Promise<{
        code: string;
        link: string;
        metadata: UploadMetadata;
        password?: string;
    }>;
}
