/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { AdminGroupsUpdateRequest, CreateGroupRequest, GroupResponse } from '../models/index.js';
export interface AddRoleToGroupRequest {
    id: string;
    role: string;
}
export interface CreateGroupOperationRequest {
    createGroupRequest: CreateGroupRequest;
}
export interface GetGroupByIDRequest {
    id: string;
    expand?: Array<GetGroupByIDExpandEnum>;
}
export interface GetGroupsRequest {
    tenantId?: string;
    expand?: Array<GetGroupsExpandEnum>;
}
export interface RemoveRoleFromGroupRequest {
    id: string;
    role: string;
}
export interface UpdateGroupByIDRequest {
    id: string;
    adminGroupsUpdateRequest: AdminGroupsUpdateRequest;
}
/**
 *
 */
export declare class AdminGroupsApi extends runtime.BaseAPI {
    /**
     * Add role to group
     */
    addRoleToGroupRaw(requestParameters: AddRoleToGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Add role to group
     */
    addRoleToGroup(requestParameters: AddRoleToGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Create new group
     */
    createGroupRaw(requestParameters: CreateGroupOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GroupResponse>>;
    /**
     * Create new group
     */
    createGroup(requestParameters: CreateGroupOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GroupResponse>;
    /**
     * Get group
     */
    getGroupByIDRaw(requestParameters: GetGroupByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GroupResponse>>;
    /**
     * Get group
     */
    getGroupByID(requestParameters: GetGroupByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GroupResponse>;
    /**
     * Get all groups
     */
    getGroupsRaw(requestParameters: GetGroupsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<GroupResponse>>>;
    /**
     * Get all groups
     */
    getGroups(requestParameters?: GetGroupsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<GroupResponse>>;
    /**
     * Remove role from group
     */
    removeRoleFromGroupRaw(requestParameters: RemoveRoleFromGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Remove role from group
     */
    removeRoleFromGroup(requestParameters: RemoveRoleFromGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Update group
     */
    updateGroupByIDRaw(requestParameters: UpdateGroupByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GroupResponse>>;
    /**
     * Update group
     */
    updateGroupByID(requestParameters: UpdateGroupByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GroupResponse>;
}
/**
 * @export
 */
export declare const GetGroupByIDExpandEnum: {
    readonly Roles: "roles";
};
export type GetGroupByIDExpandEnum = (typeof GetGroupByIDExpandEnum)[keyof typeof GetGroupByIDExpandEnum];
/**
 * @export
 */
export declare const GetGroupsExpandEnum: {
    readonly EnabledUsersCount: "enabled_users_count";
};
export type GetGroupsExpandEnum = (typeof GetGroupsExpandEnum)[keyof typeof GetGroupsExpandEnum];
