/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { AdminTenantsUpdateRequest, CreateTenantRequest, TenantResponse } from '../models/index.js';
export interface CreateTenantOperationRequest {
    createTenantRequest: CreateTenantRequest;
}
export interface DeleteTenantByIDRequest {
    id: string;
}
export interface GetTenantByIDRequest {
    id: string;
    expand?: Array<GetTenantByIDExpandEnum>;
}
export interface GetTenantsRequest {
    enabled?: boolean;
    expand?: Array<GetTenantsExpandEnum>;
}
export interface UpdateTenantByIDRequest {
    id: string;
    adminTenantsUpdateRequest: AdminTenantsUpdateRequest;
}
/**
 *
 */
export declare class AdminTenantsApi extends runtime.BaseAPI {
    /**
     * Create new tenant
     */
    createTenantRaw(requestParameters: CreateTenantOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TenantResponse>>;
    /**
     * Create new tenant
     */
    createTenant(requestParameters: CreateTenantOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TenantResponse>;
    /**
     * Delete tenant
     */
    deleteTenantByIDRaw(requestParameters: DeleteTenantByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Delete tenant
     */
    deleteTenantByID(requestParameters: DeleteTenantByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get tenant
     */
    getTenantByIDRaw(requestParameters: GetTenantByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TenantResponse>>;
    /**
     * Get tenant
     */
    getTenantByID(requestParameters: GetTenantByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TenantResponse>;
    /**
     * Get all tenants
     */
    getTenantsRaw(requestParameters: GetTenantsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<TenantResponse>>>;
    /**
     * Get all tenants
     */
    getTenants(requestParameters?: GetTenantsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<TenantResponse>>;
    /**
     * Update tenant
     */
    updateTenantByIDRaw(requestParameters: UpdateTenantByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TenantResponse>>;
    /**
     * Update tenant
     */
    updateTenantByID(requestParameters: UpdateTenantByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TenantResponse>;
}
/**
 * @export
 */
export declare const GetTenantByIDExpandEnum: {
    readonly BandwidthUsage: "bandwidth_usage";
};
export type GetTenantByIDExpandEnum = (typeof GetTenantByIDExpandEnum)[keyof typeof GetTenantByIDExpandEnum];
/**
 * @export
 */
export declare const GetTenantsExpandEnum: {
    readonly EnabledUsersCount: "enabled_users_count";
};
export type GetTenantsExpandEnum = (typeof GetTenantsExpandEnum)[keyof typeof GetTenantsExpandEnum];
