/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { AdminUsersResponse, AdminUsersUpdateRequest } from '../models/index.js';
export interface AddUserToGroupRequest {
    id: string;
    groupId: string;
}
export interface DeleteUserByIDRequest {
    id: string;
}
export interface GetUserByIDRequest {
    id: string;
    expand?: Array<GetUserByIDExpandEnum>;
}
export interface GetUsersRequest {
    tenantId?: string;
    groupId?: string;
    disabled?: boolean;
}
export interface RemoveUserFromGroupRequest {
    id: string;
    groupId: string;
}
export interface UpdateUserByIDRequest {
    id: string;
    adminUsersUpdateRequest: AdminUsersUpdateRequest;
}
/**
 *
 */
export declare class AdminUsersApi extends runtime.BaseAPI {
    /**
     * Add user to group by ID
     */
    addUserToGroupRaw(requestParameters: AddUserToGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Add user to group by ID
     */
    addUserToGroup(requestParameters: AddUserToGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Delete user
     */
    deleteUserByIDRaw(requestParameters: DeleteUserByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Delete user
     */
    deleteUserByID(requestParameters: DeleteUserByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get user
     */
    getUserByIDRaw(requestParameters: GetUserByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AdminUsersResponse>>;
    /**
     * Get user
     */
    getUserByID(requestParameters: GetUserByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AdminUsersResponse>;
    /**
     * Get all users
     */
    getUsersRaw(requestParameters: GetUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AdminUsersResponse>>>;
    /**
     * Get all users
     */
    getUsers(requestParameters?: GetUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AdminUsersResponse>>;
    /**
     * Remove user from group by ID
     */
    removeUserFromGroupRaw(requestParameters: RemoveUserFromGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Remove user from group by ID
     */
    removeUserFromGroup(requestParameters: RemoveUserFromGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Update user
     */
    updateUserByIDRaw(requestParameters: UpdateUserByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AdminUsersResponse>>;
    /**
     * Update user
     */
    updateUserByID(requestParameters: UpdateUserByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AdminUsersResponse>;
}
/**
 * @export
 */
export declare const GetUserByIDExpandEnum: {
    readonly BandwidthUsage: "bandwidth_usage";
    readonly ActiveSessions: "active_sessions";
    readonly Groups: "groups";
};
export type GetUserByIDExpandEnum = (typeof GetUserByIDExpandEnum)[keyof typeof GetUserByIDExpandEnum];
