/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime.js';
import type { StripeCreateCheckoutResponse, StripeCreatePortalResponse, UsageResponse, UserResponse, UserStatsResponse, UsersAPIKeyResponse, UsersCreateAPIKeyRequest, UsersCreateAPIKeyResponse, UsersUpdateCurrentRequest } from '../models/index.js';
export interface CreateAPIKeyRequest {
    usersCreateAPIKeyRequest: UsersCreateAPIKeyRequest;
}
export interface CreateCheckoutUrlRequest {
    product: string;
}
export interface DeleteAPIKeyByIDRequest {
    id: string;
}
export interface UpdateCurrentUserRequest {
    usersUpdateCurrentRequest: UsersUpdateCurrentRequest;
}
/**
 *
 */
export declare class UsersApi extends runtime.BaseAPI {
    /**
     * Create an API key for the user logged in to the current session
     */
    createAPIKeyRaw(requestParameters: CreateAPIKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UsersCreateAPIKeyResponse>>;
    /**
     * Create an API key for the user logged in to the current session
     */
    createAPIKey(requestParameters: CreateAPIKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UsersCreateAPIKeyResponse>;
    /**
     * Creates a Stripe checkout URL for the current user
     */
    createCheckoutUrlRaw(requestParameters: CreateCheckoutUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StripeCreateCheckoutResponse>>;
    /**
     * Creates a Stripe checkout URL for the current user
     */
    createCheckoutUrl(requestParameters: CreateCheckoutUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StripeCreateCheckoutResponse>;
    /**
     * Creates a Stripe portal URL for the current user
     */
    createPortalUrlRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StripeCreatePortalResponse>>;
    /**
     * Creates a Stripe portal URL for the current user
     */
    createPortalUrl(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StripeCreatePortalResponse>;
    /**
     * Expire API Key
     */
    deleteAPIKeyByIDRaw(requestParameters: DeleteAPIKeyByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Expire API Key
     */
    deleteAPIKeyByID(requestParameters: DeleteAPIKeyByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get current user API Keys
     */
    getApiKeysRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsersAPIKeyResponse>>>;
    /**
     * Get current user API Keys
     */
    getApiKeys(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsersAPIKeyResponse>>;
    /**
     * Get current user
     */
    getCurrentUserRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserResponse>>;
    /**
     * Get current user
     */
    getCurrentUser(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserResponse>;
    /**
     * Get usage stats for the current user
     */
    getStatsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserStatsResponse>>;
    /**
     * Get usage stats for the current user
     */
    getStats(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserStatsResponse>;
    /**
     * Get usage stats for the current user
     */
    getUserUsageRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsageResponse>>>;
    /**
     * Get usage stats for the current user
     */
    getUserUsage(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsageResponse>>;
    /**
     * Update current user fields
     */
    updateCurrentUserRaw(requestParameters: UpdateCurrentUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Update current user fields
     */
    updateCurrentUser(requestParameters: UpdateCurrentUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
}
