/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { UserResponse } from './UserResponse.js';
/**
 *
 * @export
 * @interface AuthResponse
 */
export interface AuthResponse {
    /**
     * True if the chosen authentication scheme has passed
     * @type {boolean}
     * @memberof AuthResponse
     */
    authenticated: boolean;
    /**
     * Verified email address of the logged in user or the current session
     * @type {string}
     * @memberof AuthResponse
     */
    verifiedEmail?: string;
    /**
     * Name of the authentication scheme used
     * @type {string}
     * @memberof AuthResponse
     */
    scheme?: string;
    /**
     * List of roles granted to the current user
     * @type {Array<string>}
     * @memberof AuthResponse
     */
    roles?: Array<string>;
    /**
     * Combined attributes for the current user based on group membership
     * @type {object}
     * @memberof AuthResponse
     */
    attributes?: object;
    /**
     *
     * @type {UserResponse}
     * @memberof AuthResponse
     */
    user?: UserResponse;
}
/**
 * Check if a given object implements the AuthResponse interface.
 */
export declare function instanceOfAuthResponse(value: object): value is AuthResponse;
export declare function AuthResponseFromJSON(json: any): AuthResponse;
export declare function AuthResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): AuthResponse;
export declare function AuthResponseToJSON(json: any): AuthResponse;
export declare function AuthResponseToJSONTyped(value?: AuthResponse | null, ignoreDiscriminator?: boolean): any;
