/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { TenantThemeConfig } from './TenantThemeConfig.js';
import type { TenantStripeConfig } from './TenantStripeConfig.js';
import type { TenantOneDriveConfig } from './TenantOneDriveConfig.js';
import type { OIDCConfig } from './OIDCConfig.js';
/**
 *
 * @export
 * @interface ConfigResponse
 */
export interface ConfigResponse {
    /**
     *
     * @type {string}
     * @memberof ConfigResponse
     */
    id: string;
    /**
     *
     * @type {TenantThemeConfig}
     * @memberof ConfigResponse
     */
    theme?: TenantThemeConfig;
    /**
     * Account management link
     * @type {string}
     * @memberof ConfigResponse
     */
    accountManagement?: string;
    /**
     * Total allowed monthly download bandwidth (MiB)
     * @type {number}
     * @memberof ConfigResponse
     */
    maxDownloadSizeMonthMib?: number;
    /**
     *
     * @type {TenantStripeConfig}
     * @memberof ConfigResponse
     */
    stripe?: TenantStripeConfig;
    /**
     * Terms and Conditions acceptance required
     * @type {boolean}
     * @memberof ConfigResponse
     */
    termsAndConditions: boolean;
    /**
     * Origin to use in sharing links
     * @type {string}
     * @memberof ConfigResponse
     */
    vanityUrl?: string;
    /**
     *
     * @type {OIDCConfig}
     * @memberof ConfigResponse
     */
    oidc?: OIDCConfig;
    /**
     *
     * @type {TenantOneDriveConfig}
     * @memberof ConfigResponse
     */
    onedrive?: TenantOneDriveConfig;
}
/**
 * Check if a given object implements the ConfigResponse interface.
 */
export declare function instanceOfConfigResponse(value: object): value is ConfigResponse;
export declare function ConfigResponseFromJSON(json: any): ConfigResponse;
export declare function ConfigResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): ConfigResponse;
export declare function ConfigResponseToJSON(json: any): ConfigResponse;
export declare function ConfigResponseToJSONTyped(value?: ConfigResponse | null, ignoreDiscriminator?: boolean): any;
