/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { InviteSummaryResponse } from './InviteSummaryResponse.js';
import type { UserSummaryResponse } from './UserSummaryResponse.js';
/**
 *
 * @export
 * @interface FileResponse
 */
export interface FileResponse {
    /**
     * File ID
     * @type {string}
     * @memberof FileResponse
     */
    id: string;
    /**
     * File Public ID for use in URL
     * @type {string}
     * @memberof FileResponse
     */
    publicId: string;
    /**
     * User ID of the file owner
     * @type {string}
     * @memberof FileResponse
     */
    userId: string;
    /**
     * Transfer description
     * @type {string}
     * @memberof FileResponse
     */
    description: string;
    /**
     * Transfer flags
     * @type {number}
     * @memberof FileResponse
     */
    flags: number;
    /**
     * Number of times this file has been downloaded
     * @type {number}
     * @memberof FileResponse
     */
    count: number;
    /**
     * Timestamp at which the file upload was created
     * @type {Date}
     * @memberof FileResponse
     */
    created: Date;
    /**
     * Timestamp at which the file expires
     * @type {Date}
     * @memberof FileResponse
     */
    exp?: Date;
    /**
     * Maximum number of times this file can be downloaded
     * @type {number}
     * @memberof FileResponse
     */
    max?: number;
    /**
     * Random salt used in the encrypt/decrypt process
     * @type {string}
     * @memberof FileResponse
     */
    salt?: string;
    /**
     * Authentication challenge
     * @type {string}
     * @memberof FileResponse
     */
    nonce?: string;
    /**
     * Peer public key used in keychain process
     * @type {string}
     * @memberof FileResponse
     */
    publicKey?: string;
    /**
     * Size of the encrypted content in bytes
     * @type {number}
     * @memberof FileResponse
     */
    size: number;
    /**
     * Lifecycle state of the file upload
     * @type {string}
     * @memberof FileResponse
     */
    state: string;
    /**
     * List of recipient email addresses
     * @type {Array<string>}
     * @memberof FileResponse
     */
    recipients?: Array<string>;
    /**
     *
     * @type {UserSummaryResponse}
     * @memberof FileResponse
     */
    user?: UserSummaryResponse;
    /**
     *
     * @type {InviteSummaryResponse}
     * @memberof FileResponse
     */
    invite?: InviteSummaryResponse;
}
/**
 * Check if a given object implements the FileResponse interface.
 */
export declare function instanceOfFileResponse(value: object): value is FileResponse;
export declare function FileResponseFromJSON(json: any): FileResponse;
export declare function FileResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): FileResponse;
export declare function FileResponseToJSON(json: any): FileResponse;
export declare function FileResponseToJSONTyped(value?: FileResponse | null, ignoreDiscriminator?: boolean): any;
