/**
 * Trebuchet API
 * API description for Trebuchet Secure File Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.1.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface FileSummaryResponse
 */
export interface FileSummaryResponse {
    /**
     * Invite Public ID for use in URL
     * @type {string}
     * @memberof FileSummaryResponse
     */
    publicId: string;
    /**
     * Size of the encrypted content in bytes
     * @type {number}
     * @memberof FileSummaryResponse
     */
    size: number;
    /**
     * Timestamp at which the file expires
     * @type {string}
     * @memberof FileSummaryResponse
     */
    exp?: string;
    /**
     * Maximum number of times this file can be downloaded
     * @type {number}
     * @memberof FileSummaryResponse
     */
    max?: number;
    /**
     * Number of times this file has been downloaded
     * @type {number}
     * @memberof FileSummaryResponse
     */
    count?: number;
    /**
     * Lifecycle state of the file upload
     * @type {string}
     * @memberof FileSummaryResponse
     */
    state: string;
    /**
     * Public key for use in keychain process
     * @type {string}
     * @memberof FileSummaryResponse
     */
    publicKey?: string;
}
/**
 * Check if a given object implements the FileSummaryResponse interface.
 */
export declare function instanceOfFileSummaryResponse(value: object): value is FileSummaryResponse;
export declare function FileSummaryResponseFromJSON(json: any): FileSummaryResponse;
export declare function FileSummaryResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): FileSummaryResponse;
export declare function FileSummaryResponseToJSON(json: any): FileSummaryResponse;
export declare function FileSummaryResponseToJSONTyped(value?: FileSummaryResponse | null, ignoreDiscriminator?: boolean): any;
