/**
 * Hexiosec Transfer API
 * API description for Hexiosec Transfer  ## Testing Requests  Endpoints that require authentication will use your session cookie from the main application if an API key is not provided. This is fine for testing GET requests, however POST/DELETE requests will require a CSRF token when using a session cookie. It is not possible to provide a CSRF token from this page, and so an API key must be used.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@hexiosec.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { InviteFileCountsResponse } from './InviteFileCountsResponse.js';
/**
 *
 * @export
 * @interface InviteResponse
 */
export interface InviteResponse {
    /**
     * Invite ID
     * @type {string}
     * @memberof InviteResponse
     */
    id: string;
    /**
     * Invite Public ID for use in URL
     * @type {string}
     * @memberof InviteResponse
     */
    publicId: string;
    /**
     * User ID of the invite owner
     * @type {string}
     * @memberof InviteResponse
     */
    userId: string;
    /**
     * Invitation subject or description of request
     * @type {string}
     * @memberof InviteResponse
     */
    subject?: string;
    /**
     * Timestamp at which the invite was created
     * @type {Date}
     * @memberof InviteResponse
     */
    created: Date;
    /**
     * Submission deadline
     * @type {Date}
     * @memberof InviteResponse
     */
    exp?: Date;
    /**
     * Maximum number of times the invite can be used
     * @type {number}
     * @memberof InviteResponse
     */
    max?: number;
    /**
     * Public key for use in keychain process
     * @type {string}
     * @memberof InviteResponse
     */
    publicKey?: string;
    /**
     * Lifecycle state of the invite
     * @type {string}
     * @memberof InviteResponse
     */
    state: string;
    /**
     *
     * @type {InviteFileCountsResponse}
     * @memberof InviteResponse
     */
    files?: InviteFileCountsResponse;
}
/**
 * Check if a given object implements the InviteResponse interface.
 */
export declare function instanceOfInviteResponse(value: object): value is InviteResponse;
export declare function InviteResponseFromJSON(json: any): InviteResponse;
export declare function InviteResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): InviteResponse;
export declare function InviteResponseToJSON(json: any): InviteResponse;
export declare function InviteResponseToJSONTyped(value?: InviteResponse | null, ignoreDiscriminator?: boolean): any;
