import * as u8 from './u8.js';
export function getFileSharingLink(origin, file, fragment) {
    const publicId = typeof file === 'string' ? file : file.publicId;
    return `${origin}/d/${publicId}#${fragment}`;
}
export function getFileSharingCode(file, fragment) {
    const publicId = typeof file === 'string' ? file : file.publicId;
    const id = u8.fromBasedString('base64-url', publicId);
    const frag = u8.fromBasedString('base64-url', fragment);
    const arr = new Uint8Array(id.length + frag.length);
    arr.set(id);
    arr.set(frag, id.length);
    const b32 = u8.toBasedString('base32-js', arr, true);
    return 'D' + b32.toUpperCase();
}
export function getInviteSharingLink(origin, invite) {
    return `${origin}/i/${invite.publicId}`;
}
export function getInviteSharingCode(invite) {
    const publicId = typeof invite === 'string' ? invite : invite.publicId;
    const b32 = u8.toBasedString('base32-js', u8.fromBasedString('base64-url', publicId), true);
    return 'I' + b32.toUpperCase();
}
