import { Keychain } from './keychain.js';
import { SDK } from './sdk.js';
import { CreateFileRequest, FileResponse, FileStartUploadResponse, InviteResponse, InviteStartUploadResponse } from './api/index.js';
import { FileHandle } from 'node:fs/promises';
import { ReadableStreamDefaultReader } from 'node:stream/web';
export type PendingFile = {
    data: string | FileHandle;
    name: string;
    type: string;
    size: number;
};
export type UploadProgressCallback = (bytesDone: number, total: number, rate: number) => void;
export type UploadMetadata = {
    name: string;
    type: string;
    size: number;
    files?: Array<Omit<PendingFile, 'data'>>;
};
export declare class BaseUpload extends Keychain {
    protected sdk: SDK;
    progressCb?: UploadProgressCallback | undefined;
    protected files: PendingFile[];
    protected archiveName: string;
    uploadMetadata?: UploadMetadata;
    protected abortController: AbortController;
    protected encryptedSize: number;
    protected bytesDone: number;
    protected startTime: number;
    protected uploadData: object;
    protected fetch: (input: string | Request | URL, init?: (RequestInit & import("fetch-retry").RequestInitRetryParams<typeof fetch>) | undefined) => Promise<Response>;
    constructor(sdk: SDK, progressCb?: UploadProgressCallback | undefined);
    abort(): void;
    addFile(file: PendingFile | PendingFile[]): void;
    setArchiveName(name: string): void;
    protected encryptMetadata(): Promise<ArrayBuffer>;
    protected uploadMetaGCS(config: FileStartUploadResponse | InviteStartUploadResponse): Promise<void>;
    protected uploadMetaS3(config: FileStartUploadResponse | InviteStartUploadResponse): Promise<void>;
    protected uploadStartGCS(config: FileStartUploadResponse | InviteStartUploadResponse): Promise<string>;
    protected uploadChunkGCS(reader: ReadableStreamDefaultReader, url: string): Promise<boolean>;
}
export declare class FileUpload extends BaseUpload {
    protected sdk: SDK;
    file: FileResponse;
    progressCb?: UploadProgressCallback | undefined;
    constructor(sdk: SDK, file: FileResponse, progressCb?: UploadProgressCallback | undefined);
    static createNew(sdk: SDK, params: CreateFileRequest, progressCb?: UploadProgressCallback): Promise<FileUpload>;
    get fileId(): string;
    get metadata(): UploadMetadata;
    static create(sdk: SDK, params: CreateFileRequest, progressCb?: UploadProgressCallback): Promise<FileUpload>;
    get totalSizeBytes(): number;
    get fileCount(): number;
    addMessage(subject: string, message: string, type?: string): void;
    upload(): Promise<void>;
    private uploadComplete;
}
export declare class InviteUpload extends BaseUpload {
    protected sdk: SDK;
    invite: InviteResponse;
    progressCb?: UploadProgressCallback | undefined;
    constructor(sdk: SDK, invite: InviteResponse, progressCb?: UploadProgressCallback | undefined);
    upload(): Promise<void>;
    private uploadComplete;
}
