import { PendingFile } from './upload.js';
import { ReadableStream, UnderlyingByteSource, ReadableByteStreamController } from 'stream/web';
export declare function zipStreamFiles(files: PendingFile[]): ReadableStream<Uint8Array<ArrayBufferLike>>;
export declare function crc32(uint8Array: Uint8Array, previous: number): number;
export declare class ZipStreamController implements UnderlyingByteSource {
    private files;
    type: "bytes";
    private idx;
    private offset;
    private drOffset;
    private drSize;
    private crc;
    private chunk;
    private drCache;
    private state;
    constructor(files: PendingFile[]);
    getSize(): number;
    getDate(timestamp: number | string | Date): number;
    getTime(timestamp: number | string | Date): number;
    genLFH(controller: ReadableByteStreamController): void;
    genLFDChunk(controller: ReadableByteStreamController): Promise<void>;
    genDD(controller: ReadableByteStreamController): void;
    genDR(): void;
    genEOCD(controller: ReadableByteStreamController): void;
    pull(controller: ReadableByteStreamController): Promise<void>;
}
