wipe

setMaxOpenFiles 2048;	        	# Max number of recorders
set Ubig 1.e10; 		   	# a really large number
set Usmall [expr 1.0/$Ubig]; 		# a really small number
set g         9.81; 
set pi   3.1415927;  
 
# Create ModelBuilder (with three-dimensions (-ndm) and 6 DOF/node (-ndf)) 
model basic -ndm 3 -ndf 6 

#Material properties  
set Emasonry_ext	4000e06
set Gmasonry_ext	1700e06
set fcmasonry_ext	5.00e06
set mumasonry_ext	0.80
set cmasonry_ext	0.15e06
set muR_ext		[expr 0.4 * $mumasonry_ext];
set density_ext		1800

set Emasonry_int	1600e06
set Gmasonry_int	 650e06
set fcmasonry_int	2.00e06
set mumasonry_int	0.80
set cmasonry_int	0.15e06
set muR_int		[expr 0.4 * $mumasonry_int];
set density_int		1200

set floorfriction 1.0; # Floor-to-wall friction factor in the BeamFrictionSupport element (only membrane element is modeled)

#Limit drifts   
set driftF		0.01035
set driftS		0.007

#Define floor properties  
set Ef1	29e9
set Ef2	12e9  
set Gf	0.011e9

#NOMENCLATURE 
#EXTRA NODES
# n0xy with n indicating to which shell belongs the node (1, 2, 3, ..., n); x as the story-level (1, 2, 3, 4, 5); and y as the node number counter-clockwise (1, 2, 3, 4)

#SHELLS
# 20xy with x as the floor story (1, 2, 3, 4, 5) and y as the number of shells at each story (1, 2, 3, ..., n)

# ZEROLENGTH ELEMENTS FOR WALL TO WALL INTERFACER
# 300x with x as the number of wall-to-wall connections at each story (1, 2, 3, ..., n)
# Direction of the ZL element is defined by fixing the first node and moving the second node toward the opening of the interface

# ZEROLENGTH ELEMENTS FOR FLOOR TO WALL INTERFACER
# 4xyz with x as the floor story (1, 2, 3, 4, 5); y as the number of shells; and z as the node number counter-clockwise (1, 2, 3, 4)
# Local direction X is defined according to the application of the vertical load; +Y Local allows for frictional sliding and -Y or Z in any direction is ruled by pounding

#NODES ------------------------------------------------------------ 
# Definition of the geometry
# Create nodes
#       tag     X         Y         Z  
node	1	1.693	3.643	0
node	2	1.693	3.643	3
node	3	1.693	3.643	6
node	4	1.693	3.643	9
node	5	1.693	11.643	0
node	6	1.693	11.643	3
node	7	1.693	11.643	6
node	8	1.693	11.643	9
node	9	-4.557	2.643	0
node	10	-4.557	2.643	3
node	11	-4.557	2.643	6
node	12	-4.557	2.643	9
node	13	0.693	2.643	0
node	14	0.693	2.643	3
node	15	0.693	2.643	6
node	16	0.693	2.643	9
node	17	2.693	2.643	0
node	18	2.693	2.643	3
node	19	2.693	2.643	6
node	20	2.693	2.643	9
node	21	7.943	2.643	0
node	22	7.943	2.643	3
node	23	7.943	2.643	6
node	24	7.943	2.643	9
node	25	-4.557	3.643	0
node	26	-4.557	3.643	3
node	27	-4.557	3.643	6
node	28	-4.557	3.643	9
node	29	7.943	3.643	0
node	30	7.943	3.643	3
node	31	7.943	3.643	6
node	32	7.943	3.643	9
node	33	0.693	-0.857	0
node	34	0.693	-0.857	3
node	35	0.693	-0.857	6
node	36	0.693	-0.857	9
node	37	0.693	3.643	0
node	38	0.693	3.643	3
node	39	0.693	3.643	6
node	40	0.693	3.643	9
node	41	2.693	-0.857	0
node	42	2.693	-0.857	3
node	43	2.693	-0.857	6
node	44	2.693	-0.857	9
node	45	2.693	3.643	0
node	46	2.693	3.643	3
node	47	2.693	3.643	6
node	48	2.693	3.643	9
node	49	-4.557	-0.857	0
node	50	-4.557	-0.857	3
node	51	-4.557	-0.857	6
node	52	-4.557	-0.857	9
node	53	7.943	-0.857	0
node	54	7.943	-0.857	3
node	55	7.943	-0.857	6
node	56	7.943	-0.857	9
node	57	-1.932	-0.857	0
node	58	-1.932	-0.857	3
node	59	-1.932	-0.857	6
node	60	-1.932	-0.857	9
node	61	-1.932	11.643	0
node	62	-1.932	11.643	3
node	63	-1.932	11.643	6
node	64	-1.932	11.643	9
node	65	-1.932	2.643	0
node	66	-1.932	2.643	3
node	67	-1.932	2.643	6
node	68	-1.932	2.643	9
node	69	-1.932	3.643	0
node	70	-1.932	3.643	3
node	71	-1.932	3.643	6
node	72	-1.932	3.643	9
node	73	5.318	-0.857	0
node	74	5.318	-0.857	3
node	75	5.318	-0.857	6
node	76	5.318	-0.857	9
node	77	5.318	11.643	0
node	78	5.318	11.643	3
node	79	5.318	11.643	6
node	80	5.318	11.643	9
node	81	5.318	2.643	0
node	82	5.318	2.643	3
node	83	5.318	2.643	6
node	84	5.318	2.643	9
node	85	5.318	3.643	0
node	86	5.318	3.643	3
node	87	5.318	3.643	6
node	88	5.318	3.643	9
node	89	-4.557	11.643	0
node	90	-4.557	11.643	3
node	91	-4.557	11.643	6
node	92	-4.557	11.643	9
node	93	7.943	11.643	0
node	94	7.943	11.643	3
node	95	7.943	11.643	6
node	96	7.943	11.643	9
node	97	-4.557	8.143	0
node	98	-4.557	8.143	3
node	99	-4.557	8.143	6
node	100	-4.557	8.143	9
node	101	7.943	8.143	0
node	102	7.943	8.143	3
node	103	7.943	8.143	6
node	104	7.943	8.143	9
node	105	1.693	8.143	0
node	106	1.693	8.143	3
node	107	1.693	8.143	6
node	108	1.693	8.143	9
node	109	-1.932	8.143	0
node	110	-1.932	8.143	3
node	111	-1.932	8.143	6
node	112	-1.932	8.143	9
node	113	5.318	8.143	0
node	114	5.318	8.143	3
node	115	5.318	8.143	6
node	116	5.318	8.143	9
node	117	-4.557	7.143	0
node	118	-4.557	7.143	3
node	119	-4.557	7.143	6
node	120	-4.557	7.143	9
node	121	7.943	7.143	0
node	122	7.943	7.143	3
node	123	7.943	7.143	6
node	124	7.943	7.143	9
node	125	1.693	7.143	0
node	126	1.693	7.143	3
node	127	1.693	7.143	6
node	128	1.693	7.143	9
node	129	-1.932	7.143	0
node	130	-1.932	7.143	3
node	131	-1.932	7.143	6
node	132	-1.932	7.143	9
node	133	5.318	7.143	0
node	134	5.318	7.143	3
node	135	5.318	7.143	6
node	136	5.318	7.143	9
node	137	-0.932	3.643	0
node	138	-0.932	3.643	3
node	139	-0.932	3.643	6
node	140	-0.932	3.643	9
node	141	-0.932	7.143	0
node	142	-0.932	7.143	3
node	143	-0.932	7.143	6
node	144	-0.932	7.143	9
node	145	4.318	3.643	0
node	146	4.318	3.643	3
node	147	4.318	3.643	6
node	148	4.318	3.643	9
node	149	4.318	7.143	0
node	150	4.318	7.143	3
node	151	4.318	7.143	6
node	152	4.318	7.143	9
node	153	-2.363	7.143	0
node	154	-2.363	7.143	3
node	155	-2.363	7.143	6
node	156	-2.363	7.143	9
node	157	1.693	3.643	0
node	158	1.693	3.643	3
node	159	1.693	3.643	6
node	160	1.693	3.643	9
node	161	1.693	11.643	0
node	162	1.693	11.643	3
node	163	1.693	11.643	6
node	164	1.693	11.643	9
node	165	-4.557	2.643	0
node	166	-4.557	2.643	3
node	167	-4.557	2.643	6
node	168	-4.557	2.643	9
node	169	0.693	2.643	0
node	170	0.693	2.643	3
node	171	0.693	2.643	6
node	172	0.693	2.643	9
node	173	2.693	2.643	0
node	174	2.693	2.643	3
node	175	2.693	2.643	6
node	176	2.693	2.643	9
node	177	7.943	2.643	0
node	178	7.943	2.643	3
node	179	7.943	2.643	6
node	180	7.943	2.643	9
node	181	-4.557	3.643	0
node	182	-4.557	3.643	3
node	183	-4.557	3.643	6
node	184	-4.557	3.643	9
node	185	7.943	3.643	0
node	186	7.943	3.643	3
node	187	7.943	3.643	6
node	188	7.943	3.643	9
node	189	0.693	-0.857	0
node	190	0.693	-0.857	3
node	191	0.693	-0.857	6
node	192	0.693	-0.857	9
node	193	0.693	3.643	0
node	194	0.693	3.643	3
node	195	0.693	3.643	6
node	196	0.693	3.643	9
node	197	2.693	-0.857	0
node	198	2.693	-0.857	3
node	199	2.693	-0.857	6
node	200	2.693	-0.857	9
node	201	2.693	3.643	0
node	202	2.693	3.643	3
node	203	2.693	3.643	6
node	204	2.693	3.643	9
node	205	-4.557	-0.857	0
node	206	-4.557	-0.857	3
node	207	-4.557	-0.857	6
node	208	-4.557	-0.857	9
node	209	7.943	-0.857	0
node	210	7.943	-0.857	3
node	211	7.943	-0.857	6
node	212	7.943	-0.857	9
node	213	-1.932	-0.857	0
node	214	-1.932	-0.857	3
node	215	-1.932	-0.857	6
node	216	-1.932	-0.857	9
node	217	-1.932	11.643	0
node	218	-1.932	11.643	3
node	219	-1.932	11.643	6
node	220	-1.932	11.643	9
node	221	-1.932	2.643	0
node	222	-1.932	2.643	3
node	223	-1.932	2.643	6
node	224	-1.932	2.643	9
node	225	-1.932	3.643	0
node	226	-1.932	3.643	3
node	227	-1.932	3.643	6
node	228	-1.932	3.643	9
node	229	5.318	-0.857	0
node	230	5.318	-0.857	3
node	231	5.318	-0.857	6
node	232	5.318	-0.857	9
node	233	5.318	11.643	0
node	234	5.318	11.643	3
node	235	5.318	11.643	6
node	236	5.318	11.643	9
node	237	5.318	2.643	0
node	238	5.318	2.643	3
node	239	5.318	2.643	6
node	240	5.318	2.643	9
node	241	5.318	3.643	0
node	242	5.318	3.643	3
node	243	5.318	3.643	6
node	244	5.318	3.643	9
node	245	-4.557	11.643	0
node	246	-4.557	11.643	3
node	247	-4.557	11.643	6
node	248	-4.557	11.643	9
node	249	7.943	11.643	0
node	250	7.943	11.643	3
node	251	7.943	11.643	6
node	252	7.943	11.643	9
node	253	-4.557	8.143	0
node	254	-4.557	8.143	3
node	255	-4.557	8.143	6
node	256	-4.557	8.143	9
node	257	7.943	8.143	0
node	258	7.943	8.143	3
node	259	7.943	8.143	6
node	260	7.943	8.143	9
node	261	1.693	8.143	0
node	262	1.693	8.143	3
node	263	1.693	8.143	6
node	264	1.693	8.143	9
node	265	-1.932	8.143	0
node	266	-1.932	8.143	3
node	267	-1.932	8.143	6
node	268	-1.932	8.143	9
node	269	5.318	8.143	0
node	270	5.318	8.143	3
node	271	5.318	8.143	6
node	272	5.318	8.143	9
node	273	-4.557	7.143	0
node	274	-4.557	7.143	3
node	275	-4.557	7.143	6
node	276	-4.557	7.143	9
node	277	7.943	7.143	0
node	278	7.943	7.143	3
node	279	7.943	7.143	6
node	280	7.943	7.143	9
node	281	1.693	7.143	0
node	282	1.693	7.143	3
node	283	1.693	7.143	6
node	284	1.693	7.143	9
node	285	-1.932	7.143	0
node	286	-1.932	7.143	3
node	287	-1.932	7.143	6
node	288	-1.932	7.143	9
node	289	5.318	7.143	0
node	290	5.318	7.143	3
node	291	5.318	7.143	6
node	292	5.318	7.143	9
node	293	-0.932	3.643	0
node	294	-0.932	3.643	3
node	295	-0.932	3.643	6
node	296	-0.932	3.643	9
node	297	-0.932	7.143	0
node	298	-0.932	7.143	3
node	299	-0.932	7.143	6
node	300	-0.932	7.143	9
node	301	4.318	3.643	0
node	302	4.318	3.643	3
node	303	4.318	3.643	6
node	304	4.318	3.643	9
node	305	4.318	7.143	0
node	306	4.318	7.143	3
node	307	4.318	7.143	6
node	308	4.318	7.143	9
node	309	-3.245	11.643	0.5
node	310	-3.245	11.643	3.1
node	311	-0.119	11.643	2.6
node	312	3.505	11.643	2.6
node	313	6.631	11.643	0.5
node	314	6.631	11.643	3.1
node	315	-3.245	11.643	6.1
node	316	-0.119	11.643	5.6
node	317	3.505	11.643	5.6
node	318	6.631	11.643	6.1
node	319	-3.245	11.643	8.6
node	320	-0.119	11.643	8.6
node	321	3.505	11.643	8.6
node	322	6.631	11.643	8.6
node	323	-4.276	11.643	1.529
node	324	-1.682	11.643	1.35
node	325	1.693	11.643	1.1
node	326	5.068	11.643	1.35
node	327	7.662	11.643	1.529
node	328	-4.276	11.643	4.529
node	329	-1.682	11.643	4.35
node	330	1.693	11.643	4.1
node	331	5.068	11.643	4.35
node	332	7.662	11.643	4.529
node	333	-4.276	11.643	7.529
node	334	-1.682	11.643	7.35
node	335	1.693	11.643	7.1
node	336	5.068	11.643	7.35
node	337	7.662	11.643	7.529
node	338	7.943	5.393	1.5
node	339	7.943	5.393	4.5
node	340	7.943	5.393	7.5
node	341	-3.245	-0.857	0.5
node	342	-3.245	-0.857	3.1
node	343	-0.619	-0.857	0.5
node	344	-0.619	-0.857	2.6
node	345	1.693	-0.857	3.1
node	346	4.005	-0.857	0.5
node	347	4.005	-0.857	2.6
node	348	6.631	-0.857	0.5
node	349	6.631	-0.857	3.1
node	350	-3.245	-0.857	6.1
node	351	-0.619	-0.857	5.6
node	352	1.693	-0.857	6.1
node	353	4.005	-0.857	5.6
node	354	6.631	-0.857	6.1
node	355	-3.245	-0.857	8.6
node	356	-0.619	-0.857	8.6
node	357	1.693	-0.857	8.6
node	358	4.005	-0.857	8.6
node	359	6.631	-0.857	8.6
node	360	-4.201	-0.857	1.529
node	361	-1.932	-0.857	1.6
node	362	0.537	-0.857	1.35
node	363	2.849	-0.857	1.35
node	364	5.318	-0.857	1.6
node	365	7.587	-0.857	1.529
node	366	-4.201	-0.857	4.529
node	367	-1.932	-0.857	4.35
node	368	0.537	-0.857	4.35
node	369	2.849	-0.857	4.35
node	370	5.318	-0.857	4.35
node	371	7.587	-0.857	4.529
node	372	-4.201	-0.857	7.529
node	373	-1.932	-0.857	7.35
node	374	0.537	-0.857	7.35
node	375	2.849	-0.857	7.35
node	376	5.318	-0.857	7.35
node	377	7.587	-0.857	7.529
node	378	-4.557	5.393	1.5
node	379	-4.557	5.393	4.5
node	380	-4.557	5.393	7.5
# EXTRA NODES				
node	1011	-4.557	-0.857	3
node	1012	7.943	-0.857	3
node	1013	7.943	11.643	3
node	1014	-4.557	11.643	3
node	1021	-4.557	-0.857	6
node	1022	7.943	-0.857	6
node	1023	7.943	11.643	6
node	1024	-4.557	11.643	6
node	1031	-4.557	-0.857	9
node	1032	7.943	-0.857	9
node	1033	7.943	11.643	9
node	1034	-4.557	11.643	9
#END NODES ------------------------------------------------------------ 
puts "Nodes defined." 


geomTransf PDelta      1  0.000 -1.000  0.000
geomTransf PDelta      2  1.000  0.000 -0.000
geomTransf PDelta      3  0.000 -1.000  0.000
geomTransf PDelta      4  1.000  0.000 -0.000
geomTransf PDelta      5  1.000  0.000 -0.000
geomTransf PDelta      6  0.000 -1.000  0.000
geomTransf PDelta      7  0.000 -1.000  0.000
geomTransf PDelta      8  0.000 -1.000  0.000
geomTransf PDelta      9  1.000  0.000 -0.000
geomTransf PDelta     10  1.000  0.000 -0.000
geomTransf PDelta     11  1.000  0.000 -0.000
geomTransf PDelta     12  1.000  0.000 -0.000
geomTransf PDelta     13  0.000 -1.000  0.000
geomTransf PDelta     14  0.000 -1.000  0.000
geomTransf PDelta     15  1.000  0.000 -0.000
geomTransf PDelta     16  1.000  0.000 -0.000

#MACROELEMENTS --------------------------------------------------------- 
#elementMacroelement3d	$eTag	$nI	$nJ	$nE	$aX	$aY	$aZ	$oopX	$oopY	$oopZ	definition 	$h	$L	$t	$E	$G	$fc	$mu	$c	$Gc	$dropDrift	$muR	$driftF	$driftS	$-density			
element	Macroelement3d	1	89	61	309	1	0	0	0	-1	0	-spandrel	1.5	1	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	2	90	62	310	1	0	0	0	-1	0	-spandrel	1.5	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	3	62	6	311	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	4	6	78	312	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	5	77	93	313	1	0	0	0	-1	0	-spandrel	1.5	1	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	6	78	94	314	1	0	0	0	-1	0	-spandrel	1.5	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	7	91	63	315	1	0	0	0	-1	0	-spandrel	1.5	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	8	63	7	316	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	9	7	79	317	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	10	79	95	318	1	0	0	0	-1	0	-spandrel	1.5	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	11	92	64	319	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	12	64	8	320	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	13	8	80	321	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	14	80	96	322	1	0	0	0	-1	0	-spandrel	1.5	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	15	89	90	323	0	0	1	0	-1	0	-pier	2.1	0.562	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	16	61	62	324	0	0	1	0	-1	0	-pier	1.7	1.625	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	17	5	6	325	0	0	1	0	-1	0	-pier	2.2	2.125	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	18	77	78	326	0	0	1	0	-1	0	-pier	1.7	1.625	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	19	93	94	327	0	0	1	0	-1	0	-pier	2.1	0.563	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	20	90	91	328	0	0	1	0	-1	0	-pier	2.1	0.562	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	21	62	63	329	0	0	1	0	-1	0	-pier	1.7	1.625	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	22	6	7	330	0	0	1	0	-1	0	-pier	2.2	2.125	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	23	78	79	331	0	0	1	0	-1	0	-pier	1.7	1.625	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	24	94	95	332	0	0	1	0	-1	0	-pier	2.1	0.562	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	25	91	92	333	0	0	1	0	-1	0	-pier	2.1	0.562	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	26	63	64	334	0	0	1	0	-1	0	-pier	1.7	1.625	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	27	7	8	335	0	0	1	0	-1	0	-pier	2.2	2.125	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	28	79	80	336	0	0	1	0	-1	0	-pier	1.7	1.625	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	29	95	96	337	0	0	1	0	-1	0	-pier	2.1	0.562	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	30	121	122	338	0	0	1	1	0	0	-pier	3	12.5	0.3	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	31	122	123	339	0	0	1	1	0	0	-pier	3	12.5	0.3	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	32	123	124	340	0	0	1	1	0	0	-pier	3	12.5	0.3	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	33	49	57	341	1	0	0	0	-1	0	-spandrel	1.2	1	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	34	50	58	342	1	0	0	0	-1	0	-spandrel	1.2	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	35	57	33	343	1	0	0	0	-1	0	-spandrel	1.2	1	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	36	58	34	344	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	37	34	42	345	1	0	0	0	-1	0	-spandrel	1.2	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	38	41	73	346	1	0	0	0	-1	0	-spandrel	1.2	1	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	39	42	74	347	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	40	73	209	348	1	0	0	0	-1	0	-spandrel	1.2	1	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	41	74	210	349	1	0	0	0	-1	0	-spandrel	1.2	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	42	51	59	350	1	0	0	0	-1	0	-spandrel	1.2	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	43	59	35	351	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	44	35	43	352	1	0	0	0	-1	0	-spandrel	1.2	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	45	43	75	353	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	46	75	211	354	1	0	0	0	-1	0	-spandrel	1.2	1.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	47	52	60	355	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	48	60	36	356	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	49	36	44	357	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	50	44	76	358	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	51	76	212	359	1	0	0	0	-1	0	-spandrel	1.2	0.8	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	52	49	50	360	0	0	1	0	-1	0	-pier	2.1	0.712	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	53	57	58	361	0	0	1	0	-1	0	-pier	1.2	1.425	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	54	33	34	362	0	0	1	0	-1	0	-pier	1.7	1.113	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	55	41	42	363	0	0	1	0	-1	0	-pier	1.7	1.112	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	56	73	74	364	0	0	1	0	-1	0	-pier	1.2	1.425	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	57	209	210	365	0	0	1	0	-1	0	-pier	2.1	0.712	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	58	50	51	366	0	0	1	0	-1	0	-pier	2.1	0.712	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	59	58	59	367	0	0	1	0	-1	0	-pier	1.7	1.425	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	60	34	35	368	0	0	1	0	-1	0	-pier	1.7	1.113	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	61	42	43	369	0	0	1	0	-1	0	-pier	1.7	1.112	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	62	74	75	370	0	0	1	0	-1	0	-pier	1.7	1.425	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	63	210	211	371	0	0	1	0	-1	0	-pier	2.1	0.712	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	64	51	52	372	0	0	1	0	-1	0	-pier	2.1	0.712	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	65	59	60	373	0	0	1	0	-1	0	-pier	1.7	1.425	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	66	35	36	374	0	0	1	0	-1	0	-pier	1.7	1.113	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	67	43	44	375	0	0	1	0	-1	0	-pier	1.7	1.112	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	68	75	76	376	0	0	1	0	-1	0	-pier	1.7	1.425	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	69	211	212	377	0	0	1	0	-1	0	-pier	2.1	0.712	0.45	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	70	117	118	378	0	0	1	1	0	0	-pier	3	12.5	0.3	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	71	118	119	379	0	0	1	1	0	0	-pier	3	12.5	0.3	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping
element	Macroelement3d	72	119	120	380	0	0	1	1	0	0	-pier	3	12.5	0.3	$Emasonry_ext	$Gmasonry_ext	$fcmasonry_ext	$mumasonry_ext	$cmasonry_ext	3.6	0.004	$muR_ext	 -driftFlexure $driftF 1.0 -driftShear $driftS 0.00	 -density	$density_ext	 -pDelta	 -secantDamping

#END Macrolements------------------------------------------------------------ 


#SHELLS  --------------------------------------------------------- 

#element ShellMITC4 $eleTag $iNode $jNode $kNode $lNode $secTag 
# 1st storey							
section OrthotropicMembraneSection	2011	$Ef1	$Ef2	0	$Gf	0.022	0
element ShellMITC4	2011	1011	1012	1013	1014	2011	
							
# 2nd storey							
section OrthotropicMembraneSection	2021	$Ef1	$Ef2	0	$Gf	0.022	0
element ShellMITC4	2021	1021	1022	1023	1024	2021	
							
# 3rd storey							
section OrthotropicMembraneSection	2031	$Ef1	$Ef2	0	$Gf	0.022	0
element ShellMITC4	2031	1031	1032	1033	1034	2031	

#END Shells ------------------------------------------------------------ 

#CONSTRAINTS --------------------------------------------------------- 
fix       1    1   1   1   1   1   1 
fix     157    1   1   1   1   1   1 
fix       5    1   1   1   1   1   1 
fix     161    1   1   1   1   1   1 
fix       9    1   1   1   1   1   1 
fix     165    1   1   1   1   1   1 
fix      13    1   1   1   1   1   1 
fix     169    1   1   1   1   1   1 
fix      17    1   1   1   1   1   1 
fix     173    1   1   1   1   1   1 
fix      21    1   1   1   1   1   1 
fix     177    1   1   1   1   1   1 
fix      25    1   1   1   1   1   1 
fix     181    1   1   1   1   1   1 
fix      29    1   1   1   1   1   1 
fix     185    1   1   1   1   1   1 
fix      33    1   1   1   1   1   1 
fix     189    1   1   1   1   1   1 
fix      37    1   1   1   1   1   1 
fix     193    1   1   1   1   1   1 
fix      41    1   1   1   1   1   1 
fix     197    1   1   1   1   1   1 
fix      45    1   1   1   1   1   1 
fix     201    1   1   1   1   1   1 
fix      49    1   1   1   1   1   1 
fix     205    1   1   1   1   1   1 
fix      53    1   1   1   1   1   1 
fix     209    1   1   1   1   1   1 
fix      57    1   1   1   1   1   1 
fix     213    1   1   1   1   1   1 
fix      61    1   1   1   1   1   1 
fix     217    1   1   1   1   1   1 
fix      65    1   1   1   1   1   1 
fix     221    1   1   1   1   1   1 
fix      69    1   1   1   1   1   1 
fix     225    1   1   1   1   1   1 
fix      73    1   1   1   1   1   1 
fix     229    1   1   1   1   1   1 
fix      77    1   1   1   1   1   1 
fix     233    1   1   1   1   1   1 
fix      81    1   1   1   1   1   1 
fix     237    1   1   1   1   1   1 
fix      85    1   1   1   1   1   1 
fix     241    1   1   1   1   1   1 
fix      89    1   1   1   1   1   1 
fix     245    1   1   1   1   1   1 
fix      93    1   1   1   1   1   1 
fix     249    1   1   1   1   1   1 
fix      97    1   1   1   1   1   1 
fix     253    1   1   1   1   1   1 
fix     101    1   1   1   1   1   1 
fix     257    1   1   1   1   1   1 
fix     105    1   1   1   1   1   1 
fix     261    1   1   1   1   1   1 
fix     109    1   1   1   1   1   1 
fix     265    1   1   1   1   1   1 
fix     113    1   1   1   1   1   1 
fix     269    1   1   1   1   1   1 
fix     117    1   1   1   1   1   1 
fix     273    1   1   1   1   1   1 
fix     121    1   1   1   1   1   1 
fix     277    1   1   1   1   1   1 
fix     125    1   1   1   1   1   1 
fix     281    1   1   1   1   1   1 
fix     129    1   1   1   1   1   1 
fix     285    1   1   1   1   1   1 
fix     133    1   1   1   1   1   1 
fix     289    1   1   1   1   1   1 
fix     137    1   1   1   1   1   1 
fix     293    1   1   1   1   1   1 
fix     141    1   1   1   1   1   1 
fix     297    1   1   1   1   1   1 
fix     145    1   1   1   1   1   1 
fix     301    1   1   1   1   1   1 
fix     149    1   1   1   1   1   1 
fix     305    1   1   1   1   1   1 
fix     153    1   1   1   1   1   1 
#END Constraints------------------------------------------------------------ 

#WALL TO WALL CONNECTIONS ---------------------------------------------------------                                                                                                                 
equalDOF	2	158	1 2 3 4 5 6 
equalDOF	3	159	1 2 3 4 5 6 
equalDOF	4	160	1 2 3 4 5 6 
equalDOF	6	162	1 2 3 4 5 6 
equalDOF	7	163	1 2 3 4 5 6 
equalDOF	8	164	1 2 3 4 5 6 
equalDOF	10	166	1 2 3 4 5 6 
equalDOF	11	167	1 2 3 4 5 6 
equalDOF	12	168	1 2 3 4 5 6 
equalDOF	14	170	1 2 3 4 5 6 
equalDOF	15	171	1 2 3 4 5 6 
equalDOF	16	172	1 2 3 4 5 6 
equalDOF	18	174	1 2 3 4 5 6 
equalDOF	19	175	1 2 3 4 5 6 
equalDOF	20	176	1 2 3 4 5 6 
equalDOF	22	178	1 2 3 4 5 6 
equalDOF	23	179	1 2 3 4 5 6 
equalDOF	24	180	1 2 3 4 5 6 
equalDOF	26	182	1 2 3 4 5 6 
equalDOF	27	183	1 2 3 4 5 6 
equalDOF	28	184	1 2 3 4 5 6 
equalDOF	30	186	1 2 3 4 5 6 
equalDOF	31	187	1 2 3 4 5 6 
equalDOF	32	188	1 2 3 4 5 6 
equalDOF	34	190	1 2 3 4 5 6 
equalDOF	35	191	1 2 3 4 5 6 
equalDOF	36	192	1 2 3 4 5 6 
equalDOF	38	194	1 2 3 4 5 6 
equalDOF	39	195	1 2 3 4 5 6 
equalDOF	40	196	1 2 3 4 5 6 
equalDOF	42	198	1 2 3 4 5 6 
equalDOF	43	199	1 2 3 4 5 6 
equalDOF	44	200	1 2 3 4 5 6 
equalDOF	46	202	1 2 3 4 5 6 
equalDOF	47	203	1 2 3 4 5 6 
equalDOF	48	204	1 2 3 4 5 6 
equalDOF	50	206	1 2 3
equalDOF	51	207	1 2 3
equalDOF	52	208	1 2 3
equalDOF	54	210	1 2 3
equalDOF	55	211	1 2 3
equalDOF	56	212	1 2 3
equalDOF	58	214	1 2 3 4 5 6 
equalDOF	59	215	1 2 3 4 5 6 
equalDOF	60	216	1 2 3 4 5 6 
equalDOF	62	218	1 2 3 4 5 6 
equalDOF	63	219	1 2 3 4 5 6 
equalDOF	64	220	1 2 3 4 5 6 
equalDOF	66	222	1 2 3 4 5 6 
equalDOF	67	223	1 2 3 4 5 6 
equalDOF	68	224	1 2 3 4 5 6 
equalDOF	70	226	1 2 3 4 5 6 
equalDOF	71	227	1 2 3 4 5 6 
equalDOF	72	228	1 2 3 4 5 6 
equalDOF	74	230	1 2 3 4 5 6 
equalDOF	75	231	1 2 3 4 5 6 
equalDOF	76	232	1 2 3 4 5 6 
equalDOF	78	234	1 2 3 4 5 6 
equalDOF	79	235	1 2 3 4 5 6 
equalDOF	80	236	1 2 3 4 5 6 
equalDOF	82	238	1 2 3 4 5 6 
equalDOF	83	239	1 2 3 4 5 6 
equalDOF	84	240	1 2 3 4 5 6 
equalDOF	86	242	1 2 3 4 5 6 
equalDOF	87	243	1 2 3 4 5 6 
equalDOF	88	244	1 2 3 4 5 6 
equalDOF	90	246	1 2 3
equalDOF	91	247	1 2 3
equalDOF	92	248	1 2 3
equalDOF	94	250	1 2 3
equalDOF	95	251	1 2 3
equalDOF	96	252	1 2 3
equalDOF	98	254	1 2 3 4 5 6 
equalDOF	99	255	1 2 3 4 5 6 
equalDOF	100	256	1 2 3 4 5 6 
equalDOF	102	258	1 2 3 4 5 6 
equalDOF	103	259	1 2 3 4 5 6 
equalDOF	104	260	1 2 3 4 5 6 
equalDOF	106	262	1 2 3 4 5 6 
equalDOF	107	263	1 2 3 4 5 6 
equalDOF	108	264	1 2 3 4 5 6 
equalDOF	110	266	1 2 3 4 5 6 
equalDOF	111	267	1 2 3 4 5 6 
equalDOF	112	268	1 2 3 4 5 6 
equalDOF	114	270	1 2 3 4 5 6 
equalDOF	115	271	1 2 3 4 5 6 
equalDOF	116	272	1 2 3 4 5 6 
equalDOF	118	274	1 2 3 4 5 6 
equalDOF	119	275	1 2 3 4 5 6 
equalDOF	120	276	1 2 3 4 5 6 
equalDOF	122	278	1 2 3 4 5 6 
equalDOF	123	279	1 2 3 4 5 6 
equalDOF	124	280	1 2 3 4 5 6 
equalDOF	126	282	1 2 3 4 5 6 
equalDOF	127	283	1 2 3 4 5 6 
equalDOF	128	284	1 2 3 4 5 6 
equalDOF	130	286	1 2 3 4 5 6 
equalDOF	131	287	1 2 3 4 5 6 
equalDOF	132	288	1 2 3 4 5 6 
equalDOF	134	290	1 2 3 4 5 6 
equalDOF	135	291	1 2 3 4 5 6 
equalDOF	136	292	1 2 3 4 5 6 
equalDOF	138	294	1 2 3 4 5 6 
equalDOF	139	295	1 2 3 4 5 6 
equalDOF	140	296	1 2 3 4 5 6 
equalDOF	142	298	1 2 3 4 5 6 
equalDOF	143	299	1 2 3 4 5 6 
equalDOF	144	300	1 2 3 4 5 6 
equalDOF	146	302	1 2 3 4 5 6 
equalDOF	147	303	1 2 3 4 5 6 
equalDOF	148	304	1 2 3 4 5 6 
equalDOF	150	306	1 2 3 4 5 6 
equalDOF	151	307	1 2 3 4 5 6 
equalDOF	152	308	1 2 3 4 5 6 

#FLOOR TO WALL CONNECTIONS ---------------------------------------------------------                                                                                                                
nDMaterial BeamFrictionSupport 1004  5000000.000000 50000000.000000 $floorfriction -gap 0.000000 0.000000

# 1st storey												
element	zeroLengthND	4111	50	1011	1004	 -orient	0	0	1	0	1	0
element	zeroLengthND	4112	54	1012	1004	 -orient	0	0	1	0	1	0
element	zeroLengthND	4113	94	1013	1004	 -orient	0	0	1	0	-1	0
element	zeroLengthND	4114	90	1014	1004	 -orient	0	0	1	0	-1	0
# 2nd storey												
element	zeroLengthND	4211	51	1021	1004	 -orient	0	0	1	0	1	0
element	zeroLengthND	4212	55	1022	1004	 -orient	0	0	1	0	1	0
element	zeroLengthND	4213	95	1023	1004	 -orient	0	0	1	0	-1	0
element	zeroLengthND	4214	91	1024	1004	 -orient	0	0	1	0	-1	0
#3rd storey												
element	zeroLengthND	4311	52	1031	1004	 -orient	0	0	1	0	1	0
element	zeroLengthND	4312	56	1032	1004	 -orient	0	0	1	0	1	0
element	zeroLengthND	4313	96	1033	1004	 -orient	0	0	1	0	-1	0
element	zeroLengthND	4314	92	1034	1004	 -orient	0	0	1	0	-1	0

# 1st storey				
equalDOF	50	1011	4	5
equalDOF	54	1012	4	5
equalDOF	94	1013	4	5
equalDOF	90	1014	4	5
# 2nd storey				
equalDOF	51	1021	4	5
equalDOF	55	1022	4	5
equalDOF	95	1023	4	5
equalDOF	91	1024	4	5
#3rd storey				
equalDOF	52	1031	4	5
equalDOF	56	1032	4	5
equalDOF	96	1033	4	5
equalDOF	92	1034	4	5
  
#END Connections ------------------------------------------------------

#RIGID LINKS ---------------------------------------------------------- 
# ----------------
geomTransf Linear     17  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    229     54     22 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      17	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     18  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    230     22     30 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      18	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     19  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    231     30    122 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      19	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     20  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    232    122    102 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      20	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     21  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    233    102    250 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      21	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     22  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    234     55     23 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      22	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     23  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    235     23     31 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      23	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     24  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    236     31    123 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      24	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     25  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    237    123    103 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      25	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     26  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    238    103    251 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      26	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     27  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    239     56     24 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      27	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     28  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    240     24     32 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      28	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     29  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    241     32    124 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      29	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     30  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    242    124    104 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      30	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     31  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    243    104    252 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      31	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     32  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    244    206     10 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      32	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     33  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    245     10     26 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      33	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     34  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    246     26    118 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      34	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     35  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    247    118     98 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      35	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     36  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    248     98    246 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      36	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     37  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    249    207     11 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      37	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     38  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    250     11     27 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      38	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     39  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    251     27    119 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      39	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     40  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    252    119     99 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      40	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     41  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    253     99    247 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      41	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     42  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    254    208     12 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      42	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     43  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    255     12     28 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      43	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     44  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    256     28    120 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      44	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     45  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    257    120    100 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      45	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     46  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    258    100    248 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      46	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     47  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    259      2    126 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      47	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     48  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    260    126    106 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      48	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     49  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    261    106    162 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      49	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     50  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    262      3    127 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      50	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     51  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    263    127    107 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      51	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     52  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    264    107    163 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      52	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     53  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    265      4    128 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      53	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     54  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    266    128    108 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      54	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     55  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    267    108    164 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      55	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     56  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    268    166     66 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      56	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     57  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    269     66     14 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      57	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     58  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    270    167     67 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      58	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     59  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    271     67     15 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      59	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     60  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    272    168     68 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      60	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     61  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    273     68     16 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      61	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     62  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    274     18     82 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      62	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     63  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    275     82    178 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      63	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     64  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    276     19     83 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      64	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     65  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    277     83    179 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      65	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     66  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    278     20     84 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      66	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     67  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    279     84    180 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      67	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     68  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    280    182     70 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      68	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     69  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    281     70    138 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      69	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     70  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    282    138     38 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      70	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     71  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    283     38    158 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      71	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     72  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    284    158     46 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      72	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     73  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    285     46    146 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      73	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     74  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    286    146     86 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      74	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     75  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    287     86    186 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      75	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     76  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    288    183     71 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      76	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     77  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    289     71    139 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      77	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     78  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    290    139     39 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      78	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     79  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    291     39    159 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      79	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     80  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    292    159     47 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      80	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     81  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    293     47    147 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      81	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     82  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    294    147     87 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      82	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     83  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    295     87    187 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      83	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     84  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    296    184     72 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      84	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     85  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    297     72    140 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      85	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     86  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    298    140     40 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      86	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     87  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    299     40    160 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      87	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     88  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    300    160     48 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      88	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     89  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    301     48    148 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      89	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     90  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    302    148     88 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      90	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     91  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    303     88    188 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00      91	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     92  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    304    190    170 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      92	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     93  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    305    170    194 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      93	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     94  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    306    191    171 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      94	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     95  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    307    171    195 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      95	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     96  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    308    192    172 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      96	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     97  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    309    172    196 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      97	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     98  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    310    198    174 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      98	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear     99  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    311    174    202 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00      99	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    100  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    312    199    175 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     100	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    101  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    313    175    203 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     101	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    102  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    314    200    176 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     102	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    103  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    315    176    204 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     103	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    104  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    316    214    222 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     104	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    105  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    317    222    226 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     105	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    106  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    318    226    130 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     106	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    107  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    319    130    110 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     107	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    108  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    320    110    218 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     108	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    109  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    321    215    223 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     109	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    110  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    322    223    227 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     110	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    111  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    323    227    131 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     111	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    112  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    324    131    111 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     112	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    113  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    325    111    219 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     113	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    114  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    326    216    224 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     114	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    115  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    327    224    228 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     115	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    116  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    328    228    132 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     116	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    117  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    329    132    112 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     117	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    118  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    330    112    220 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     118	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    119  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    331    230    238 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     119	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    120  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    332    238    242 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     120	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    121  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    333    242    134 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     121	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    122  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    334    134    114 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     122	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    123  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    335    114    234 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     123	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    124  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    336    231    239 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     124	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    125  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    337    239    243 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     125	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    126  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    338    243    135 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     126	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    127  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    339    135    115 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     127	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    128  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    340    115    235 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     128	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    129  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    341    232    240 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     129	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    130  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    342    240    244 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     130	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    131  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    343    244    136 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     131	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    132  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    344    136    116 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     132	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    133  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    345    116    236 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     133	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    134  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    346    254    266 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     134	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    135  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    347    266    262 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     135	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    136  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    348    262    270 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     136	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    137  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    349    270    258 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     137	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    138  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    350    255    267 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     138	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    139  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    351    267    263 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     139	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    140  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    352    263    271 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     140	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    141  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    353    271    259 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     141	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    142  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    354    256    268 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     142	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    143  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    355    268    264 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     143	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    144  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    356    264    272 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     144	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    145  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    357    272    260 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     145	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    146  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    358    274    154 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     146	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    147  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    359    154    286 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     147	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    148  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    360    286    142 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     148	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    149  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    361    142    282 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     149	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    150  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    362    282    150 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     150	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    151  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    363    150    290 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     151	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    152  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    364    290    278 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     152	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    153  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    365    275    155 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     153	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    154  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    366    155    287 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     154	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    155  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    367    287    143 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     155	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    156  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    368    143    283 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     156	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    157  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    369    283    151 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     157	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    158  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    370    151    291 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     158	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    159  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    371    291    279 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     159	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    160  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    372    276    156 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     160	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    161  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    373    156    288 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     161	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    162  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    374    288    144 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     162	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    163  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    375    144    284 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     163	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    164  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    376    284    152 1.000e+01 2.900e+10 8.700e+09 5.000e+00 5.000e+00 5.000e+00     164	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    165  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    377    152    292 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     165	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    166  0.000 -1.000  0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    378    292    280 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     166	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    167  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    379    294    298 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     167	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    168  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    380    295    299 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     168	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    169  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    381    296    300 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     169	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    170  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    382    302    306 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     170	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    171  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    383    303    307 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     171	 -mass	[expr 3*0.150 * $density_int*0]
geomTransf Linear    172  1.000  0.000 -0.000 -jntOffset  0.000  0.000  0.000  0.000  0.000  0.000  		
element elasticBeamColumn    384    304    308 1.000e+01 2.900e+10 8.700e+09 0.000e+00 0.000e+00 0.000e+00     172	 -mass	[expr 3*0.150 * $density_int*0]

#END Elastic beams---------------------------------------------------- 

#NONLINEAR BEAMS ---------------------------------------------------------- 
#END Nonlinear beams---------------------------------------------------- 

#NODAL MASSES ------------------------------------------------------------ 
#       tag         X         Y         Z        RX        RY        RZ 
mass      6    1452.3    1452.3    1452.3     232.4     641.9     409.5 
mass      7    1452.3    1452.3    1452.3     232.4     641.9     409.5 
mass      8    1452.3    1452.3    1452.3     232.4     641.9     409.5 
mass     33     475.6     475.6     475.6      29.7      75.3      45.6 
mass     34    1236.7    1236.7    1236.7     151.5     270.0     118.5 
mass     35    1236.7    1236.7    1236.7     151.5     270.0     118.5 
mass     36     761.0     761.0     761.0     121.8     194.7      72.9 
mass     41     731.6     731.6     731.6      45.7     191.1     145.4 
mass     42    1235.6    1235.6    1235.6     151.4     269.4     118.0 
mass     43    1235.6    1235.6    1235.6     151.4     269.4     118.0 
mass     44     760.3     760.3     760.3     121.7     194.3      72.6 
mass     49     291.5     291.5     291.5      16.7      53.7      36.9 
mass     50     547.7     547.7     547.7      28.1      97.5      69.4 
mass     51     547.7     547.7     547.7      28.1      97.5      69.4 
mass     52     256.2     256.2     256.2      11.4      43.8      32.5 
mass     57    1217.1    1217.1    1217.1     304.3     458.5     154.3 
mass     58    1582.2    1582.2    1582.2     193.8     394.3     200.5 
mass     59    1582.2    1582.2    1582.2     193.8     394.3     200.5 
mass     60     973.7     973.7     973.7     155.8     279.2     123.4 
mass     61     694.0     694.0     694.0      43.4     190.3     146.9 
mass     62    1804.5    1804.5    1804.5     221.0     603.1     382.0 
mass     63    1804.5    1804.5    1804.5     221.0     603.1     382.0 
mass     64    1110.4    1110.4    1110.4     177.7     412.8     235.1 
mass     73    1217.1    1217.1    1217.1     304.3     458.5     154.3 
mass     74    1582.2    1582.2    1582.2     193.8     394.3     200.5 
mass     75    1582.2    1582.2    1582.2     193.8     394.3     200.5 
mass     76     973.7     973.7     973.7     155.8     279.2     123.4 
mass     77    1014.5    1014.5    1014.5      63.4     718.0     654.6 
mass     78    1804.5    1804.5    1804.5     221.0     603.1     382.0 
mass     79    1804.5    1804.5    1804.5     221.0     603.1     382.0 
mass     80    1110.4    1110.4    1110.4     177.7     412.8     235.1 
mass     89     230.1     230.1     230.1      13.2      31.4      18.2 
mass     90     432.3     432.3     432.3      22.2      56.3      34.1 
mass     91     432.3     432.3     432.3      22.2      56.3      34.1 
mass     92     202.2     202.2     202.2       9.0      24.9      16.0 
mass     93     230.1     230.1     230.1      13.2      31.4      18.2 
mass     94     432.3     432.3     432.3      22.2      56.3      34.1 
mass     95     432.3     432.3     432.3      22.2      56.3      34.1 
mass     96     202.2     202.2     202.2       9.0      24.9      16.0 
mass    209     291.5     291.5     291.5      16.7      53.7      36.9 
mass    210     547.7     547.7     547.7      28.1      97.5      69.4 
mass    211     547.7     547.7     547.7      28.1      97.5      69.4 
mass    212     256.2     256.2     256.2      11.4      43.8      32.5 
#END MASSES ------------------------------------------------------------ 
puts "Model defined." 



