function main() as Void
  reg = CreateObject("roRegistrySection", "brightscript")
  reg.write("debug","1")

  setupSSH()
  setupInspector()
  useChromiumMediaPlayback()
  upgradeIfRequired()

  mp = CreateObject("roMessagePort")
  widget = createHTMLWidget(mp)
  widget.show()

  while true
    msg = wait(0, mp)
    print "type(msg)=";type(msg)
    if type(msg) = "roHtmlWidgetEvent" then
      eventData = msg.GetData()

      if type(eventData) = "roAssociativeArray" and type(eventData.reason) = "roString" then
        print "reason: ";eventData.reason

        if eventData.reason = "load-error" then
          print "message: ";eventData.message
        endif

        if type(eventData.message) = "roAssociativeArray" then
          print "request: ";eventData.message.request

          if eventData.message.request = "screenshot" then
            sendScreenshot(eventData.message.url, eventData.message.id, widget)
          endif

          if eventData.message.request = "screen-on" then
            SendCecActivateToTV()
          endif

          if eventData.message.request = "screen-off" then
            SendCecStandbyToTV()
          endif
        endif
      endif
    endif
  end while
end function

function useChromiumMediaPlayback() as Void
  registrySection = CreateObject("roRegistrySection", "html")
  registrySection.Write("use-brightsign-media-player", "0")
  registrySection.Flush()
end function

function setupSSH() as Void
  reg = CreateObject("roRegistrySection", "networking")
  reg.write("ssh","22")

  n=CreateObject("roNetworkConfiguration", 0)
  n.SetLoginPassword("password")
  n.Apply()
end function

function setupInspector() as Void
  reg = CreateObject("roRegistrySection","html")
  reg.Write("enable_web_inspector", "1")
  reg.Flush()
end function

function sysInfo() as String
  di = CreateObject("roDeviceInfo")

  return "pn%3DBrightSign%20Player" + "%26product_name%3D" + di.GetModel() + "%26sn%3D" + di.GetDeviceUniqueId() + "%26pv%3D" + GetRunningVersion()
end function

function sendScreenshot(url as string, id as string, widget as object)
  print "url: ";url
  print "id: ";id

  vidmode = CreateObject("roVideoMode")
  vidWidth = vidmode.GetResX()
  vidHeight = vidmode.GetResY()

  success = vidmode.Screenshot({filetype: "JPEG", filename: "screenshot.jpg", width: vidWidth, height: vidHeight, async: 0})

  if success then
    urlTransfer = CreateObject("roUrlTransfer")
    urlTransfer.SetUrl(url)
    urlTransfer.SetTimeout(10000)
    urlTransfer.AddHeader("Cache-Control", "public, max-age=0, no-cache, no-store")
    resp = urlTransfer.PutFromFile("screenshot.jpg")

    print "resp: ";resp
    if resp = 200 then
      widget.PostJSMessage({topic: "screenshot-success", id: id})
    else
      widget.PostJSMessage({topic: "screenshot-failure", id: id})
    endif
  else
      widget.PostJSMessage({topic: "screenshot-failure", id: id})
  endif
end function

function createHTMLWidget(mp as object) as object
  vidmode = CreateObject("roVideoMode")
  width = vidmode.GetResX()
  height = vidmode.GetResY()
  r = CreateObject("roRectangle",0,0,width,height)

  config = {
    nodejs_enabled: true,
    brightsign_js_objects_enabled: true,
    url: "https://widgets.risevision.com/viewer/Viewer.html?type=webplayer&env=brightsign&sysInfo=" + sysInfo(),
    inspector_server: {
      ip_addr: "0.0.0.0",
      port: 6666
    },
    port: mp,
    storage_path: "storage",
    storage_quota: "2000000000",
    javascript_injection: {
      document_creation: [{source: "data:text/javascript;charset=utf-8;base64,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"}]
    }
  }

  h = CreateObject("roHtmlWidget",r,config)
  return h
end function

REM *****************
REM CEC Functions
REM *****************

sub SendCecActivateToTV()
  print "Sending CEC Activate"
  SendCecHexMessageToTV("400D")
end sub

sub SendCecStandbyToTV()
  print "Sending CEC Standby"
  SendCecHexMessageToTV("4036")
end sub

sub SendCecHexMessageToTV(message as string)
  if message <> "4036" AND message <> "400D"
    print "Invalid CEC message"
    return
  end if

  cec = CreateObject("roCecInterface")
  if cec = invalid
      print "Failed to create roCecInterface"
      return
  end if

  ' Set up message port to receive send completion events
  mp = CreateObject("roMessagePort")
  cec.SetPort(mp)

  packet = CreateObject("roByteArray")
  packet.FromHexString(message)

  success = cec.SendRawMessage(packet)
  if not success
      print "SendRawMessage failed"
      return
  end if

  print "CEC message sent, waiting for confirmation..."

  ' Wait for response (max 5 seconds)
  startTime = CreateObject("roTimespan")
  while true
      msg = wait(5000, mp)
      if type(msg) = "roCecTxCompleteEvent"
          if msg.GetStatusByte() = 0
              print "CEC command sent successfully."
          else
              print "CEC command failed. Result."
          end if
          exit while
      else
          print "Timed out waiting for send confirmation."
          exit while
      end if
  end while
end sub

REM *****************
REM Upgrade functions
REM *****************

function upgradeIfRequired() as Void
  print "Starting upgrade check"

  remoteData = GetRemoteJSON("https://storage.googleapis.com/install-versions.risevision.com/brightsign/brightsign-rollout.json")

  if remoteData = invalid then
    print "Failed to fetch remote version data."
    return
  end if

  if not (type(remoteData) = "roAssociativeArray" and remoteData.DoesExist("pct") and remoteData.DoesExist("version") and remoteData.DoesExist("url") and remoteData.DoesExist("adler32")) then
    print "Invalid remote data structure."
    return
  end if

  pctRoll = Int(Rnd(0) * 100)

  forceUpgrade = ReadAsciiFile("FORCE_UPGRADE_RISE_VISION")

  print "forceUpgrade |" ; forceUpgrade ; "|"

  if forceUpgrade <> invalid and forceUpgrade <> ""
    print "File FORCE_UPGRADE_RISE_VISION found. Ignoring rollout pct."
  else
    if pctRoll >= Int(remoteData.pct) then
      print "Remote rollout "; remoteData.pct ; " vs " ; pctRoll ; ". Not upgrading."
      return
    end if
  end if

  remoteVersion = remoteData.version
  localVersion = GetRunningVersion()
  updateUrl = remoteData.url
  remoteChecksum = strtoi(remoteData.adler32)

  if remoteChecksum < 0 then
    remoteChecksum = remoteChecksum + 2^32
  end if

  if remoteVersion = "" or localVersion = "" then
    print "Invalid version data."
    return
  end if

  if remoteVersion = localVersion then
    print "Version up to date."
    return
  end if

  print "New version available: " ; remoteVersion

  tmpFile = "autorun.tmp"

  responseCode = DownloadToFile(updateUrl, tmpFile)

  if responseCode <> 200 then
    print "Update failed. Response code: " ; responseCode
    return
  end if

  localChecksum = Adler32FileChecksum(tmpFile)
  if localChecksum <> remoteChecksum then
    print "Checksum mismatch! Update aborted."
    print "Calculated |" ; localChecksum ; "| but expected |" ; remoteChecksum ; "|"
    return
  end if

  if CopyFile(tmpFile, "autorun.brs") then
    print "autorun.brs updated successfully!"
  else
    print "Failed to overwrite autorun.brs!"
    return
  end if

  print "Update complete. Restarting..."
  RestartApplication()
end function

function GetRunningVersion()
  return "2025.07.07.17.00"
end function

function GetRemoteJSON(url as String) as Object
  urlTransfer = CreateObject("roUrlTransfer")
  urlTransfer.SetUrl(url)
  urlTransfer.SetTimeout(10000)
  response = urlTransfer.GetToString()

  if response = invalid then
    print "Remote JSON request failed"
    return invalid
  end if

  if response = "" then
    print "Empty remote JSON response received"
    return invalid
  end if

  json = ParseJSON(response)

  if json = invalid then
    print "Failed to parse JSON response"
    return invalid
  end if

  return json
end function

function DownloadToFile(updateUrl as String, destFile as String) as Integer
  if not (Left(updateUrl, 8) = "https://" and Instr(1, updateUrl, "install-versions.risevision.com") > 0) then
    print "Incorrect update url: "; updateUrl
    return 403
  end if

  print "Downloading update from: "; updateUrl

  urlTransfer = CreateObject("roUrlTransfer")
  urlTransfer.SetUrl(updateUrl)
  urlTransfer.SetTimeout(10000)

  return urlTransfer.GetToFile(destFile)
end function

function Adler32FileChecksum(filePath as String)
  print "Checking file integrity."
  mod_adler = 65521
  a = 1
  b = 0

  file = createObject("roReadFile", filePath)
  if file = invalid then
      print "Error opening file: " + filePath
      return -1
  end if

  while true
      chunk = file.ReadBlock(1024)
      if chunk = invalid or len(chunk) = 0 then exit while

      for i = 0 to len(chunk)-1
          byte = asc(mid(chunk, i+1, 1)) ' 1-based indexing in mid()
          a = (a + byte) mod mod_adler
          b = (b + a) mod mod_adler
      end for
  end while

  return (b * 2^16) or a
end function
