/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.MPVariable;
import com.google.ortools.linearsolver.mainJNI;

public class MPObjective {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPObjective(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MPObjective obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_MPObjective(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void clear() {
        mainJNI.MPObjective_clear(this.swigCPtr, this);
    }

    public void setCoefficient(MPVariable var, double coeff) {
        mainJNI.MPObjective_setCoefficient(this.swigCPtr, this, MPVariable.getCPtr(var), var, coeff);
    }

    public double getCoefficient(MPVariable var) {
        return mainJNI.MPObjective_getCoefficient(this.swigCPtr, this, MPVariable.getCPtr(var), var);
    }

    public void setOffset(double value) {
        mainJNI.MPObjective_setOffset(this.swigCPtr, this, value);
    }

    public double offset() {
        return mainJNI.MPObjective_offset(this.swigCPtr, this);
    }

    public void setOptimizationDirection(boolean maximize) {
        mainJNI.MPObjective_setOptimizationDirection(this.swigCPtr, this, maximize);
    }

    public void setMinimization() {
        mainJNI.MPObjective_setMinimization(this.swigCPtr, this);
    }

    public void setMaximization() {
        mainJNI.MPObjective_setMaximization(this.swigCPtr, this);
    }

    public boolean maximization() {
        return mainJNI.MPObjective_maximization(this.swigCPtr, this);
    }

    public boolean minimization() {
        return mainJNI.MPObjective_minimization(this.swigCPtr, this);
    }

    public double value() {
        return mainJNI.MPObjective_value(this.swigCPtr, this);
    }

    public double bestBound() {
        return mainJNI.MPObjective_bestBound(this.swigCPtr, this);
    }
}

