/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.CpSolverResponse;
import com.google.ortools.sat.IntegerVariableProto;
import com.google.ortools.sat.mainJNI;
import com.google.ortools.util.Domain;

public class CpSatHelper {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public CpSatHelper(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(CpSatHelper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_CpSatHelper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String modelStats(CpModelProto model_proto) {
        return mainJNI.CpSatHelper_modelStats(model_proto.toByteArray());
    }

    public static String solverResponseStats(CpSolverResponse response) {
        return mainJNI.CpSatHelper_solverResponseStats(response.toByteArray());
    }

    public static String validateModel(CpModelProto model_proto) {
        return mainJNI.CpSatHelper_validateModel(model_proto.toByteArray());
    }

    public static Domain variableDomain(IntegerVariableProto variable_proto) {
        return new Domain(mainJNI.CpSatHelper_variableDomain(variable_proto.toByteArray()), true);
    }

    public static boolean writeModelToFile(CpModelProto model_proto, String filename) {
        return mainJNI.CpSatHelper_writeModelToFile(model_proto.toByteArray(), filename);
    }

    public CpSatHelper() {
        this(mainJNI.new_CpSatHelper(), true);
    }
}

