/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapGenerator;
import jugglinglab.generator.SiteswapTransitioner;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPatternList;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.OpenFilesServer;
import jugglinglab.util.ParameterList;
import org.xml.sax.SAXException;

public class JugglingLab {
    public static final ResourceBundle guistrings = ResourceBundle.getBundle("GUIStrings");
    public static final ResourceBundle errorstrings = ResourceBundle.getBundle("ErrorStrings");
    public static final boolean isMacOS;
    public static final boolean isWindows;
    public static final boolean isLinux;
    public static final boolean isCLI;
    public static final Path base_dir;
    private static ArrayList<String> jlargs;

    public static void main(String[] args) {
        boolean show_help;
        if (isMacOS) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        boolean run_application = true;
        String firstarg = null;
        if (args.length > 0) {
            jlargs = new ArrayList<String>(Arrays.asList(args));
            firstarg = jlargs.remove(0).toLowerCase();
            run_application = firstarg.equals("start");
        }
        if (run_application) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JugglingLab.registerAboutHandler();
                        new ApplicationWindow("Juggling Lab");
                    }
                    catch (JuggleExceptionUser jeu) {
                        new ErrorDialog(null, jeu.getMessage());
                    }
                    catch (JuggleExceptionInternal jei) {
                        ErrorDialog.handleFatalException(jei);
                    }
                }
            });
            return;
        }
        if (firstarg.equals("open")) {
            JugglingLab.doOpen();
            return;
        }
        if (!isCLI) {
            return;
        }
        List<String> modes = Arrays.asList("gen", "trans", "verify", "anim", "togif", "tojml");
        boolean bl = show_help = !modes.contains(firstarg);
        if (show_help) {
            JugglingLab.doHelp(firstarg);
            return;
        }
        Path outpath = JugglingLab.parse_outpath();
        AnimationPrefs jc = JugglingLab.parse_animprefs();
        if (firstarg.equals("gen")) {
            JugglingLab.doGen(outpath, jc);
            return;
        }
        if (firstarg.equals("trans")) {
            JugglingLab.doTrans(outpath, jc);
            return;
        }
        if (firstarg.equals("verify")) {
            JugglingLab.doVerify(outpath, jc);
            return;
        }
        JMLPattern pat = JugglingLab.parse_pattern();
        if (pat == null) {
            return;
        }
        if (jlargs.size() > 0) {
            System.setProperty("java.awt.headless", "true");
            String arglist = String.join((CharSequence)", ", jlargs);
            System.out.println("Error: Unrecognized input: " + arglist);
            return;
        }
        if (firstarg.equals("anim")) {
            JugglingLab.doAnim(pat, jc);
            return;
        }
        System.setProperty("java.awt.headless", "true");
        if (firstarg.equals("togif")) {
            JugglingLab.doTogif(pat, outpath, jc);
            return;
        }
        if (firstarg.equals("tojml")) {
            JugglingLab.doTojml(pat, outpath, jc);
            return;
        }
    }

    private static void registerAboutHandler() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        if (!Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT)) {
            return;
        }
        Desktop.getDesktop().setAboutHandler(new AboutHandler(){

            @Override
            public void handleAbout(AboutEvent e) {
                ApplicationWindow.showAboutBox();
            }
        });
    }

    private static void doOpen() {
        boolean noOpenFilesHandler;
        final ArrayList<File> files = JugglingLab.parse_filelist();
        if (files == null) {
            return;
        }
        boolean bl = noOpenFilesHandler = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE);
        if (noOpenFilesHandler) {
            Iterator<File> iterator = files.iterator();
            while (iterator.hasNext()) {
                if (!OpenFilesServer.tryOpenFile(iterator.next())) continue;
                iterator.remove();
            }
            if (files.size() == 0) {
                System.setProperty("java.awt.headless", "true");
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JugglingLab.registerAboutHandler();
                    new ApplicationWindow("Juggling Lab");
                    for (File file : files) {
                        try {
                            ApplicationWindow.openJMLFile(file);
                        }
                        catch (JuggleExceptionUser jeu) {
                            String template = errorstrings.getString("Error_reading_file");
                            Object[] arguments = new Object[]{file.getName()};
                            String msg = MessageFormat.format(template, arguments) + ":\n" + jeu.getMessage();
                            new ErrorDialog(null, msg);
                        }
                    }
                }
                catch (JuggleExceptionUser jeu) {
                    new ErrorDialog(null, jeu.getMessage());
                }
                catch (JuggleExceptionInternal jei) {
                    ErrorDialog.handleFatalException(jei);
                }
            }
        });
    }

    private static ArrayList<File> parse_filelist() {
        if (jlargs.size() == 0) {
            String output = "Error: Expected file path(s), none provided";
            if (isCLI) {
                System.setProperty("java.awt.headless", "true");
                System.out.println(output);
            } else {
                new ErrorDialog(null, output);
            }
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String filestr : jlargs) {
            Path filepath;
            if (filestr.startsWith("\"")) {
                filestr = filestr.substring(1, filestr.length() - 1);
            }
            if (!(filepath = Paths.get(filestr, new String[0])).isAbsolute() && base_dir != null) {
                filepath = Paths.get(base_dir.toString(), filestr);
            }
            files.add(filepath.toFile());
        }
        return files;
    }

    private static void doHelp(String firstarg) {
        System.setProperty("java.awt.headless", "true");
        String template = guistrings.getString("Version");
        Object[] arg1 = new Object[]{"1.6.6"};
        String output = "Juggling Lab " + MessageFormat.format(template, arg1).toLowerCase() + "\n";
        template = guistrings.getString("Copyright_message");
        Object[] arg2 = new Object[]{"2025"};
        output = output + MessageFormat.format(template, arg2) + "\n";
        output = output + guistrings.getString("GPL_message") + "\n\n";
        output = output + guistrings.getString("CLI_help1");
        String examples = guistrings.getString("CLI_help2");
        if (isWindows) {
            examples = examples.replaceAll("'", "\"");
        }
        output = output + examples;
        System.out.println(output);
        if (firstarg != null && !firstarg.equals("help")) {
            System.out.println("\nUnrecognized option: " + firstarg);
        }
    }

    private static Path parse_outpath() {
        for (int i = 0; i < jlargs.size(); ++i) {
            if (!jlargs.get(i).equalsIgnoreCase("-out")) continue;
            jlargs.remove(i);
            if (i == jlargs.size()) {
                System.out.println("Warning: No output path specified after -out flag; ignoring");
                return null;
            }
            String outpath_string = jlargs.remove(i);
            Path outpath = Paths.get(outpath_string, new String[0]);
            if (!outpath.isAbsolute() && base_dir != null) {
                outpath = Paths.get(base_dir.toString(), outpath_string);
            }
            return outpath;
        }
        return null;
    }

    private static AnimationPrefs parse_animprefs() {
        for (int i = 0; i < jlargs.size(); ++i) {
            if (!jlargs.get(i).equalsIgnoreCase("-prefs")) continue;
            jlargs.remove(i);
            if (i == jlargs.size()) {
                System.out.println("Warning: Nothing specified after -prefs flag; ignoring");
                return null;
            }
            try {
                ParameterList pl = new ParameterList(jlargs.remove(i));
                AnimationPrefs jc = new AnimationPrefs().fromParameters(pl);
                pl.errorIfParametersLeft();
                return jc;
            }
            catch (JuggleExceptionUser jeu) {
                System.out.println("Error in animator prefs: " + jeu.getMessage() + "; ignoring");
                return null;
            }
        }
        return null;
    }

    private static void doGen(Path outpath, AnimationPrefs jc) {
        System.setProperty("java.awt.headless", "true");
        String[] genargs = jlargs.toArray(new String[jlargs.size()]);
        try {
            PrintStream ps = System.out;
            if (outpath != null) {
                ps = new PrintStream(outpath.toFile());
            }
            SiteswapGenerator.runGeneratorCLI(genargs, new GeneratorTarget(ps));
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Error: Problem writing to file path " + outpath.toString());
        }
        if (jc != null) {
            System.out.println("Note: Animator prefs not used in generator mode; ignored");
        }
    }

    private static void doTrans(Path outpath, AnimationPrefs jc) {
        System.setProperty("java.awt.headless", "true");
        String[] transargs = jlargs.toArray(new String[jlargs.size()]);
        try {
            PrintStream ps = System.out;
            if (outpath != null) {
                ps = new PrintStream(outpath.toFile());
            }
            SiteswapTransitioner.runTransitionerCLI(transargs, new GeneratorTarget(ps));
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Error: Problem writing to file path " + outpath.toString());
        }
        if (jc != null) {
            System.out.println("Note: Animator prefs not used in transitions mode; ignored");
        }
    }

    private static void doVerify(Path outpath, AnimationPrefs jc) {
        System.setProperty("java.awt.headless", "true");
        ArrayList<File> files = JugglingLab.parse_filelist();
        if (files == null) {
            return;
        }
        if (jc != null) {
            System.out.println("Note: Animator prefs not used in verify mode; ignored\n");
        }
        PrintStream ps = System.out;
        try {
            if (outpath != null) {
                ps = new PrintStream(outpath.toFile());
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Error: Problem writing to file path " + outpath.toString());
            return;
        }
        int error_count = 0;
        int files_with_errors_count = 0;
        int files_count = 0;
        int patterns_count = 0;
        for (File file : files) {
            ps.println("Verifying " + file.getAbsolutePath());
            ++files_count;
            int error_count_current_file = 0;
            JMLParser parser = new JMLParser();
            try {
                parser.parse(new FileReader(file));
            }
            catch (SAXException se) {
                ps.println("   Error: Formatting error in JML file");
                ++error_count_current_file;
            }
            catch (IOException ioe) {
                ps.println("   Error: Problem reading JML file");
                ++error_count_current_file;
            }
            if (error_count_current_file > 0) {
                error_count += error_count_current_file;
                ++files_with_errors_count;
                continue;
            }
            if (parser.getFileType() == 1) {
                try {
                    ++patterns_count;
                    JMLPattern pat = new JMLPattern(parser.getTree());
                    pat.layoutPattern();
                    ps.println("   OK");
                }
                catch (JuggleException je) {
                    ps.println("   Error creating pattern: " + je.getMessage());
                    ++error_count_current_file;
                }
            } else if (parser.getFileType() == 2) {
                JMLPatternList pl = null;
                try {
                    pl = new JMLPatternList(parser.getTree());
                }
                catch (JuggleExceptionUser jeu) {
                    ps.println("   Error creating pattern list: " + jeu.getMessage());
                    ++error_count_current_file;
                }
                if (error_count_current_file > 0) {
                    error_count += error_count_current_file;
                    ++files_with_errors_count;
                    continue;
                }
                for (int i = 0; i < pl.size(); ++i) {
                    try {
                        JMLPattern pat = pl.getPatternForLine(i);
                        if (pat == null) continue;
                        ++patterns_count;
                        pat.layoutPattern();
                        pl.getAnimationPrefsForLine(i);
                        ps.println("   Pattern line " + (i + 1) + ": OK");
                        continue;
                    }
                    catch (JuggleException je) {
                        ps.println("   Pattern line " + (i + 1) + ": Error: " + je.getMessage());
                        ++error_count_current_file;
                    }
                }
            } else {
                ps.println("   Error: File is not valid JML");
                ++error_count_current_file;
            }
            if (error_count_current_file <= 0) continue;
            error_count += error_count_current_file;
            ++files_with_errors_count;
        }
        ps.println();
        ps.println("Processed " + patterns_count + " patterns in " + files_count + " files");
        if (error_count == 0) {
            ps.println("   All files OK");
        } else {
            ps.println("   Files with errors: " + files_with_errors_count);
            ps.println("   Total errors found: " + error_count);
        }
    }

    private static JMLPattern parse_pattern() {
        if (jlargs.size() == 0) {
            System.out.println("Error: Expected pattern input, none found");
            return null;
        }
        if (jlargs.get(0).equalsIgnoreCase("-jml")) {
            jlargs.remove(0);
            if (jlargs.size() == 0) {
                System.out.println("Error: No input path specified after -jml flag");
                return null;
            }
            String inpath_string = jlargs.remove(0);
            Path inpath = Paths.get(inpath_string, new String[0]);
            if (!inpath.isAbsolute() && base_dir != null) {
                inpath = Paths.get(base_dir.toString(), inpath_string);
            }
            try {
                JMLParser parser = new JMLParser();
                parser.parse(new FileReader(inpath.toFile()));
                switch (parser.getFileType()) {
                    case 1: {
                        return new JMLPattern(parser.getTree());
                    }
                    case 2: {
                        System.out.println("Error: JML file cannot be a pattern list");
                        break;
                    }
                    default: {
                        System.out.println("Error: File is not valid JML");
                        break;
                    }
                }
            }
            catch (JuggleExceptionUser jeu) {
                System.out.println("Error parsing JML: " + jeu.getMessage());
            }
            catch (SAXException se) {
                System.out.println("Error: Formatting error in JML file");
            }
            catch (IOException ioe) {
                System.out.println("Error: Problem reading JML file from path " + inpath.toString());
            }
            return null;
        }
        try {
            String config = jlargs.remove(0);
            return JMLPattern.fromBasePattern("siteswap", config);
        }
        catch (JuggleExceptionUser jeu) {
            System.out.println("Error: " + jeu.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            System.out.println("Internal Error: " + jei.getMessage());
        }
        return null;
    }

    private static void doAnim(JMLPattern pat, AnimationPrefs jc) {
        final JMLPattern fpat = pat;
        final AnimationPrefs fjc = jc;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JugglingLab.registerAboutHandler();
                    new PatternWindow(fpat.getTitle(), fpat, fjc);
                    PatternWindow.setExitOnLastClose(true);
                }
                catch (JuggleExceptionUser jeu) {
                    System.out.println("Error: " + jeu.getMessage());
                }
                catch (JuggleExceptionInternal jei) {
                    ErrorDialog.handleFatalException(jei);
                }
            }
        });
    }

    private static void doTogif(JMLPattern pat, Path outpath, AnimationPrefs jc) {
        if (outpath == null) {
            System.out.println("Error: No output path specified for animated GIF");
            return;
        }
        try {
            Animator anim = new Animator();
            if (jc == null) {
                jc = anim.getAnimationPrefs();
                jc.fps = 33.3;
            }
            anim.setDimension(new Dimension(jc.width, jc.height));
            anim.restartAnimator(pat, jc);
            anim.writeGIF(new FileOutputStream(outpath.toFile()), null, jc.fps);
        }
        catch (JuggleExceptionUser jeu) {
            System.out.println("Error: " + jeu.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            System.out.println("Internal Error: " + jei.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("Error: Problem writing GIF to path " + outpath.toString());
        }
    }

    private static void doTojml(JMLPattern pat, Path outpath, AnimationPrefs jc) {
        if (outpath == null) {
            System.out.print(pat.toString());
        } else {
            try {
                FileWriter fw = new FileWriter(outpath.toFile());
                pat.writeJML(fw, true, true);
                fw.close();
            }
            catch (IOException ioe) {
                System.out.println("Error: Problem writing JML to path " + outpath.toString());
            }
        }
        if (jc != null) {
            System.out.println("Note: Animator prefs not used in jml output mode; ignored");
        }
    }

    static {
        String osname = System.getProperty("os.name").toLowerCase();
        isMacOS = osname.startsWith("mac os x");
        isWindows = osname.startsWith("windows");
        isLinux = osname.startsWith("linux");
        String working_dir = System.getenv("JL_WORKING_DIR");
        boolean bl = isCLI = working_dir != null;
        if (working_dir == null) {
            try {
                working_dir = Preferences.userRoot().node("Juggling Lab").get("base_dir", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (working_dir == null) {
            String isBundle = System.getProperty("JL_run_as_bundle");
            working_dir = isBundle != null && isBundle.equals("true") ? System.getProperty("user.home") : System.getProperty("user.dir");
        }
        base_dir = Paths.get(working_dir, new String[0]);
    }
}

