/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.SwingUtilities;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.EditLadderDiagram;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.renderer.Renderer;
import jugglinglab.util.Coordinate;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class AnimationEditPanel
extends AnimationPanel
implements MouseListener,
MouseMotionListener {
    protected static final double EVENT_BOX_HW_CM = 5.0;
    protected static final double UNSELECTED_BOX_HW_CM = 2.0;
    protected static final double YZ_EVENT_SNAP_CM = 3.0;
    protected static final double XZ_CONTROL_SHOW_DEG = 60.0;
    protected static final double Y_CONTROL_SHOW_DEG = 30.0;
    protected static final Color COLOR_EVENTS = Color.green;
    protected static final double HANDPATH_POINT_SEP_TIME = 0.01;
    protected static final Color COLOR_HANDPATH = Color.lightGray;
    protected static final double POSITION_BOX_HW_CM = 10.0;
    protected static final double POSITION_BOX_Z_OFFSET_CM = 0.0;
    protected static final double XY_GRID_SPACING_CM = 20.0;
    protected static final double XYZ_GRID_POSITION_SNAP_CM = 3.0;
    protected static final double GRID_SHOW_DEG = 70.0;
    protected static final double ANGLE_CONTROL_SHOW_DEG = 70.0;
    protected static final double XY_CONTROL_SHOW_DEG = 70.0;
    protected static final double Z_CONTROL_SHOW_DEG = 30.0;
    protected static final Color COLOR_POSITIONS = Color.green;
    protected static final Color COLOR_GRID = Color.lightGray;
    protected boolean event_active;
    protected JMLEvent event;
    protected boolean dragging_xz;
    protected boolean dragging_y;
    protected boolean show_xz_drag_control;
    protected boolean show_y_drag_control;
    protected Coordinate event_start;
    protected Coordinate event_master_start;
    protected ArrayList<JMLEvent> visible_events;
    protected double[][][][] event_points;
    protected double[][][] handpath_points;
    protected double handpath_start_time;
    protected double handpath_end_time;
    protected boolean[] handpath_hold;
    protected boolean position_active;
    protected JMLPosition position;
    protected double[][][] pos_points;
    protected boolean dragging_xy;
    protected boolean dragging_z;
    protected boolean dragging_angle;
    protected boolean show_xy_drag_control;
    protected boolean show_z_drag_control;
    protected boolean show_angle_drag_control;
    protected Coordinate position_start;
    protected double startangle;
    protected double deltaangle;
    protected double[] start_dx;
    protected double[] start_dy;
    protected double[] start_control;
    protected boolean dragging;
    protected boolean dragging_left;
    protected int deltax;
    protected int deltay;
    long lastpress = 0L;
    long lastenter = 1L;
    protected static final double[][] event_control_points = new double[][]{{-5.0, 0.0, -5.0}, {-5.0, 0.0, 5.0}, {5.0, 0.0, 5.0}, {5.0, 0.0, -5.0}, {0.0, 0.0, 0.0}, {0.0, 10.0, 0.0}, {0.0, -10.0, 0.0}, {0.0, 7.0, 2.0}, {0.0, 7.0, -2.0}, {0.0, -7.0, 2.0}, {0.0, -7.0, -2.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected static final int[] face_xz = new int[]{0, 1, 2, 3};
    protected static final double[][] unselected_event_points = new double[][]{{-2.0, 0.0, -2.0}, {-2.0, 0.0, 2.0}, {2.0, 0.0, 2.0}, {2.0, 0.0, -2.0}, {0.0, 0.0, 0.0}};
    protected static final double[][] pos_control_points = new double[][]{{-10.0, -10.0, 0.0}, {-10.0, 10.0, 0.0}, {10.0, 10.0, 0.0}, {10.0, -10.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, -20.0, 0.0}, {0.0, 0.0, 20.0}, {2.0, 0.0, 17.0}, {-2.0, 0.0, 17.0}, {0.0, -250.0, 0.0}, {0.0, 250.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected static final int[] face_xy = new int[]{0, 1, 2, 3};

    @Override
    public void mousePressed(MouseEvent me) {
        int t;
        int i;
        int my;
        int mx;
        this.lastpress = me.getWhen();
        if (this.jc.mousePause && this.lastpress == this.lastenter) {
            return;
        }
        if (!this.engineAnimating) {
            return;
        }
        if (this.writingGIF) {
            return;
        }
        this.startx = me.getX();
        this.starty = me.getY();
        if (this.event_active) {
            mx = me.getX();
            my = me.getY();
            for (i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
                t = i * this.getSize().width / 2;
                if (this.show_y_drag_control) {
                    this.dragging_y = JLFunc.isNearLine(mx - t, my, (int)Math.round(this.event_points[0][i][5][0]), (int)Math.round(this.event_points[0][i][5][1]), (int)Math.round(this.event_points[0][i][6][0]), (int)Math.round(this.event_points[0][i][6][1]), 4);
                    if (this.dragging_y) {
                        this.dragging = true;
                        this.dragging_left = i == 0;
                        this.deltay = 0;
                        this.deltax = 0;
                        this.event_start = this.event.getLocalCoordinate();
                        JMLEvent master = this.event.isMaster() ? this.event : this.event.getMaster();
                        this.event_master_start = master.getLocalCoordinate();
                        this.repaint();
                        return;
                    }
                }
                if (!this.show_xz_drag_control) continue;
                for (int j = 0; j < this.event_points.length; ++j) {
                    if (!AnimationEditPanel.isInsidePolygon(mx - t, my, this.event_points[j], i, face_xz)) continue;
                    if (j > 0) {
                        try {
                            this.activateEvent(this.getPattern().getEventImageInLoop(this.visible_events.get(j)));
                            for (AnimationPanel.AnimationAttachment att : this.attachments) {
                                if (att instanceof EditLadderDiagram) {
                                    EditLadderDiagram eld = (EditLadderDiagram)att;
                                    eld.activateEvent(this.event);
                                }
                                att.repaintAttachment();
                            }
                        }
                        catch (JuggleExceptionInternal jei) {
                            jei.attachPattern(this.getPattern());
                            ErrorDialog.handleFatalException(jei);
                        }
                    }
                    this.dragging_xz = true;
                    this.dragging = true;
                    this.dragging_left = i == 0;
                    this.deltay = 0;
                    this.deltax = 0;
                    this.event_start = this.event.getLocalCoordinate();
                    JMLEvent master = this.event.isMaster() ? this.event : this.event.getMaster();
                    this.event_master_start = master.getLocalCoordinate();
                    this.repaint();
                    return;
                }
            }
        }
        if (this.position_active) {
            mx = me.getX();
            my = me.getY();
            for (i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
                int dmy;
                t = i * this.getSize().width / 2;
                if (this.show_z_drag_control) {
                    this.dragging_z = JLFunc.isNearLine(mx - t, my, (int)Math.round(this.pos_points[i][4][0]), (int)Math.round(this.pos_points[i][4][1]), (int)Math.round(this.pos_points[i][6][0]), (int)Math.round(this.pos_points[i][6][1]), 4);
                    if (this.dragging_z) {
                        this.dragging = true;
                        this.dragging_left = i == 0;
                        this.deltay = 0;
                        this.deltax = 0;
                        this.position_start = this.position.getCoordinate();
                        this.repaint();
                        return;
                    }
                }
                if (this.show_xy_drag_control) {
                    this.dragging_xy = AnimationEditPanel.isInsidePolygon(mx - t, my, this.pos_points, i, face_xy);
                    if (this.dragging_xy) {
                        this.dragging = true;
                        this.dragging_left = i == 0;
                        this.deltay = 0;
                        this.deltax = 0;
                        this.position_start = this.position.getCoordinate();
                        this.repaint();
                        return;
                    }
                }
                if (!this.show_angle_drag_control) continue;
                int dmx = mx - t - (int)Math.round(this.pos_points[i][5][0]);
                boolean bl = this.dragging_angle = (double)(dmx * dmx + (dmy = my - (int)Math.round(this.pos_points[i][5][1])) * dmy) < 49.0;
                if (!this.dragging_angle) continue;
                this.dragging = true;
                this.dragging_left = i == 0;
                this.deltay = 0;
                this.deltax = 0;
                this.start_dx = new double[]{this.pos_points[i][11][0] - this.pos_points[i][4][0], this.pos_points[i][11][1] - this.pos_points[i][4][1]};
                this.start_dy = new double[]{this.pos_points[i][12][0] - this.pos_points[i][4][0], this.pos_points[i][12][1] - this.pos_points[i][4][1]};
                this.start_control = new double[]{this.pos_points[i][5][0] - this.pos_points[i][4][0], this.pos_points[i][5][1] - this.pos_points[i][4][1]};
                this.repaint();
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        EditLadderDiagram eld;
        boolean mouse_moved;
        if (this.jc.mousePause && this.lastpress == this.lastenter) {
            return;
        }
        if (this.writingGIF) {
            return;
        }
        if (!this.engineAnimating && this.engine != null && this.engine.isAlive()) {
            this.setPaused(!this.enginePaused);
            return;
        }
        boolean bl = mouse_moved = me.getX() != this.startx || me.getY() != this.starty;
        if (this.event_active && this.dragging && mouse_moved) {
            this.dragging_y = false;
            this.dragging_xz = false;
            try {
                for (AnimationPanel.AnimationAttachment att : this.attachments) {
                    if (!(att instanceof EditLadderDiagram)) continue;
                    eld = (EditLadderDiagram)att;
                    this.event = eld.reactivateEvent();
                    eld.addToUndoList();
                }
                this.getAnimator().initAnimator();
                this.activateEvent(this.event);
            }
            catch (JuggleExceptionInternal jei) {
                jei.attachPattern(this.getPattern());
                ErrorDialog.handleFatalException(jei);
            }
        }
        if (this.position_active && this.dragging && mouse_moved) {
            this.dragging_angle = false;
            this.dragging_z = false;
            this.dragging_xy = false;
            this.deltaangle = 0.0;
            for (AnimationPanel.AnimationAttachment att : this.attachments) {
                if (!(att instanceof EditLadderDiagram)) continue;
                eld = (EditLadderDiagram)att;
                eld.addToUndoList();
            }
            this.getAnimator().initAnimator();
            this.activatePosition(this.position);
        }
        if (!mouse_moved && !this.dragging && this.engine != null && this.engine.isAlive()) {
            this.setPaused(!this.enginePaused);
        }
        this.dragging_camera = false;
        this.dragging = false;
        this.dragging_y = false;
        this.dragging_xz = false;
        this.dragging_angle = false;
        this.dragging_z = false;
        this.dragging_xy = false;
        this.deltay = 0;
        this.deltax = 0;
        this.deltaangle = 0.0;
        this.event_master_start = null;
        this.event_start = null;
        this.position_start = null;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.lastenter = me.getWhen();
        if (this.jc.mousePause && !this.writingGIF) {
            this.setPaused(this.waspaused);
        }
        this.outside = false;
        this.outside_valid = true;
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this.jc.mousePause && !this.writingGIF) {
            this.waspaused = this.isPaused();
            this.setPaused(true);
        }
        this.outside = true;
        this.outside_valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.engineAnimating) {
            return;
        }
        if (this.writingGIF) {
            return;
        }
        if (this.dragging) {
            Object cc;
            int mx = me.getX();
            int my = me.getY();
            boolean dolayout = false;
            if (this.dragging_angle) {
                double final_angle;
                double[] dcontrol = new double[]{this.start_control[0] + (double)mx - (double)this.startx, this.start_control[1] + (double)my - (double)this.starty};
                double det = this.start_dx[0] * this.start_dy[1] - this.start_dx[1] * this.start_dy[0];
                double a = (this.start_dy[1] * dcontrol[0] - this.start_dy[0] * dcontrol[1]) / det;
                double b = (-this.start_dx[1] * dcontrol[0] + this.start_dx[0] * dcontrol[1]) / det;
                this.deltaangle = -Math.atan2(-a, -b);
                double new_angle = this.startangle + this.deltaangle;
                if (AnimationEditPanel.anglediff(new_angle) < SNAPANGLE / 2.0) {
                    this.deltaangle = -this.startangle;
                } else if (AnimationEditPanel.anglediff(new_angle + 1.5707963267948966) < SNAPANGLE / 2.0) {
                    this.deltaangle = -this.startangle - 1.5707963267948966;
                } else if (AnimationEditPanel.anglediff(new_angle + Math.PI) < SNAPANGLE / 2.0) {
                    this.deltaangle = -this.startangle + Math.PI;
                } else if (AnimationEditPanel.anglediff(new_angle + 4.71238898038469) < SNAPANGLE / 2.0) {
                    this.deltaangle = -this.startangle + 1.5707963267948966;
                }
                for (final_angle = Math.toDegrees(this.startangle + this.deltaangle); final_angle > 360.0; final_angle -= 360.0) {
                }
                while (final_angle < 0.0) {
                    final_angle += 360.0;
                }
                this.position.setAngle(final_angle);
                dolayout = true;
            } else {
                this.deltax = mx - this.startx;
                this.deltay = my - this.starty;
                cc = this.getCurrentCoordinate();
                if (this.event_active) {
                    Coordinate deltalc = Coordinate.sub((Coordinate)cc, this.event_start);
                    deltalc = Coordinate.truncate(deltalc, 1.0E-7);
                    this.event.setLocalCoordinate(Coordinate.add(this.event_start, deltalc));
                    if (!this.event.isMaster()) {
                        boolean flipx;
                        JMLEvent master = this.event.getMaster();
                        boolean bl = flipx = this.event.getHand() != master.getHand();
                        if (flipx) {
                            deltalc.x = -deltalc.x;
                        }
                        master.setLocalCoordinate(Coordinate.add(this.event_master_start, deltalc));
                    }
                    dolayout = true;
                }
                if (this.position_active) {
                    this.position.setCoordinate((Coordinate)cc);
                    dolayout = true;
                }
            }
            if (dolayout) {
                try {
                    cc = this.anim.pat;
                    synchronized (cc) {
                        this.anim.pat.setNeedsLayout();
                        this.anim.pat.layoutPattern();
                    }
                    if (this.event_active) {
                        this.createHandpathView();
                    }
                }
                catch (JuggleException je) {
                    ErrorDialog.handleFatalException(je);
                }
                this.repaint();
            }
        } else if (!this.dragging_camera) {
            this.dragging_camera = true;
            this.lastx = this.startx;
            this.lasty = this.starty;
            this.dragcamangle = this.anim.getCameraAngle();
        }
        if (this.dragging_camera) {
            int dx = me.getX() - this.lastx;
            int dy = me.getY() - this.lasty;
            this.lastx = me.getX();
            this.lasty = me.getY();
            double[] ca = this.dragcamangle;
            ca[0] = ca[0] + (double)dx * 0.02;
            ca[1] = ca[1] - (double)dy * 0.02;
            if (ca[1] < Math.toRadians(1.0E-4)) {
                ca[1] = Math.toRadians(1.0E-4);
            }
            if (ca[1] > Math.toRadians(179.9999)) {
                ca[1] = Math.toRadians(179.9999);
            }
            while (ca[0] < 0.0) {
                ca[0] = ca[0] + Math.toRadians(360.0);
            }
            while (ca[0] >= Math.toRadians(360.0)) {
                ca[0] = ca[0] - Math.toRadians(360.0);
            }
            this.anim.setCameraAngle(this.snapCamera(ca));
        }
        if (this.event_active && this.dragging_camera) {
            try {
                this.createEventView();
            }
            catch (JuggleExceptionInternal jei) {
                jei.attachPattern(this.getPattern());
                ErrorDialog.handleFatalException(jei);
            }
        }
        if (this.position_active && (this.dragging_camera || this.dragging_angle)) {
            this.createPositionView();
        }
        if (this.isPaused()) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    protected void initHandlers() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(new ComponentAdapter(this){
            boolean hasResized;
            final /* synthetic */ AnimationEditPanel this$0;
            {
                AnimationEditPanel animationEditPanel = this$0;
                Objects.requireNonNull(animationEditPanel);
                this.this$0 = animationEditPanel;
                this.hasResized = false;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Component comp;
                if (!this.this$0.engineAnimating) {
                    return;
                }
                if (this.this$0.writingGIF) {
                    return;
                }
                this.this$0.anim.setDimension(this.this$0.getSize());
                if (this.this$0.event_active) {
                    try {
                        this.this$0.createEventView();
                    }
                    catch (JuggleExceptionInternal jei) {
                        jei.attachPattern(this.this$0.getPattern());
                        ErrorDialog.handleFatalException(jei);
                    }
                }
                if (this.this$0.position_active) {
                    this.this$0.createPositionView();
                }
                if (this.this$0.isPaused()) {
                    this.this$0.repaint();
                }
                if ((comp = SwingUtilities.getRoot(this.this$0)) instanceof PatternWindow && ((PatternWindow)comp).isWindowMaximized()) {
                    return;
                }
                if (this.hasResized) {
                    this.this$0.jc.setSize(this.this$0.getSize());
                }
                this.hasResized = true;
            }
        });
    }

    @Override
    protected double[] snapCamera(double[] ca) {
        double[] result = new double[]{ca[0], ca[1]};
        if (result[1] < SNAPANGLE) {
            result[1] = Math.toRadians(1.0E-4);
        } else if (AnimationEditPanel.anglediff(Math.toRadians(90.0) - result[1]) < SNAPANGLE) {
            result[1] = Math.toRadians(90.0);
        } else if (result[1] > Math.toRadians(180.0) - SNAPANGLE) {
            result[1] = Math.toRadians(179.9999);
        }
        double a = 0.0;
        boolean snap_horizontal = true;
        if (this.event_active) {
            a = -Math.toRadians(this.anim.pat.getJugglerAngle(this.event.getJuggler(), this.event.getT()));
        } else if (this.position_active) {
            a = 0.0;
        } else if (this.anim.pat.getNumberOfJugglers() == 1) {
            a = -Math.toRadians(this.anim.pat.getJugglerAngle(1, this.getTime()));
        } else {
            snap_horizontal = false;
        }
        if (snap_horizontal) {
            while (a < 0.0) {
                a += Math.toRadians(360.0);
            }
            while (a >= Math.toRadians(360.0)) {
                a -= Math.toRadians(360.0);
            }
            if (AnimationEditPanel.anglediff(a - result[0]) < SNAPANGLE) {
                result[0] = a;
            } else if (AnimationEditPanel.anglediff(a + 1.5707963267948966 - result[0]) < SNAPANGLE) {
                result[0] = a + 1.5707963267948966;
            } else if (AnimationEditPanel.anglediff(a + Math.PI - result[0]) < SNAPANGLE) {
                result[0] = a + Math.PI;
            } else if (AnimationEditPanel.anglediff(a + 4.71238898038469 - result[0]) < SNAPANGLE) {
                result[0] = a + 4.71238898038469;
            }
        }
        return result;
    }

    @Override
    public void restartJuggle(JMLPattern pat, AnimationPrefs newjc) throws JuggleExceptionUser, JuggleExceptionInternal {
        super.restartJuggle(pat, newjc);
        if (this.event_active) {
            this.createEventView();
        }
        if (this.position_active) {
            this.createPositionView();
        }
    }

    @Override
    public void setZoomLevel(double z) {
        if (!this.writingGIF) {
            this.getAnimator().setZoomLevel(z);
            try {
                this.createEventView();
            }
            catch (JuggleExceptionInternal jei) {
                jei.attachPattern(this.getPattern());
                ErrorDialog.handleFatalException(jei);
            }
            this.createPositionView();
            this.repaint();
        }
    }

    public void activateEvent(JMLEvent ev) throws JuggleExceptionInternal {
        this.deactivatePosition();
        this.event = ev;
        this.event_active = true;
        this.createEventView();
    }

    public void deactivateEvent() {
        this.event = null;
        this.event_active = false;
        this.dragging_y = false;
        this.dragging_xz = false;
        this.event_points = null;
        this.visible_events = null;
        this.handpath_points = null;
    }

    protected void createEventView() throws JuggleExceptionInternal {
        boolean new_master;
        JMLEvent ev2;
        if (!this.event_active) {
            return;
        }
        this.visible_events = new ArrayList();
        this.visible_events.add(this.event);
        this.handpath_start_time = this.event.getT();
        this.handpath_end_time = this.event.getT();
        for (ev2 = this.event.getPrevious(); ev2 != null; ev2 = ev2.getPrevious()) {
            if (ev2.getJuggler() != this.event.getJuggler() || ev2.getHand() != this.event.getHand()) continue;
            this.handpath_start_time = Math.min(this.handpath_start_time, ev2.getT());
            new_master = true;
            for (JMLEvent ev3 : this.visible_events) {
                if (!ev3.hasSameMasterAs(ev2)) continue;
                new_master = false;
            }
            if (!new_master) break;
            this.visible_events.add(ev2);
            if (ev2.hasThrowOrCatch()) break;
        }
        for (ev2 = this.event.getNext(); ev2 != null; ev2 = ev2.getNext()) {
            if (ev2.getJuggler() != this.event.getJuggler() || ev2.getHand() != this.event.getHand()) continue;
            this.handpath_end_time = Math.max(this.handpath_end_time, ev2.getT());
            new_master = true;
            for (JMLEvent ev3 : this.visible_events) {
                if (!ev3.hasSameMasterAs(ev2)) continue;
                new_master = false;
            }
            if (!new_master) break;
            this.visible_events.add(ev2);
            if (ev2.hasThrowOrCatch()) break;
        }
        int renderer_count = this.jc.stereo ? 2 : 1;
        this.event_points = new double[this.visible_events.size()][renderer_count][event_control_points.length][2];
        int ev_num = 0;
        for (JMLEvent ev : this.visible_events) {
            for (int i = 0; i < renderer_count; ++i) {
                int j;
                Renderer ren = i == 0 ? this.anim.ren1 : this.anim.ren2;
                Coordinate c = ev.getGlobalCoordinate();
                if (c == null) {
                    throw new JuggleExceptionInternal("AEP: No coord on event " + ev.toString(), this.getPattern());
                }
                Coordinate c2 = ren.getScreenTranslatedCoordinate(c, 1, 0);
                double dl = 1.0 / Coordinate.distance(c, c2);
                double[] ca = ren.getCameraAngle();
                double theta = ca[0] + Math.toRadians(this.getPattern().getJugglerAngle(ev.getJuggler(), ev.getT()));
                double phi = ca[1];
                double dlc = dl * Math.cos(phi);
                double dls = dl * Math.sin(phi);
                double dxx = -dl * Math.cos(theta);
                double dxy = dlc * Math.sin(theta);
                double dyx = dl * Math.sin(theta);
                double dyy = dlc * Math.cos(theta);
                double dzx = 0.0;
                double dzy = -dls;
                int[] center = ren.getXY(c);
                if (ev == this.event) {
                    for (j = 0; j < event_control_points.length; ++j) {
                        this.event_points[0][i][j][0] = (double)center[0] + dxx * event_control_points[j][0] + dyx * event_control_points[j][1] + dzx * event_control_points[j][2];
                        this.event_points[0][i][j][1] = (double)center[1] + dxy * event_control_points[j][0] + dyy * event_control_points[j][1] + dzy * event_control_points[j][2];
                    }
                    this.show_xz_drag_control = AnimationEditPanel.anglediff(phi - 1.5707963267948966) < Math.toRadians(60.0) && (AnimationEditPanel.anglediff(theta) < Math.toRadians(60.0) || AnimationEditPanel.anglediff(theta - Math.PI) < Math.toRadians(60.0));
                    this.show_y_drag_control = !(AnimationEditPanel.anglediff(phi - 1.5707963267948966) < Math.toRadians(30.0)) || !(AnimationEditPanel.anglediff(theta) < Math.toRadians(30.0)) && !(AnimationEditPanel.anglediff(theta - Math.PI) < Math.toRadians(30.0));
                    continue;
                }
                for (j = 0; j < unselected_event_points.length; ++j) {
                    this.event_points[ev_num][i][j][0] = (double)center[0] + dxx * unselected_event_points[j][0] + dyx * unselected_event_points[j][1] + dzx * unselected_event_points[j][2];
                    this.event_points[ev_num][i][j][1] = (double)center[1] + dxy * unselected_event_points[j][0] + dyy * unselected_event_points[j][1] + dzy * unselected_event_points[j][2];
                }
            }
            ++ev_num;
        }
        this.createHandpathView();
    }

    protected void createHandpathView() throws JuggleExceptionInternal {
        if (!this.event_active) {
            return;
        }
        JMLPattern pat = this.getPattern();
        int renderer_count = this.jc.stereo ? 2 : 1;
        int num_handpath_points = (int)Math.ceil((this.handpath_end_time - this.handpath_start_time) / 0.01) + 1;
        this.handpath_points = new double[renderer_count][num_handpath_points][2];
        this.handpath_hold = new boolean[num_handpath_points];
        for (int i = 0; i < renderer_count; ++i) {
            Renderer ren = i == 0 ? this.anim.ren1 : this.anim.ren2;
            Coordinate c = new Coordinate();
            for (int j = 0; j < num_handpath_points; ++j) {
                double t = this.handpath_start_time + (double)j * 0.01;
                pat.getHandCoordinate(this.event.getJuggler(), this.event.getHand(), t, c);
                int[] point = ren.getXY(c);
                this.handpath_points[i][j][0] = point[0];
                this.handpath_points[i][j][1] = point[1];
                this.handpath_hold[j] = pat.isHandHolding(this.event.getJuggler(), this.event.getHand(), t + 1.0E-4);
            }
        }
    }

    protected void drawEvents(Graphics g) throws JuggleExceptionInternal {
        if (!this.event_active) {
            return;
        }
        Dimension d = this.getSize();
        Graphics g2 = g;
        for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
            int j;
            if (this.jc.stereo && i == 0) {
                g2 = g.create(0, 0, d.width / 2, d.height);
            } else if (this.jc.stereo && i == 1) {
                g2 = g.create(d.width / 2, 0, d.width / 2, d.height);
            }
            if (g2 instanceof Graphics2D) {
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int num_handpath_points = this.handpath_points[0].length;
            Path2D.Double path_solid = new Path2D.Double();
            Path2D.Double path_dashed = new Path2D.Double();
            for (j = 0; j < num_handpath_points - 1; ++j) {
                Path2D.Double path;
                Path2D.Double double_ = path = this.handpath_hold[j] ? path_solid : path_dashed;
                if (path.getCurrentPoint() == null) {
                    path.moveTo(this.handpath_points[i][j][0], this.handpath_points[i][j][1]);
                    path.lineTo(this.handpath_points[i][j + 1][0], this.handpath_points[i][j + 1][1]);
                    continue;
                }
                path.lineTo(this.handpath_points[i][j + 1][0], this.handpath_points[i][j + 1][1]);
            }
            if (path_dashed.getCurrentPoint() != null) {
                Graphics2D gdash = (Graphics2D)g2.create();
                BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{5.0f, 3.0f}, 0.0f);
                gdash.setStroke(dashed);
                gdash.setColor(COLOR_HANDPATH);
                gdash.draw(path_dashed);
                gdash.dispose();
            }
            if (path_solid.getCurrentPoint() != null) {
                Graphics2D gsolid = (Graphics2D)g2.create();
                gsolid.setColor(COLOR_HANDPATH);
                gsolid.draw(path_solid);
                gsolid.dispose();
            }
            g2.setColor(COLOR_EVENTS);
            g2.fillOval((int)Math.round(this.event_points[0][i][4][0]) + this.deltax - 2, (int)Math.round(this.event_points[0][i][4][1]) + this.deltay - 2, 5, 5);
            if (this.show_xz_drag_control || this.dragging) {
                this.drawLine(g2, this.event_points[0], i, 0, 1, true);
                this.drawLine(g2, this.event_points[0], i, 1, 2, true);
                this.drawLine(g2, this.event_points[0], i, 2, 3, true);
                this.drawLine(g2, this.event_points[0], i, 3, 0, true);
                for (j = 1; j < this.event_points.length; ++j) {
                    this.drawLine(g2, this.event_points[j], i, 0, 1, false);
                    this.drawLine(g2, this.event_points[j], i, 1, 2, false);
                    this.drawLine(g2, this.event_points[j], i, 2, 3, false);
                    this.drawLine(g2, this.event_points[j], i, 3, 0, false);
                    g2.fillOval((int)Math.round(this.event_points[j][i][4][0]) - 1, (int)Math.round(this.event_points[j][i][4][1]) - 1, 3, 3);
                }
            }
            if (!this.show_y_drag_control || this.dragging && !this.dragging_y) continue;
            this.drawLine(g2, this.event_points[0], i, 5, 6, true);
            this.drawLine(g2, this.event_points[0], i, 5, 7, true);
            this.drawLine(g2, this.event_points[0], i, 5, 8, true);
            this.drawLine(g2, this.event_points[0], i, 6, 9, true);
            this.drawLine(g2, this.event_points[0], i, 6, 10, true);
        }
    }

    public void activatePosition(JMLPosition pos) {
        this.deactivateEvent();
        this.position = pos;
        this.position_active = true;
        this.startangle = Math.toRadians(this.position.getAngle());
        this.createPositionView();
    }

    public void deactivatePosition() {
        this.position = null;
        this.position_active = false;
        this.dragging_angle = false;
        this.dragging_z = false;
        this.dragging_xy = false;
    }

    protected void createPositionView() {
        if (!this.position_active) {
            return;
        }
        this.pos_points = new double[2][pos_control_points.length][2];
        for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
            Renderer ren = i == 0 ? this.anim.ren1 : this.anim.ren2;
            Coordinate c = Coordinate.add(this.position.getCoordinate(), new Coordinate(0.0, 0.0, 0.0));
            Coordinate c2 = ren.getScreenTranslatedCoordinate(c, 1, 0);
            double dl = 1.0 / Coordinate.distance(c, c2);
            double[] ca = ren.getCameraAngle();
            double theta = ca[0] + this.startangle + this.deltaangle;
            double phi = ca[1];
            double dlc = dl * Math.cos(phi);
            double dls = dl * Math.sin(phi);
            double dxx = -dl * Math.cos(theta);
            double dxy = dlc * Math.sin(theta);
            double dyx = dl * Math.sin(theta);
            double dyy = dlc * Math.cos(theta);
            double dzx = 0.0;
            double dzy = -dls;
            int[] center = ren.getXY(c);
            for (int j = 0; j < pos_control_points.length; ++j) {
                this.pos_points[i][j][0] = (double)center[0] + dxx * pos_control_points[j][0] + dyx * pos_control_points[j][1] + dzx * pos_control_points[j][2];
                this.pos_points[i][j][1] = (double)center[1] + dxy * pos_control_points[j][0] + dyy * pos_control_points[j][1] + dzy * pos_control_points[j][2];
            }
            this.show_angle_drag_control = AnimationEditPanel.anglediff(phi - 1.5707963267948966) > Math.toRadians(20.0);
            this.show_xy_drag_control = AnimationEditPanel.anglediff(phi - 1.5707963267948966) > Math.toRadians(20.0);
            this.show_z_drag_control = AnimationEditPanel.anglediff(phi - 1.5707963267948966) < Math.toRadians(60.0);
        }
    }

    protected void drawPositions(Graphics g) throws JuggleExceptionInternal {
        if (!this.position_active) {
            return;
        }
        Dimension d = this.getSize();
        Graphics g2 = g;
        for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
            Renderer ren;
            Renderer renderer = ren = i == 0 ? this.anim.ren1 : this.anim.ren2;
            if (this.jc.stereo && i == 0) {
                g2 = g.create(0, 0, d.width / 2, d.height);
            } else if (this.jc.stereo && i == 1) {
                g2 = g.create(d.width / 2, 0, d.width / 2, d.height);
            }
            if (g2 instanceof Graphics2D) {
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2.setColor(COLOR_POSITIONS);
            g2.fillOval((int)Math.round(this.pos_points[i][4][0]) + this.deltax - 2, (int)Math.round(this.pos_points[i][4][1]) + this.deltay - 2, 5, 5);
            if (this.show_xy_drag_control || this.dragging) {
                this.drawLine(g2, this.pos_points, i, 0, 1, true);
                this.drawLine(g2, this.pos_points, i, 1, 2, true);
                this.drawLine(g2, this.pos_points, i, 2, 3, true);
                this.drawLine(g2, this.pos_points, i, 3, 0, true);
            }
            if (this.show_z_drag_control && (!this.dragging || this.dragging_z)) {
                this.drawLine(g2, this.pos_points, i, 4, 6, true);
                this.drawLine(g2, this.pos_points, i, 6, 7, true);
                this.drawLine(g2, this.pos_points, i, 6, 8, true);
            }
            if (this.show_angle_drag_control && (!this.dragging || this.dragging_angle)) {
                this.drawLine(g2, this.pos_points, i, 4, 5, true);
                g2.fillOval((int)Math.round(this.pos_points[i][5][0]) - 4 + this.deltax, (int)Math.round(this.pos_points[i][5][1]) - 4 + this.deltay, 10, 10);
            }
            if (this.dragging_angle) {
                this.drawLine(g2, this.pos_points, i, 9, 10, true);
            }
            if (this.dragging_angle || !this.dragging_z && !(this.getCameraAngle()[1] <= Math.toRadians(70.0))) continue;
            Coordinate c = this.getCurrentCoordinate();
            double z = c.z;
            c.z = 0.0;
            int[] xy_projection = ren.getXY(c);
            g2.drawLine(xy_projection[0], xy_projection[1], (int)Math.round(this.pos_points[i][4][0]) + this.deltax, (int)Math.round(this.pos_points[i][4][1]) + this.deltay);
            g2.fillOval(xy_projection[0] - 2, xy_projection[1] - 2, 5, 5);
            if (!this.dragging_z) continue;
            double y = Math.max(Math.max(this.pos_points[i][0][1], this.pos_points[i][1][1]), Math.max(this.pos_points[i][2][1], this.pos_points[i][3][1]));
            int message_y = (int)Math.round(y) + this.deltay + 40;
            g2.setColor(Color.black);
            g2.drawString("z = " + JLFunc.toStringRounded(z, 1) + " cm", xy_projection[0] + 5, message_y);
        }
    }

    protected void drawGrid(Graphics g) {
        if (!this.position_active) {
            return;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (this.getCameraAngle()[1] > Math.toRadians(70.0)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(COLOR_GRID);
        Dimension d = this.getSize();
        int width = this.jc.stereo ? d.width / 2 : d.width;
        for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
            int y2;
            int y1;
            int j;
            Renderer ren;
            Renderer renderer = ren = i == 0 ? this.anim.ren1 : this.anim.ren2;
            if (this.jc.stereo && i == 0) {
                g2 = (Graphics2D)g.create(0, 0, d.width / 2, d.height);
            } else if (this.jc.stereo && i == 1) {
                g2 = (Graphics2D)g.create(d.width / 2, 0, d.width / 2, d.height);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int[] center = ren.getXY(new Coordinate(0.0, 0.0, 0.0));
            int[] dx = ren.getXY(new Coordinate(100.0, 0.0, 0.0));
            int[] dy = ren.getXY(new Coordinate(0.0, 100.0, 0.0));
            double[] xaxis_spacing = new double[]{20.0 * ((double)(dx[0] - center[0]) / 100.0), 20.0 * ((double)(dx[1] - center[1]) / 100.0)};
            double[] yaxis_spacing = new double[]{20.0 * ((double)(dy[0] - center[0]) / 100.0), 20.0 * ((double)(dy[1] - center[1]) / 100.0)};
            double[] axis1 = xaxis_spacing;
            double[] axis2 = yaxis_spacing;
            double det = axis1[0] * axis2[1] - axis1[1] * axis2[0];
            int mmin = 0;
            int mmax = 0;
            int nmin = 0;
            int nmax = 0;
            for (j = 0; j < 4; ++j) {
                double a = (j % 2 == 0 ? 0 : width) - center[0];
                double b = (j < 2 ? 0 : d.height) - center[1];
                double m = (axis2[1] * a - axis2[0] * b) / det;
                double n = (-axis1[1] * a + axis1[0] * b) / det;
                int mint = (int)Math.floor(m);
                int nint = (int)Math.floor(n);
                mmin = j == 0 ? mint : Math.min(mmin, mint);
                mmax = j == 0 ? mint + 1 : Math.max(mmax, mint + 1);
                nmin = j == 0 ? nint : Math.min(nmin, nint);
                nmax = j == 0 ? nint + 1 : Math.max(nmax, nint + 1);
            }
            for (j = mmin; j <= mmax; ++j) {
                int x1 = (int)Math.round((double)center[0] + (double)j * axis1[0] + (double)nmin * axis2[0]);
                y1 = (int)Math.round((double)center[1] + (double)j * axis1[1] + (double)nmin * axis2[1]);
                int x2 = (int)Math.round((double)center[0] + (double)j * axis1[0] + (double)nmax * axis2[0]);
                y2 = (int)Math.round((double)center[1] + (double)j * axis1[1] + (double)nmax * axis2[1]);
                if (j == 0) {
                    g2.setStroke(new BasicStroke(3.0f));
                }
                g2.drawLine(x1, y1, x2, y2);
                if (j != 0) continue;
                g2.setStroke(new BasicStroke(1.0f));
            }
            for (j = nmin; j <= nmax; ++j) {
                int x1 = (int)Math.round((double)center[0] + (double)mmin * axis1[0] + (double)j * axis2[0]);
                y1 = (int)Math.round((double)center[1] + (double)mmin * axis1[1] + (double)j * axis2[1]);
                int x2 = (int)Math.round((double)center[0] + (double)mmax * axis1[0] + (double)j * axis2[0]);
                y2 = (int)Math.round((double)center[1] + (double)mmax * axis1[1] + (double)j * axis2[1]);
                if (j == 0) {
                    g2.setStroke(new BasicStroke(3.0f));
                }
                g2.drawLine(x1, y1, x2, y2);
                if (j != 0) continue;
                g2.setStroke(new BasicStroke(1.0f));
            }
        }
    }

    protected Coordinate getCurrentCoordinate() {
        if (this.event_active) {
            double a;
            if (!this.dragging) {
                return this.event.getLocalCoordinate();
            }
            Coordinate c = new Coordinate(this.event_start);
            double[] dx = new double[]{0.0, 0.0};
            double[] dy = new double[]{0.0, 0.0};
            double[] dz = new double[]{0.0, 0.0};
            double f = this.jc.stereo ? 0.5 : 1.0;
            for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
                dx[0] = dx[0] + f * (this.event_points[0][i][11][0] - this.event_points[0][i][4][0]);
                dx[1] = dx[1] + f * (this.event_points[0][i][11][1] - this.event_points[0][i][4][1]);
                dy[0] = dy[0] + f * (this.event_points[0][i][12][0] - this.event_points[0][i][4][0]);
                dy[1] = dy[1] + f * (this.event_points[0][i][12][1] - this.event_points[0][i][4][1]);
                dz[0] = dz[0] + f * (this.event_points[0][i][13][0] - this.event_points[0][i][4][0]);
                dz[1] = dz[1] + f * (this.event_points[0][i][13][1] - this.event_points[0][i][4][1]);
            }
            if (this.dragging_xz) {
                double det = dx[0] * dz[1] - dx[1] * dz[0];
                a = (dz[1] * (double)this.deltax - dz[0] * (double)this.deltay) / det;
                double b = (-dx[1] * (double)this.deltax + dx[0] * (double)this.deltay) / det;
                c.x += a;
                c.z += b;
                if (Math.abs(c.z) < 3.0) {
                    this.deltay += (int)Math.round(dz[1] * -c.z);
                    c.z = 0.0;
                }
            }
            if (this.dragging_y) {
                double det = dy[0] * dz[1] - dy[1] * dz[0];
                a = (dz[1] * (double)this.deltax - dz[0] * (double)this.deltay) / det;
                c.y += a;
                if (Math.abs(c.y) < 3.0) {
                    c.y = 0.0;
                }
                this.deltax = (int)Math.round((c.y - this.event_start.y) * dy[0]);
                this.deltay = (int)Math.round((c.y - this.event_start.y) * dy[1]);
            }
            return c;
        }
        if (this.position_active) {
            if (!this.dragging_xy && !this.dragging_z) {
                return this.position.getCoordinate();
            }
            Coordinate c = new Coordinate(this.position_start);
            double[] dx = new double[]{0.0, 0.0};
            double[] dy = new double[]{0.0, 0.0};
            double[] dz = new double[]{0.0, 0.0};
            double f = this.jc.stereo ? 0.5 : 1.0;
            for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
                dx[0] = dx[0] + f * (this.pos_points[i][11][0] - this.pos_points[i][4][0]);
                dx[1] = dx[1] + f * (this.pos_points[i][11][1] - this.pos_points[i][4][1]);
                dy[0] = dy[0] + f * (this.pos_points[i][12][0] - this.pos_points[i][4][0]);
                dy[1] = dy[1] + f * (this.pos_points[i][12][1] - this.pos_points[i][4][1]);
                dz[0] = dz[0] + f * (this.pos_points[i][13][0] - this.pos_points[i][4][0]);
                dz[1] = dz[1] + f * (this.pos_points[i][13][1] - this.pos_points[i][4][1]);
            }
            if (this.dragging_xy) {
                double det = dx[0] * dy[1] - dx[1] * dy[0];
                double a = (dy[1] * (double)this.deltax - dy[0] * (double)this.deltay) / det;
                double b = (-dx[1] * (double)this.deltax + dx[0] * (double)this.deltay) / det;
                double angle = Math.toRadians(this.position.getAngle());
                c.x += a * Math.cos(angle) - b * Math.sin(angle);
                c.y += a * Math.sin(angle) + b * Math.cos(angle);
                boolean snapped = false;
                double oldcx = c.x;
                double oldcy = c.y;
                double closest_grid = 20.0 * (double)Math.round(c.x / 20.0);
                if (Math.abs(c.x - closest_grid) < 3.0) {
                    c.x = closest_grid;
                    snapped = true;
                }
                if (Math.abs(c.y - (closest_grid = 20.0 * (double)Math.round(c.y / 20.0))) < 3.0) {
                    c.y = closest_grid;
                    snapped = true;
                }
                if (snapped) {
                    double deltacx = c.x - oldcx;
                    double deltacy = c.y - oldcy;
                    double deltaa = deltacx * Math.cos(angle) + deltacy * Math.sin(angle);
                    double deltab = -deltacx * Math.sin(angle) + deltacy * Math.cos(angle);
                    double delta_x_px = dx[0] * deltaa + dy[0] * deltab;
                    double delta_y_px = dx[1] * deltaa + dy[1] * deltab;
                    this.deltax += (int)Math.round(delta_x_px);
                    this.deltay += (int)Math.round(delta_y_px);
                }
            }
            if (this.dragging_z) {
                this.deltax = 0;
                c.z += (double)this.deltay / dz[1];
                if (Math.abs(c.z - 100.0) < 3.0) {
                    this.deltay += (int)Math.round(dz[1] * (100.0 - c.z));
                    c.z = 100.0;
                }
            }
            return c;
        }
        return null;
    }

    protected void drawLine(Graphics g, double[][][] array, int index, int p1, int p2, boolean mouse) {
        if (mouse) {
            g.drawLine((int)Math.round(array[index][p1][0]) + this.deltax, (int)Math.round(array[index][p1][1]) + this.deltay, (int)Math.round(array[index][p2][0]) + this.deltax, (int)Math.round(array[index][p2][1]) + this.deltay);
        } else {
            g.drawLine((int)Math.round(array[index][p1][0]), (int)Math.round(array[index][p1][1]), (int)Math.round(array[index][p2][0]), (int)Math.round(array[index][p2][1]));
        }
    }

    protected static boolean isInsidePolygon(int x, int y, double[][][] array, int index, int[] points) {
        boolean inside = false;
        int i = 0;
        int j = points.length - 1;
        while (i < points.length) {
            boolean intersect;
            int xi = (int)Math.round(array[index][points[i]][0]);
            int yi = (int)Math.round(array[index][points[i]][1]);
            int xj = (int)Math.round(array[index][points[j]][0]);
            int yj = (int)Math.round(array[index][points[j]][1]);
            boolean bl = intersect = yi > y != yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
            if (intersect) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.message != null) {
            this.drawString(this.message, g);
        } else if (this.engineRunning && !this.writingGIF) {
            try {
                this.anim.drawBackground(g);
                this.drawGrid(g);
                this.anim.drawFrame(this.getTime(), g, this.dragging_camera, false);
                this.drawEvents(g);
                this.drawPositions(g);
            }
            catch (JuggleExceptionInternal jei) {
                this.killAnimationThread();
                jei.attachPattern(this.getPattern());
                ErrorDialog.handleFatalException(jei);
            }
        }
    }
}

