/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class AnimationPanel
extends JPanel
implements Runnable {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static final double SNAPANGLE = Math.toRadians(8.0);
    protected Animator anim = new Animator();
    protected AnimationPrefs jc = new AnimationPrefs();
    protected Thread engine;
    protected boolean engineRunning;
    protected boolean enginePaused;
    protected boolean engineAnimating;
    protected double sim_time;
    public boolean writingGIF;
    public String message;
    protected Clip catchclip;
    protected Clip bounceclip;
    protected boolean waspaused;
    protected boolean outside;
    protected boolean outside_valid;
    protected boolean dragging_camera;
    protected int startx;
    protected int starty;
    protected int lastx;
    protected int lasty;
    protected double[] dragcamangle;
    protected ArrayList<AnimationAttachment> attachments = new ArrayList();

    public AnimationPanel() {
        this.setOpaque(true);
        this.loadAudioClips();
        this.initHandlers();
    }

    protected void loadAudioClips() {
        DataLine.Info info;
        try {
            URL catchurl = AnimationPanel.class.getResource("/catch.au");
            AudioInputStream catchAudioIn = AudioSystem.getAudioInputStream(catchurl);
            info = new DataLine.Info(Clip.class, catchAudioIn.getFormat());
            this.catchclip = (Clip)AudioSystem.getLine(info);
            this.catchclip.open(catchAudioIn);
        }
        catch (Exception e) {
            this.catchclip = null;
        }
        try {
            URL bounceurl = AnimationPanel.class.getResource("/bounce.au");
            AudioInputStream bounceAudioIn = AudioSystem.getAudioInputStream(bounceurl);
            info = new DataLine.Info(Clip.class, bounceAudioIn.getFormat());
            this.bounceclip = (Clip)AudioSystem.getLine(info);
            this.bounceclip.open(bounceAudioIn);
        }
        catch (Exception e) {
            this.bounceclip = null;
        }
    }

    protected void initHandlers() {
        this.addMouseListener(new MouseAdapter(this){
            long lastpress;
            long lastenter;
            final /* synthetic */ AnimationPanel this$0;
            {
                AnimationPanel animationPanel = this$0;
                Objects.requireNonNull(animationPanel);
                this.this$0 = animationPanel;
                this.lastpress = 0L;
                this.lastenter = 1L;
            }

            @Override
            public void mousePressed(MouseEvent me) {
                this.lastpress = me.getWhen();
                if (this.this$0.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (!this.this$0.engineAnimating) {
                    return;
                }
                if (this.this$0.writingGIF) {
                    return;
                }
                this.this$0.startx = me.getX();
                this.this$0.starty = me.getY();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (this.this$0.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (this.this$0.writingGIF) {
                    return;
                }
                this.this$0.dragging_camera = false;
                if (!this.this$0.engineAnimating && this.this$0.engine != null && this.this$0.engine.isAlive()) {
                    this.this$0.setPaused(!this.this$0.enginePaused);
                    return;
                }
                if (me.getX() == this.this$0.startx && me.getY() == this.this$0.starty && this.this$0.engine != null && this.this$0.engine.isAlive()) {
                    this.this$0.setPaused(!this.this$0.enginePaused);
                    this.this$0.getParent().dispatchEvent(me);
                }
                if (this.this$0.isPaused()) {
                    this.this$0.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                this.lastenter = me.getWhen();
                if (this.this$0.jc.mousePause && !this.this$0.writingGIF) {
                    this.this$0.setPaused(this.this$0.waspaused);
                }
                this.this$0.outside = false;
                this.this$0.outside_valid = true;
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (this.this$0.jc.mousePause && !this.this$0.writingGIF) {
                    this.this$0.waspaused = this.this$0.isPaused();
                    this.this$0.setPaused(true);
                }
                this.this$0.outside = true;
                this.this$0.outside_valid = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ AnimationPanel this$0;
            {
                AnimationPanel animationPanel = this$0;
                Objects.requireNonNull(animationPanel);
                this.this$0 = animationPanel;
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                if (!this.this$0.engineAnimating) {
                    return;
                }
                if (this.this$0.writingGIF) {
                    return;
                }
                if (!this.this$0.dragging_camera) {
                    this.this$0.dragging_camera = true;
                    this.this$0.lastx = this.this$0.startx;
                    this.this$0.lasty = this.this$0.starty;
                    this.this$0.dragcamangle = this.this$0.getCameraAngle();
                }
                int xdelta = me.getX() - this.this$0.lastx;
                int ydelta = me.getY() - this.this$0.lasty;
                this.this$0.lastx = me.getX();
                this.this$0.lasty = me.getY();
                double[] ca = this.this$0.dragcamangle;
                ca[0] = ca[0] + (double)xdelta * 0.02;
                ca[1] = ca[1] - (double)ydelta * 0.02;
                if (ca[1] < Math.toRadians(1.0E-4)) {
                    ca[1] = Math.toRadians(1.0E-4);
                }
                if (ca[1] > Math.toRadians(179.9999)) {
                    ca[1] = Math.toRadians(179.9999);
                }
                while (ca[0] < 0.0) {
                    ca[0] = ca[0] + Math.toRadians(360.0);
                }
                while (ca[0] >= Math.toRadians(360.0)) {
                    ca[0] = ca[0] - Math.toRadians(360.0);
                }
                double[] snappedcamangle = this.this$0.snapCamera(ca);
                this.this$0.setCameraAngle(snappedcamangle);
                this.this$0.getParent().dispatchEvent(me);
                if (this.this$0.isPaused()) {
                    this.this$0.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            boolean hasResized;
            final /* synthetic */ AnimationPanel this$0;
            {
                AnimationPanel animationPanel = this$0;
                Objects.requireNonNull(animationPanel);
                this.this$0 = animationPanel;
                this.hasResized = false;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (!this.this$0.engineAnimating) {
                    return;
                }
                if (this.this$0.writingGIF) {
                    return;
                }
                this.this$0.anim.setDimension(this.this$0.getSize());
                this.this$0.repaint();
                Component comp = SwingUtilities.getRoot(this.this$0);
                if (comp instanceof PatternWindow && ((PatternWindow)comp).isWindowMaximized()) {
                    return;
                }
                if (this.hasResized) {
                    this.this$0.jc.setSize(this.this$0.getSize());
                }
                this.hasResized = true;
            }
        });
    }

    public void removeAllAttachments() {
        this.attachments.clear();
    }

    public void addAnimationAttachment(AnimationAttachment att) {
        this.attachments.add(att);
    }

    protected double[] snapCamera(double[] ca) {
        double[] result = new double[]{ca[0], ca[1]};
        if (result[1] < SNAPANGLE) {
            result[1] = Math.toRadians(1.0E-4);
        } else if (AnimationPanel.anglediff(Math.toRadians(90.0) - result[1]) < SNAPANGLE) {
            result[1] = Math.toRadians(90.0);
        } else if (result[1] > Math.toRadians(180.0) - SNAPANGLE) {
            result[1] = Math.toRadians(179.9999);
        }
        if (this.anim.pat.getNumberOfJugglers() == 1) {
            double a;
            for (a = -Math.toRadians(this.anim.pat.getJugglerAngle(1, this.getTime())); a < 0.0; a += Math.toRadians(360.0)) {
            }
            while (a >= Math.toRadians(360.0)) {
                a -= Math.toRadians(360.0);
            }
            if (AnimationPanel.anglediff(a - result[0]) < SNAPANGLE) {
                result[0] = a;
            } else if (AnimationPanel.anglediff(a + 1.5707963267948966 - result[0]) < SNAPANGLE) {
                result[0] = a + 1.5707963267948966;
            } else if (AnimationPanel.anglediff(a + Math.PI - result[0]) < SNAPANGLE) {
                result[0] = a + Math.PI;
            } else if (AnimationPanel.anglediff(a + 4.71238898038469 - result[0]) < SNAPANGLE) {
                result[0] = a + 4.71238898038469;
            }
        }
        return result;
    }

    protected static double anglediff(double delta) {
        while (delta > Math.PI) {
            delta -= Math.PI * 2;
        }
        while (delta <= -Math.PI) {
            delta += Math.PI * 2;
        }
        return Math.abs(delta);
    }

    public void restartJuggle(JMLPattern pat, AnimationPrefs newjc) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (pat != null) {
            pat.layoutPattern();
        }
        this.killAnimationThread();
        if (newjc != null) {
            this.jc = newjc;
        }
        this.anim.setDimension(this.getSize());
        this.anim.restartAnimator(pat, newjc);
        this.setBackground(this.anim.getBackground());
        this.engine = new Thread(this);
        this.engine.start();
    }

    public void restartJuggle() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.restartJuggle(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        this.engineRunning = true;
        this.engineAnimating = false;
        if (this.jc.mousePause) {
            this.waspaused = this.jc.startPause;
        }
        try {
            if (this.jc.startPause) {
                this.message = guistrings.getString("Message_click_to_start");
                this.repaint();
                this.enginePaused = true;
                while (this.enginePaused) {
                    AnimationPanel animationPanel = this;
                    synchronized (animationPanel) {
                        this.wait();
                    }
                }
            }
            this.message = null;
            long real_time_start = System.currentTimeMillis();
            if (this.jc.mousePause) {
                if (this.outside_valid) {
                    this.setPaused(this.outside);
                } else {
                    this.setPaused(true);
                }
                this.waspaused = false;
            }
            this.engineAnimating = true;
            while (true) {
                this.setTime(this.anim.pat.getLoopStartTime());
                while (this.getTime() < this.anim.pat.getLoopEndTime() - 0.5 * this.anim.sim_interval_secs) {
                    int path;
                    Object object;
                    this.repaint();
                    long real_time_wait = this.anim.real_interval_millis - (System.currentTimeMillis() - real_time_start);
                    if (real_time_wait > 0L) {
                        Thread.sleep(real_time_wait);
                    } else if (this.engine == null || Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    real_time_start = System.currentTimeMillis();
                    while (this.enginePaused) {
                        object = this;
                        synchronized (object) {
                            this.wait();
                        }
                    }
                    double oldtime = this.getTime();
                    this.setTime(this.getTime() + this.anim.sim_interval_secs);
                    double newtime = this.getTime();
                    if (this.jc.catchSound && this.catchclip != null) {
                        object = this.anim.pat;
                        synchronized (object) {
                            for (path = 1; path <= this.anim.pat.getNumberOfPaths(); ++path) {
                                if (!(this.anim.pat.getPathCatchVolume(path, oldtime, newtime) > 0.0)) continue;
                                SwingUtilities.invokeLater(new Runnable(this){
                                    final /* synthetic */ AnimationPanel this$0;
                                    {
                                        AnimationPanel animationPanel = this$0;
                                        Objects.requireNonNull(animationPanel);
                                        this.this$0 = animationPanel;
                                    }

                                    @Override
                                    public void run() {
                                        if (this.this$0.catchclip.isActive()) {
                                            this.this$0.catchclip.stop();
                                        }
                                        this.this$0.catchclip.setFramePosition(0);
                                        this.this$0.catchclip.start();
                                    }
                                });
                            }
                        }
                    }
                    if (!this.jc.bounceSound || this.bounceclip == null) continue;
                    object = this.anim.pat;
                    synchronized (object) {
                        for (path = 1; path <= this.anim.pat.getNumberOfPaths(); ++path) {
                            if (!(this.anim.pat.getPathBounceVolume(path, oldtime, newtime) > 0.0)) continue;
                            SwingUtilities.invokeLater(new Runnable(this){
                                final /* synthetic */ AnimationPanel this$0;
                                {
                                    AnimationPanel animationPanel = this$0;
                                    Objects.requireNonNull(animationPanel);
                                    this.this$0 = animationPanel;
                                }

                                @Override
                                public void run() {
                                    if (this.this$0.bounceclip.isActive()) {
                                        this.this$0.bounceclip.stop();
                                    }
                                    this.this$0.bounceclip.setFramePosition(0);
                                    this.this$0.bounceclip.start();
                                }
                            });
                        }
                    }
                }
                this.anim.advanceProps();
            }
        }
        catch (InterruptedException ie) {
            return;
        }
    }

    protected void killAnimationThread() {
        try {
            if (this.engine != null && this.engine.isAlive()) {
                this.engine.interrupt();
                this.engine.join();
            }
        }
        catch (InterruptedException ie) {
            return;
        }
        finally {
            this.engine = null;
            this.engineRunning = false;
            this.enginePaused = false;
            this.engineAnimating = false;
            this.message = null;
        }
    }

    public boolean isPaused() {
        return this.enginePaused;
    }

    public synchronized void setPaused(boolean wanttopause) {
        if (this.enginePaused && !wanttopause) {
            this.notify();
        }
        this.enginePaused = wanttopause;
    }

    public double getTime() {
        return this.sim_time;
    }

    public void setTime(double time) {
        this.sim_time = time;
        for (AnimationAttachment att : this.attachments) {
            att.setTime(time);
        }
    }

    public double[] getCameraAngle() {
        return this.anim.getCameraAngle();
    }

    public void setCameraAngle(double[] ca) {
        this.anim.setCameraAngle(ca);
    }

    protected void drawString(String message, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int message_width = fm.stringWidth(message);
        Dimension dim = this.getSize();
        int x = dim.width > message_width ? (dim.width - message_width) / 2 : 0;
        int y = (dim.height + fm.getHeight()) / 2;
        g.setColor(Color.white);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(Color.black);
        g.drawString(message, x, y);
    }

    public JMLPattern getPattern() {
        return this.anim.pat;
    }

    public Animator getAnimator() {
        return this.anim;
    }

    public AnimationPrefs getAnimationPrefs() {
        return this.jc;
    }

    public double getZoomLevel() {
        return this.getAnimator().getZoomLevel();
    }

    public void setZoomLevel(double z) {
        if (!this.writingGIF) {
            this.getAnimator().setZoomLevel(z);
            this.repaint();
        }
    }

    public void disposeAnimation() {
        this.killAnimationThread();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.message != null) {
            this.drawString(this.message, g);
        } else if (this.engineRunning && !this.writingGIF) {
            try {
                this.anim.drawFrame(this.getTime(), g, this.dragging_camera, true);
            }
            catch (JuggleExceptionInternal jei) {
                this.killAnimationThread();
                ErrorDialog.handleFatalException(jei);
            }
        }
    }

    public static interface AnimationAttachment {
        public void setAnimationPanel(AnimationPanel var1);

        public void setTime(double var1);

        public void repaintAttachment();
    }
}

