/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.view.View;

public class AnimationPrefs {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final int GROUND_AUTO = 0;
    public static final int GROUND_ON = 1;
    public static final int GROUND_OFF = 2;
    public static final int WIDTH_DEF = 400;
    public static final int HEIGHT_DEF = 450;
    public static final double FPS_DEF;
    public static final double SLOWDOWN_DEF = 2.0;
    public static final int BORDER_DEF = 0;
    public static final int SHOWGROUND_DEF = 0;
    public static final boolean STEREO_DEF = false;
    public static final boolean STARTPAUSE_DEF = false;
    public static final boolean MOUSEPAUSE_DEF = false;
    public static final boolean CATCHSOUND_DEF = false;
    public static final boolean BOUNCESOUND_DEF;
    public static final int VIEW_DEF = 0;
    public int width = 400;
    public int height = 450;
    public double fps = FPS_DEF;
    public double slowdown = 2.0;
    public int border = 0;
    public int showGround = 0;
    public boolean stereo = false;
    public boolean startPause = false;
    public boolean mousePause = false;
    public boolean catchSound = false;
    public boolean bounceSound = BOUNCESOUND_DEF;
    public double[] camangle;
    public int view = 0;
    public int[] hideJugglers;

    public AnimationPrefs() {
    }

    public AnimationPrefs(AnimationPrefs jc) {
        if (jc.width > 0) {
            this.width = jc.width;
        }
        if (jc.height > 0) {
            this.height = jc.height;
        }
        if (jc.slowdown >= 0.0) {
            this.slowdown = jc.slowdown;
        }
        if (jc.fps >= 0.0) {
            this.fps = jc.fps;
        }
        if (jc.border >= 0) {
            this.border = jc.border;
        }
        this.showGround = jc.showGround;
        this.stereo = jc.stereo;
        this.startPause = jc.startPause;
        this.mousePause = jc.mousePause;
        this.catchSound = jc.catchSound;
        this.bounceSound = jc.bounceSound;
        if (jc.camangle != null) {
            this.camangle = (double[])jc.camangle.clone();
        }
        this.view = jc.view;
        if (jc.hideJugglers != null) {
            this.hideJugglers = (int[])jc.hideJugglers.clone();
        }
    }

    public AnimationPrefs fromParameters(ParameterList pl) throws JuggleExceptionUser {
        int tempint;
        double tempdouble;
        String value = null;
        value = pl.removeParameter("stereo");
        if (value != null) {
            this.stereo = Boolean.parseBoolean(value);
        }
        if ((value = pl.removeParameter("startpaused")) != null) {
            this.startPause = Boolean.parseBoolean(value);
        }
        if ((value = pl.removeParameter("mousepause")) != null) {
            this.mousePause = Boolean.parseBoolean(value);
        }
        if ((value = pl.removeParameter("catchsound")) != null) {
            this.catchSound = Boolean.parseBoolean(value);
        }
        if ((value = pl.removeParameter("bouncesound")) != null) {
            this.bounceSound = Boolean.parseBoolean(value);
        }
        if ((value = pl.removeParameter("fps")) != null) {
            try {
                this.fps = tempdouble = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"fps"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("slowdown")) != null) {
            try {
                this.slowdown = tempdouble = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"slowdown"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("border")) != null) {
            try {
                this.border = tempint = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"border"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("width")) != null) {
            try {
                this.width = tempint = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"width"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("height")) != null) {
            try {
                this.height = tempint = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"height"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("showground")) != null) {
            if (value.equalsIgnoreCase("auto")) {
                this.showGround = 0;
            } else if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
                this.showGround = 1;
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
                this.showGround = 2;
            } else {
                String template = errorstrings.getString("Error_showground_value");
                Object[] arguments = new Object[]{value};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("camangle")) != null) {
            try {
                double[] ca = new double[2];
                ca[1] = 90.0;
                value = value.replace("(", "").replace(")", "");
                value = value.replace("{", "").replace("}", "");
                StringTokenizer st = new StringTokenizer(value, ",");
                int numangles = st.countTokens();
                if (numangles > 2) {
                    String template = errorstrings.getString("Error_too_many_elements");
                    Object[] arguments = new Object[]{"camangle"};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                for (int i = 0; i < numangles; ++i) {
                    ca[i] = Double.parseDouble(st.nextToken().trim());
                }
                this.camangle = new double[2];
                this.camangle[0] = ca[0];
                this.camangle[1] = ca[1];
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"camangle"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("view")) != null) {
            this.view = -1;
            for (int view_index = 0; view_index < View.viewNames.length; ++view_index) {
                if (!value.equalsIgnoreCase(View.viewNames[view_index])) continue;
                this.view = view_index + 1;
            }
            if (this.view == -1) {
                String template = errorstrings.getString("Error_unrecognized_view");
                Object[] arguments = new Object[]{"'" + value + "'"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((value = pl.removeParameter("hidejugglers")) != null) {
            value = value.replace("(", "").replace(")", "");
            StringTokenizer st = new StringTokenizer(value, ",");
            int numjugglers = st.countTokens();
            this.hideJugglers = new int[numjugglers];
            try {
                for (int i = 0; i < numjugglers; ++i) {
                    this.hideJugglers[i] = Integer.parseInt(st.nextToken().trim());
                }
            }
            catch (NumberFormatException e) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"hidejugglers"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        return this;
    }

    public AnimationPrefs fromString(String s) throws JuggleExceptionUser {
        ParameterList pl = new ParameterList(s);
        this.fromParameters(pl);
        pl.errorIfParametersLeft();
        return this;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension dim) {
        this.width = dim.width;
        this.height = dim.height;
    }

    public String toString() {
        Object result = "";
        if (this.width != 400) {
            result = (String)result + "width=" + this.width + ";";
        }
        if (this.height != 450) {
            result = (String)result + "height=" + this.height + ";";
        }
        if (this.fps != FPS_DEF) {
            result = (String)result + "fps=" + JLFunc.toStringRounded(this.fps, 2) + ";";
        }
        if (this.slowdown != 2.0) {
            result = (String)result + "slowdown=" + JLFunc.toStringRounded(this.slowdown, 2) + ";";
        }
        if (this.border != 0) {
            result = (String)result + "border=" + this.border + ";";
        }
        if (this.showGround != 0) {
            switch (this.showGround) {
                case 0: {
                    result = (String)result + "showground=auto;";
                    break;
                }
                case 1: {
                    result = (String)result + "showground=true;";
                    break;
                }
                case 2: {
                    result = (String)result + "showground=false;";
                }
            }
        }
        if (this.stereo) {
            result = (String)result + "stereo=" + this.stereo + ";";
        }
        if (this.startPause) {
            result = (String)result + "startpaused=" + this.startPause + ";";
        }
        if (this.mousePause) {
            result = (String)result + "mousepause=" + this.mousePause + ";";
        }
        if (this.catchSound) {
            result = (String)result + "catchsound=" + this.catchSound + ";";
        }
        if (this.bounceSound != BOUNCESOUND_DEF) {
            result = (String)result + "bouncesound=" + this.bounceSound + ";";
        }
        if (this.camangle != null) {
            result = (String)result + "camangle=(" + this.camangle[0] + "," + this.camangle[1] + ");";
        }
        if (this.view != 0) {
            result = (String)result + "view=" + View.viewNames[this.view - 1] + ";";
        }
        if (this.hideJugglers != null) {
            result = (String)result + "hidejugglers=(";
            for (int i = 0; i < this.hideJugglers.length; ++i) {
                result = (String)result + Integer.toString(this.hideJugglers[i]);
                if (i == this.hideJugglers.length - 1) continue;
                result = (String)result + ",";
            }
            result = (String)result + ");";
        }
        if (((String)result).length() != 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    static {
        BOUNCESOUND_DEF = JugglingLab.isLinux ? false : false;
        double fps_screen = 0.0;
        try {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            if (devices.length > 0) {
                fps_screen = devices[0].getDisplayMode().getRefreshRate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FPS_DEF = fps_screen < 20.0 ? 60.0 : fps_screen;
    }
}

