/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class AnimationPrefsDialog
extends JDialog {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final int BORDER = 10;
    protected JTextField tf_width;
    protected JTextField tf_height;
    protected JTextField tf_fps;
    protected JTextField tf_slowdown;
    protected JTextField tf_border;
    protected JComboBox<String> combo_showground;
    protected JCheckBox cb_paused;
    protected JCheckBox cb_mousepause;
    protected JCheckBox cb_stereo;
    protected JCheckBox cb_catchsounds;
    protected JCheckBox cb_bouncesounds;
    protected JTextField tf_other;
    protected JButton but_cancel;
    protected JButton but_ok;
    protected boolean ok_selected;

    public AnimationPrefsDialog(JFrame parent) {
        super(parent, guistrings.getString("Animation_Preferences"), true);
        this.createContents();
        this.setLocationRelativeTo(parent);
        this.but_cancel.addActionListener(new ActionListener(this){
            final /* synthetic */ AnimationPrefsDialog this$0;
            {
                AnimationPrefsDialog animationPrefsDialog = this$0;
                Objects.requireNonNull(animationPrefsDialog);
                this.this$0 = animationPrefsDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.setVisible(false);
                this.this$0.ok_selected = false;
            }
        });
        this.but_ok.addActionListener(new ActionListener(this){
            final /* synthetic */ AnimationPrefsDialog this$0;
            {
                AnimationPrefsDialog animationPrefsDialog = this$0;
                Objects.requireNonNull(animationPrefsDialog);
                this.this$0 = animationPrefsDialog;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.setVisible(false);
                this.this$0.ok_selected = true;
            }
        });
    }

    public AnimationPrefs getPrefs(AnimationPrefs oldjc) {
        this.tf_width.setText(Integer.toString(oldjc.width));
        this.tf_height.setText(Integer.toString(oldjc.height));
        this.tf_fps.setText(JLFunc.toStringRounded(oldjc.fps, 2));
        this.tf_slowdown.setText(JLFunc.toStringRounded(oldjc.slowdown, 2));
        this.tf_border.setText(Integer.toString(oldjc.border));
        this.combo_showground.setSelectedIndex(oldjc.showGround);
        this.cb_paused.setSelected(oldjc.startPause);
        this.cb_mousepause.setSelected(oldjc.mousePause);
        this.cb_stereo.setSelected(oldjc.stereo);
        this.cb_catchsounds.setSelected(oldjc.catchSound);
        this.cb_bouncesounds.setSelected(oldjc.bounceSound);
        try {
            String[] params_remove;
            ParameterList pl = new ParameterList(oldjc.toString());
            for (String param : params_remove = new String[]{"width", "height", "fps", "slowdown", "border", "showground", "stereo", "startpaused", "mousepause", "catchsound", "bouncesound"}) {
                pl.removeParameter(param);
            }
            this.tf_other.setText(pl.toString());
            this.tf_other.setCaretPosition(0);
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("Anim Prefs Dialog error: " + jeu.getMessage()));
        }
        this.ok_selected = false;
        this.setVisible(true);
        if (this.ok_selected) {
            return this.readDialogBox(oldjc);
        }
        return oldjc;
    }

    protected void createContents() {
        GridBagLayout gb = new GridBagLayout();
        this.getContentPane().setLayout(gb);
        JPanel p1 = new JPanel();
        p1.setLayout(gb);
        JLabel lab1 = new JLabel(guistrings.getString("Width"));
        p1.add(lab1);
        gb.setConstraints(lab1, AnimationPrefsDialog.make_constraints(21, 1, 0, new Insets(0, 3, 0, 0)));
        this.tf_width = new JTextField(4);
        this.tf_width.setHorizontalAlignment(0);
        p1.add(this.tf_width);
        gb.setConstraints(this.tf_width, AnimationPrefsDialog.make_constraints(21, 0, 0, new Insets(0, 0, 0, 0)));
        JLabel lab2 = new JLabel(guistrings.getString("Height"));
        p1.add(lab2);
        gb.setConstraints(lab2, AnimationPrefsDialog.make_constraints(21, 1, 1, new Insets(0, 3, 0, 0)));
        this.tf_height = new JTextField(4);
        this.tf_height.setHorizontalAlignment(0);
        p1.add(this.tf_height);
        gb.setConstraints(this.tf_height, AnimationPrefsDialog.make_constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        JLabel lab3 = new JLabel(guistrings.getString("Frames_per_second"));
        p1.add(lab3);
        gb.setConstraints(lab3, AnimationPrefsDialog.make_constraints(21, 1, 2, new Insets(0, 3, 0, 0)));
        this.tf_fps = new JTextField(4);
        this.tf_fps.setHorizontalAlignment(0);
        p1.add(this.tf_fps);
        gb.setConstraints(this.tf_fps, AnimationPrefsDialog.make_constraints(21, 0, 2, new Insets(0, 0, 0, 0)));
        JLabel lab4 = new JLabel(guistrings.getString("Slowdown_factor"));
        p1.add(lab4);
        gb.setConstraints(lab4, AnimationPrefsDialog.make_constraints(21, 1, 3, new Insets(0, 3, 0, 0)));
        this.tf_slowdown = new JTextField(4);
        this.tf_slowdown.setHorizontalAlignment(0);
        p1.add(this.tf_slowdown);
        gb.setConstraints(this.tf_slowdown, AnimationPrefsDialog.make_constraints(21, 0, 3, new Insets(0, 0, 0, 0)));
        JLabel lab5 = new JLabel(guistrings.getString("Border_(pixels)"));
        p1.add(lab5);
        gb.setConstraints(lab5, AnimationPrefsDialog.make_constraints(21, 1, 4, new Insets(0, 3, 0, 0)));
        this.tf_border = new JTextField(4);
        this.tf_border.setHorizontalAlignment(0);
        p1.add(this.tf_border);
        gb.setConstraints(this.tf_border, AnimationPrefsDialog.make_constraints(21, 0, 4, new Insets(0, 0, 0, 0)));
        JLabel lab6 = new JLabel(guistrings.getString("Prefs_show_ground"));
        p1.add(lab6);
        gb.setConstraints(lab6, AnimationPrefsDialog.make_constraints(21, 1, 5, new Insets(0, 3, 0, 0)));
        this.combo_showground = new JComboBox();
        this.combo_showground.addItem(guistrings.getString("Prefs_show_ground_auto"));
        this.combo_showground.addItem(guistrings.getString("Prefs_show_ground_yes"));
        this.combo_showground.addItem(guistrings.getString("Prefs_show_ground_no"));
        p1.add(this.combo_showground);
        gb.setConstraints(this.combo_showground, AnimationPrefsDialog.make_constraints(21, 0, 5, new Insets(0, 0, 0, 0)));
        this.cb_paused = new JCheckBox(guistrings.getString("Start_paused"));
        this.cb_mousepause = new JCheckBox(guistrings.getString("Pause_on_mouse_away"));
        this.cb_stereo = new JCheckBox(guistrings.getString("Stereo_display"));
        this.cb_catchsounds = new JCheckBox(guistrings.getString("Catch_sounds"));
        this.cb_bouncesounds = new JCheckBox(guistrings.getString("Bounce_sounds"));
        JLabel lab_other = new JLabel("Manual settings");
        this.tf_other = new JTextField(15);
        JPanel p2 = new JPanel();
        p2.setLayout(gb);
        this.but_cancel = new JButton(guistrings.getString("Cancel"));
        p2.add(this.but_cancel);
        gb.setConstraints(this.but_cancel, AnimationPrefsDialog.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        this.but_ok = new JButton(guistrings.getString("OK"));
        p2.add(this.but_ok);
        gb.setConstraints(this.but_ok, AnimationPrefsDialog.make_constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        this.getContentPane().add(p1);
        gb.setConstraints(p1, AnimationPrefsDialog.make_constraints(21, 0, 0, new Insets(3, 10, 0, 10)));
        this.getContentPane().add(this.cb_paused);
        gb.setConstraints(this.cb_paused, AnimationPrefsDialog.make_constraints(21, 0, 1, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_mousepause);
        gb.setConstraints(this.cb_mousepause, AnimationPrefsDialog.make_constraints(21, 0, 2, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_stereo);
        gb.setConstraints(this.cb_stereo, AnimationPrefsDialog.make_constraints(21, 0, 3, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_catchsounds);
        gb.setConstraints(this.cb_catchsounds, AnimationPrefsDialog.make_constraints(21, 0, 4, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_bouncesounds);
        gb.setConstraints(this.cb_bouncesounds, AnimationPrefsDialog.make_constraints(21, 0, 5, new Insets(0, 10, 8, 10)));
        this.getContentPane().add(lab_other);
        gb.setConstraints(lab_other, AnimationPrefsDialog.make_constraints(21, 0, 6, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.tf_other);
        gb.setConstraints(this.tf_other, AnimationPrefsDialog.make_constraints(21, 0, 7, new Insets(0, 10, 3, 10)));
        this.getContentPane().add(p2);
        gb.setConstraints(p2, AnimationPrefsDialog.make_constraints(22, 0, 8, new Insets(0, 10, 10, 10)));
        this.getRootPane().setDefaultButton(this.but_ok);
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.pack();
        this.setResizable(false);
    }

    protected static GridBagConstraints make_constraints(int location, int gridx, int gridy, Insets ins) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = location;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.insets = ins;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        return gbc;
    }

    protected AnimationPrefs readDialogBox(AnimationPrefs oldjc) {
        double tempdouble;
        Object[] arguments;
        String template;
        int tempint;
        AnimationPrefs newjc = new AnimationPrefs(oldjc);
        try {
            tempint = Integer.parseInt(this.tf_width.getText());
            if (tempint >= 0) {
                newjc.width = tempint;
            }
        }
        catch (NumberFormatException e) {
            template = errorstrings.getString("Error_number_format");
            arguments = new Object[]{"width"};
            new ErrorDialog(this, MessageFormat.format(template, arguments));
        }
        try {
            tempint = Integer.parseInt(this.tf_height.getText());
            if (tempint >= 0) {
                newjc.height = tempint;
            }
        }
        catch (NumberFormatException e) {
            template = errorstrings.getString("Error_number_format");
            arguments = new Object[]{"height"};
            new ErrorDialog(this, MessageFormat.format(template, arguments));
        }
        try {
            tempdouble = Double.parseDouble(this.tf_fps.getText());
            if (tempdouble > 0.0) {
                newjc.fps = tempdouble;
            }
        }
        catch (NumberFormatException e) {
            template = errorstrings.getString("Error_number_format");
            arguments = new Object[]{"fps"};
            new ErrorDialog(this, MessageFormat.format(template, arguments));
        }
        try {
            tempdouble = Double.parseDouble(this.tf_slowdown.getText());
            if (tempdouble > 0.0) {
                newjc.slowdown = tempdouble;
            }
        }
        catch (NumberFormatException e) {
            template = errorstrings.getString("Error_number_format");
            arguments = new Object[]{"slowdown"};
            new ErrorDialog(this, MessageFormat.format(template, arguments));
        }
        try {
            tempint = Integer.parseInt(this.tf_border.getText());
            if (tempint >= 0) {
                newjc.border = tempint;
            }
        }
        catch (NumberFormatException e) {
            template = errorstrings.getString("Error_number_format");
            arguments = new Object[]{"border"};
            new ErrorDialog(this, MessageFormat.format(template, arguments));
        }
        newjc.showGround = this.combo_showground.getSelectedIndex();
        newjc.startPause = this.cb_paused.isSelected();
        newjc.mousePause = this.cb_mousepause.isSelected();
        newjc.stereo = this.cb_stereo.isSelected();
        newjc.catchSound = this.cb_catchsounds.isSelected();
        newjc.bounceSound = this.cb_bouncesounds.isSelected();
        if (this.tf_other.getText().trim().length() > 0) {
            try {
                newjc = new AnimationPrefs().fromString(newjc.toString() + ";" + this.tf_other.getText());
            }
            catch (JuggleExceptionUser jeu) {
                new ErrorDialog(this, jeu.getMessage());
            }
        }
        return newjc;
    }
}

