/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.Renderer;
import jugglinglab.renderer.Renderer2D;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import org.w3c.dom.Node;

public class Animator {
    protected JMLPattern pat;
    protected AnimationPrefs jc;
    protected Renderer ren1;
    protected Renderer ren2;
    protected Coordinate overallmax;
    protected Coordinate overallmin;
    protected int num_frames;
    protected double sim_interval_secs;
    protected long real_interval_millis;
    protected int[] animpropnum;
    protected Permutation invpathperm;
    protected double[] camangle = new double[2];
    protected double[] camangle1 = new double[2];
    protected double[] camangle2 = new double[2];
    protected Dimension dim;

    public Animator() {
        this.jc = new AnimationPrefs();
    }

    public void restartAnimator(JMLPattern newpat, AnimationPrefs newjc) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (newpat != null) {
            newpat.layoutPattern();
            this.pat = newpat;
        }
        if (newjc != null) {
            this.jc = newjc;
        }
        if (this.pat == null) {
            return;
        }
        this.ren1 = new Renderer2D();
        this.ren1.setPattern(this.pat);
        if (this.jc.stereo) {
            this.ren2 = new Renderer2D();
            this.ren2.setPattern(this.pat);
        } else {
            this.ren2 = null;
        }
        this.initAnimator();
        double[] ca = new double[2];
        if (this.jc.camangle != null) {
            ca[0] = Math.toRadians(this.jc.camangle[0]);
            double theta = Math.min(179.9999, Math.max(1.0E-4, this.jc.camangle[1]));
            ca[1] = Math.toRadians(theta);
        } else if (this.pat.getNumberOfJugglers() == 1) {
            ca[0] = Math.toRadians(0.0);
            ca[1] = Math.toRadians(90.0);
        } else {
            ca[0] = Math.toRadians(340.0);
            ca[1] = Math.toRadians(70.0);
        }
        this.setCameraAngle(ca);
    }

    public Dimension getDimension() {
        return new Dimension(this.dim);
    }

    public void setDimension(Dimension d) {
        this.dim = new Dimension(d);
        if (this.ren1 != null) {
            this.syncRenderersToSize();
        }
    }

    public double[] getCameraAngle() {
        double[] result = new double[]{this.camangle[0], this.camangle[1]};
        return result;
    }

    protected void setCameraAngle(double[] ca) {
        while (ca[0] < 0.0) {
            ca[0] = ca[0] + Math.PI * 2;
        }
        while (ca[0] >= Math.PI * 2) {
            ca[0] = ca[0] - Math.PI * 2;
        }
        this.camangle[0] = ca[0];
        this.camangle[1] = ca[1];
        if (this.jc.stereo) {
            this.camangle1[0] = ca[0] - 0.05;
            this.camangle1[1] = ca[1];
            this.ren1.setCameraAngle(this.camangle1);
            this.camangle2[0] = ca[0] + 0.05;
            this.camangle2[1] = ca[1];
            this.ren2.setCameraAngle(this.camangle2);
        } else {
            this.camangle1[0] = ca[0];
            this.camangle1[1] = ca[1];
            this.ren1.setCameraAngle(this.camangle1);
        }
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.ren1.getBackground());
        g.fillRect(0, 0, this.dim.width, this.dim.height);
    }

    public void drawFrame(double sim_time, Graphics g, boolean draw_axes, boolean draw_background) throws JuggleExceptionInternal {
        if (draw_background) {
            this.drawBackground(g);
        }
        if (this.jc.stereo) {
            this.ren1.drawFrame(sim_time, this.animpropnum, this.jc.hideJugglers, g.create(0, 0, this.dim.width / 2, this.dim.height));
            this.ren2.drawFrame(sim_time, this.animpropnum, this.jc.hideJugglers, g.create(this.dim.width / 2, 0, this.dim.width / 2, this.dim.height));
        } else {
            this.ren1.drawFrame(sim_time, this.animpropnum, this.jc.hideJugglers, g);
        }
        if (draw_axes) {
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            for (int i = 0; i < (this.jc.stereo ? 2 : 1); ++i) {
                Renderer ren = i == 0 ? this.ren1 : this.ren2;
                double[] ca = ren.getCameraAngle();
                double theta = ca[0];
                double phi = ca[1];
                double xya = 30.0;
                double xyb = xya * Math.cos(phi);
                double zlen = xya * Math.sin(phi);
                int cx = 38 + i * (this.dim.width / 2);
                int cy = 45;
                int xx = cx + (int)(0.5 - xya * Math.cos(theta));
                int xy = cy + (int)(0.5 + xyb * Math.sin(theta));
                int yx = cx + (int)(0.5 + xya * Math.sin(theta));
                int yy = cy + (int)(0.5 + xyb * Math.cos(theta));
                int zx = cx;
                int zy = cy - (int)(0.5 + zlen);
                g.setColor(Color.green);
                g.drawLine(cx, cy, xx, xy);
                g.drawLine(cx, cy, yx, yy);
                g.drawLine(cx, cy, zx, zy);
                g.fillOval(xx - 2, xy - 2, 5, 5);
                g.fillOval(yx - 2, yy - 2, 5, 5);
                g.fillOval(zx - 2, zy - 2, 5, 5);
                g.drawString("x", xx - 2, xy - 4);
                g.drawString("y", yx - 2, yy - 4);
                g.drawString("z", zx - 2, zy - 4);
            }
        }
    }

    public void advanceProps() {
        int i;
        int paths = this.pat.getNumberOfPaths();
        int[] temppropnum = new int[paths];
        for (i = 0; i < paths; ++i) {
            temppropnum[this.invpathperm.getMapping((int)(i + 1)) - 1] = this.animpropnum[i];
        }
        for (i = 0; i < paths; ++i) {
            this.animpropnum[i] = temppropnum[i];
        }
    }

    public void initAnimator() {
        boolean sg = this.jc.showGround == 1 || this.jc.showGround == 0 && this.pat.isBouncePattern();
        this.ren1.setGround(sg);
        if (this.jc.stereo) {
            this.ren2.setGround(sg);
        }
        this.findMaxMin();
        this.syncRenderersToSize();
        this.num_frames = (int)(0.5 + (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) * this.jc.slowdown * this.jc.fps);
        this.sim_interval_secs = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)this.num_frames;
        this.real_interval_millis = (long)(1000.0 * this.sim_interval_secs * this.jc.slowdown);
        this.animpropnum = new int[this.pat.getNumberOfPaths()];
        for (int i = 0; i < this.pat.getNumberOfPaths(); ++i) {
            this.animpropnum[i] = this.pat.getPropAssignment(i + 1);
        }
        this.invpathperm = this.pat.getPathPermutation().getInverse();
    }

    public double getZoomLevel() {
        return this.ren1 == null ? 1.0 : this.ren1.getZoomLevel();
    }

    public void setZoomLevel(double z) {
        if (this.ren1 != null) {
            this.ren1.setZoomLevel(z);
        }
        if (this.ren2 != null) {
            this.ren2.setZoomLevel(z);
        }
    }

    protected void findMaxMin() {
        Coordinate patternmax = null;
        Coordinate patternmin = null;
        for (int i = 1; i <= this.pat.getNumberOfPaths(); ++i) {
            patternmax = Coordinate.max(patternmax, this.pat.getPathMax(i));
            patternmin = Coordinate.min(patternmin, this.pat.getPathMin(i));
        }
        Coordinate propmax = null;
        Coordinate propmin = null;
        for (int i = 1; i <= this.pat.getNumberOfProps(); ++i) {
            propmax = Coordinate.max(propmax, this.pat.getProp(i).getMax());
            propmin = Coordinate.min(propmin, this.pat.getProp(i).getMin());
        }
        patternmax = Coordinate.add(patternmax, propmax);
        patternmin = Coordinate.add(patternmin, propmin);
        Coordinate handmax = null;
        Coordinate handmin = null;
        for (int i = 1; i <= this.pat.getNumberOfJugglers(); ++i) {
            handmax = Coordinate.max(handmax, this.pat.getHandMax(i, 1));
            handmin = Coordinate.min(handmin, this.pat.getHandMin(i, 1));
            handmax = Coordinate.max(handmax, this.pat.getHandMax(i, 2));
            handmin = Coordinate.min(handmin, this.pat.getHandMin(i, 2));
        }
        Coordinate hwmax = this.ren1.getHandWindowMax();
        Coordinate hwmin = this.ren1.getHandWindowMin();
        hwmax.x = Math.max(Math.max(Math.abs(hwmax.x), Math.abs(hwmin.x)), Math.max(Math.abs(hwmax.y), Math.abs(hwmin.y)));
        hwmin.x = -hwmax.x;
        hwmax.y = hwmax.x;
        hwmin.y = hwmin.x;
        handmax = Coordinate.add(handmax, hwmax);
        handmin = Coordinate.add(handmin, hwmin);
        Coordinate jwmax = this.ren1.getJugglerWindowMax();
        Coordinate jwmin = this.ren1.getJugglerWindowMin();
        this.overallmax = Coordinate.max(patternmax, Coordinate.max(handmax, jwmax));
        this.overallmin = Coordinate.min(patternmin, Coordinate.min(handmin, jwmin));
    }

    protected void syncRenderersToSize() {
        Dimension d = new Dimension(this.dim);
        if (this.jc.stereo) {
            d.width /= 2;
            this.ren1.initDisplay(d, this.jc.border, this.overallmax, this.overallmin);
            this.ren2.initDisplay(d, this.jc.border, this.overallmax, this.overallmin);
        } else {
            this.ren1.initDisplay(d, this.jc.border, this.overallmax, this.overallmin);
        }
    }

    public int[] getAnimPropNum() {
        return this.animpropnum;
    }

    public Color getBackground() {
        return this.ren1.getBackground();
    }

    public AnimationPrefs getAnimationPrefs() {
        return this.jc;
    }

    public void writeGIF(OutputStream os, WriteGIFMonitor wgm, double fps) throws IOException, JuggleExceptionInternal {
        ImageWriter iw = ImageIO.getImageWritersByFormatName("gif").next();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        iw.setOutput(ios);
        iw.prepareWriteSequence(null);
        BufferedImage image = new BufferedImage(this.dim.width, this.dim.height, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (int i = 0; i < this.pat.getNumberOfPaths(); ++i) {
            this.animpropnum[i] = this.pat.getPropAssignment(i + 1);
        }
        int gif_num_frames = (int)(0.5 + (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) * this.jc.slowdown * fps);
        double gif_sim_interval_secs = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)gif_num_frames;
        double gif_real_interval_millis = (long)(1000.0 * gif_sim_interval_secs * this.jc.slowdown);
        int totalframes = this.pat.getPeriod() * gif_num_frames;
        int framecount = 0;
        String delayTime = String.valueOf((int)(0.5 + gif_real_interval_millis / 10.0));
        ImageWriteParam iwp = iw.getDefaultWriteParam();
        IIOMetadata metadata = null;
        for (int i = 0; i < this.pat.getPeriod(); ++i) {
            double time = this.pat.getLoopStartTime();
            for (int j = 0; j < gif_num_frames; ++j) {
                this.drawFrame(time, g, false, true);
                if (framecount < 2) {
                    metadata = iw.getDefaultImageMetadata(new ImageTypeSpecifier(image), iwp);
                    Animator.configureGIFMetadata(metadata, delayTime, framecount);
                }
                IIOImage ii = new IIOImage(image, null, metadata);
                iw.writeToSequence(ii, null);
                time += gif_sim_interval_secs;
                ++framecount;
                if (wgm == null) continue;
                wgm.update(framecount, totalframes);
                if (!wgm.isCanceled()) continue;
                ios.close();
                os.close();
                return;
            }
            this.advanceProps();
        }
        g.dispose();
        iw.endWriteSequence();
        ios.close();
        os.close();
    }

    private static void configureGIFMetadata(IIOMetadata meta, String delayTime, int imageIndex) {
        Node child;
        String metaFormat = meta.getNativeMetadataFormatName();
        if (!"javax_imageio_gif_image_1.0".equals(metaFormat)) {
            throw new IllegalArgumentException("Unfamiliar gif metadata format: " + metaFormat);
        }
        Node root = meta.getAsTree(metaFormat);
        for (child = root.getFirstChild(); child != null && !"GraphicControlExtension".equals(child.getNodeName()); child = child.getNextSibling()) {
        }
        IIOMetadataNode gce = (IIOMetadataNode)child;
        gce.setAttribute("userInputFlag", "FALSE");
        gce.setAttribute("delayTime", delayTime);
        if (imageIndex == 0) {
            IIOMetadataNode aes = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode ae = new IIOMetadataNode("ApplicationExtension");
            ae.setAttribute("applicationID", "NETSCAPE");
            ae.setAttribute("authenticationCode", "2.0");
            byte[] uo = new byte[]{1, 0, 0};
            ae.setUserObject(uo);
            aes.appendChild(ae);
            root.appendChild(aes);
        }
        try {
            meta.setFromTree(metaFormat, root);
        }
        catch (IIOInvalidTreeException e) {
            throw new Error(e);
        }
    }

    public static interface WriteGIFMonitor {
        public void update(int var1, int var2);

        public boolean isCanceled();
    }
}

