/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternListPanel;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.Transitioner;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.NotationControl;
import jugglinglab.notation.Pattern;
import jugglinglab.notation.SiteswapNotationControl;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.util.ParameterList;
import jugglinglab.view.View;

public class ApplicationPanel
extends JPanel
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected JFrame parent;
    protected JTabbedPane jtp;
    protected View animtarget;
    protected PatternListPanel patlist;
    protected boolean patlisttab = false;
    protected int currentnum = -1;
    protected JButton juggle_button;
    protected JButton trans_button;
    protected JButton gen_button;
    protected JLabel gen_busy;
    protected static final int MAX_PATTERNS = 1000;
    protected static final double MAX_TIME = 15.0;

    public ApplicationPanel(JFrame parent) {
        this(parent, null, null, false);
    }

    public ApplicationPanel(JFrame p, View v, PatternListPanel pl, boolean patlisttab) {
        this.parent = p;
        this.animtarget = v;
        this.patlist = pl;
        patlisttab = pl == null ? patlisttab : true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        block6: {
            String command = ae.getActionCommand();
            try {
                if (!command.startsWith("notation")) break block6;
                try {
                    int num = Integer.parseInt(command.substring(8));
                    if (num != this.currentnum) {
                        this.setNotation(num);
                        if (this.parent != null) {
                            this.parent.pack();
                        }
                        this.currentnum = num;
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new JuggleExceptionInternal("Error in notation number coding");
                }
            }
            catch (Exception e) {
                ErrorDialog.handleFatalException(e);
            }
        }
    }

    public void setNotation(int num) throws JuggleExceptionUser, JuggleExceptionInternal {
        Generator gen;
        Transitioner trans;
        if (num > Pattern.builtinNotations.length) {
            return;
        }
        if (this.jtp != null) {
            this.remove(this.jtp);
        }
        this.jtp = new JTabbedPane();
        switch (num) {
            case 1: {
                this.addPatternEntryControl(new SiteswapNotationControl());
            }
        }
        PatternListPanel pl = this.patlist;
        if (pl == null && this.patlisttab) {
            pl = new PatternListPanel(this.animtarget);
        }
        if ((trans = Transitioner.newTransitioner(Pattern.builtinNotations[num - 1])) != null) {
            this.addTransitionerControl(trans, pl);
        }
        if ((gen = Generator.newGenerator(Pattern.builtinNotations[num - 1])) != null) {
            this.addGeneratorControl(gen, pl);
        }
        if (pl != null) {
            this.jtp.addTab(guistrings.getString("Pattern_list_tab"), pl);
            if (this.patlist != null) {
                this.jtp.setSelectedComponent(pl);
            }
        }
        this.jtp.addChangeListener(new ChangeListener(this){
            final /* synthetic */ ApplicationPanel this$0;
            {
                ApplicationPanel applicationPanel = this$0;
                Objects.requireNonNull(applicationPanel);
                this.this$0 = applicationPanel;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.getRootPane().setDefaultButton(this.this$0.getDefaultButton());
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.jtp, "Center");
        if (this.parent != null) {
            this.parent.getRootPane().setDefaultButton(this.getDefaultButton());
        }
    }

    protected void addPatternEntryControl(NotationControl control) {
        final NotationControl fcontrol = control;
        JPanel np1 = new JPanel();
        np1.setLayout(new BorderLayout());
        np1.add((Component)control, "First");
        JPanel np2 = new JPanel();
        np2.setLayout(new FlowLayout(4));
        JButton nbut1 = new JButton(guistrings.getString("Defaults"));
        nbut1.addActionListener(new ActionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    fcontrol.resetControl();
                }
                catch (Exception e) {
                    ErrorDialog.handleFatalException(e);
                }
            }
        });
        np2.add(nbut1);
        this.juggle_button = new JButton(guistrings.getString("Juggle"));
        this.juggle_button.setDefaultCapable(true);
        this.juggle_button.addActionListener(new ActionListener(){
            final /* synthetic */ ApplicationPanel this$0;
            {
                ApplicationPanel applicationPanel = this$0;
                Objects.requireNonNull(applicationPanel);
                this.this$0 = applicationPanel;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                PatternWindow jaw2 = null;
                try {
                    ParameterList pl = fcontrol.getParameterList();
                    Pattern p = fcontrol.newPattern().fromParameters(pl);
                    AnimationPrefs jc = new AnimationPrefs().fromParameters(pl);
                    pl.errorIfParametersLeft();
                    String notation = p.getNotationName();
                    String config = p.toString();
                    JMLPattern pat = JMLPattern.fromBasePattern(notation, config);
                    pat.layoutPattern();
                    if (PatternWindow.bringToFront(pat.getHashCode())) {
                        return;
                    }
                    if (this.this$0.animtarget != null) {
                        this.this$0.animtarget.restartView(pat, jc);
                    } else {
                        jaw2 = new PatternWindow(pat.getTitle(), pat, jc);
                    }
                }
                catch (JuggleExceptionUser je) {
                    new ErrorDialog(this.this$0, je.getMessage());
                }
                catch (Exception e) {
                    if (jaw2 != null) {
                        jaw2.dispose();
                    }
                    ErrorDialog.handleFatalException(e);
                }
            }
        });
        np2.add(this.juggle_button);
        np1.add((Component)np2, "Last");
        this.jtp.addTab(guistrings.getString("Pattern_entry"), np1);
    }

    protected void addTransitionerControl(final Transitioner trans, final PatternListPanel plp) {
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)trans.getTransitionerControl(), "First");
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(4));
        JButton but1 = new JButton(guistrings.getString("Defaults"));
        but1.addActionListener(new ActionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                trans.resetTransitionerControl();
            }
        });
        p2.add(but1);
        this.trans_button = new JButton(guistrings.getString("Run"));
        this.trans_button.setDefaultCapable(true);
        this.trans_button.addActionListener(new ActionListener(){
            final /* synthetic */ ApplicationPanel this$0;
            {
                ApplicationPanel applicationPanel = this$0;
                Objects.requireNonNull(applicationPanel);
                this.this$0 = applicationPanel;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                Thread t = new Thread(this){
                    final /* synthetic */ 5 this$1;
                    {
                        5 v0 = this$1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.trans_button.setEnabled(false);
                        PatternListWindow pw = null;
                        try {
                            trans.initTransitioner();
                            GeneratorTarget pwot = null;
                            if (plp != null) {
                                plp.clearList();
                                pwot = new GeneratorTarget(plp);
                            } else {
                                String title = trans.getNotationName() + " " + guistrings.getString("Patterns");
                                pw = new PatternListWindow(title, this);
                                pwot = new GeneratorTarget(pw.getPatternListPanel());
                            }
                            trans.runTransitioner(pwot, 1000, 15.0);
                            if (plp != null) {
                                this.this$1.this$0.jtp.setSelectedComponent(plp);
                            }
                        }
                        catch (JuggleExceptionDone ex) {
                            if (plp != null) {
                                this.this$1.this$0.jtp.setSelectedComponent(plp);
                            }
                            Container parent = pw;
                            if (pw == null) {
                                parent = plp;
                            }
                            new LabelDialog(parent, guistrings.getString("Generator_stopped_title"), ex.getMessage());
                        }
                        catch (JuggleExceptionInterrupted ex) {
                        }
                        catch (JuggleExceptionUser ex) {
                            if (pw != null) {
                                pw.dispose();
                            }
                            new ErrorDialog(this.this$1.this$0, ex.getMessage());
                        }
                        catch (Exception e) {
                            if (pw != null) {
                                pw.dispose();
                            }
                            ErrorDialog.handleFatalException(e);
                        }
                        this.this$1.this$0.trans_button.setEnabled(true);
                    }
                };
                t.start();
            }
        });
        p2.add(this.trans_button);
        JPanel p3 = new JPanel();
        p3.setLayout(new BorderLayout());
        p3.add((Component)p2, "After");
        p1.add((Component)p3, "Last");
        this.jtp.addTab(guistrings.getString("Transitions"), p1);
    }

    protected void addGeneratorControl(final Generator gen, final PatternListPanel plp) {
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)gen.getGeneratorControl(), "First");
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(4));
        JButton but1 = new JButton(guistrings.getString("Defaults"));
        but1.addActionListener(new ActionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                gen.resetGeneratorControl();
            }
        });
        p2.add(but1);
        this.gen_button = new JButton(guistrings.getString("Run"));
        this.gen_button.addActionListener(new ActionListener(){
            final /* synthetic */ ApplicationPanel this$0;
            {
                ApplicationPanel applicationPanel = this$0;
                Objects.requireNonNull(applicationPanel);
                this.this$0 = applicationPanel;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                Thread t = new Thread(this){
                    final /* synthetic */ 7 this$1;
                    {
                        7 v0 = this$1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.gen_busy.setVisible(true);
                        this.this$1.this$0.gen_button.setEnabled(false);
                        PatternListWindow pw = null;
                        try {
                            gen.initGenerator();
                            GeneratorTarget pwot = null;
                            if (plp != null) {
                                plp.clearList();
                                pwot = new GeneratorTarget(plp);
                            } else {
                                String title = gen.getNotationName() + " " + guistrings.getString("Patterns");
                                pw = new PatternListWindow(title, this);
                                pwot = new GeneratorTarget(pw.getPatternListPanel());
                            }
                            gen.runGenerator(pwot, 1000, 15.0);
                            if (plp != null) {
                                this.this$1.this$0.jtp.setSelectedComponent(plp);
                            }
                        }
                        catch (JuggleExceptionDone ex) {
                            if (plp != null) {
                                this.this$1.this$0.jtp.setSelectedComponent(plp);
                            }
                            Container parent = pw;
                            if (pw == null) {
                                parent = plp;
                            }
                            new LabelDialog(parent, guistrings.getString("Generator_stopped_title"), ex.getMessage());
                        }
                        catch (JuggleExceptionInterrupted ex) {
                        }
                        catch (JuggleExceptionUser ex) {
                            if (pw != null) {
                                pw.dispose();
                            }
                            new ErrorDialog(this.this$1.this$0, ex.getMessage());
                        }
                        catch (Exception e) {
                            if (pw != null) {
                                pw.dispose();
                            }
                            ErrorDialog.handleFatalException(e);
                        }
                        this.this$1.this$0.gen_busy.setVisible(false);
                        this.this$1.this$0.gen_button.setEnabled(true);
                    }
                };
                t.start();
            }
        });
        p2.add(this.gen_button);
        this.gen_busy = new JLabel(guistrings.getString("Processing"));
        this.gen_busy.setVisible(false);
        JPanel p3 = new JPanel();
        p3.setLayout(new BorderLayout());
        JPanel p4 = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        p4.setLayout(gb);
        p4.add(this.gen_busy);
        gb.setConstraints(this.gen_busy, JLFunc.constraints(21, 0, 0, new Insets(0, 10, 0, 0)));
        p3.add((Component)p4, "Before");
        p3.add((Component)p2, "After");
        p1.add((Component)p3, "Last");
        this.jtp.addTab(guistrings.getString("Generator"), p1);
    }

    protected JButton getDefaultButton() {
        if (this.jtp == null) {
            return null;
        }
        if (this.jtp.getSelectedIndex() == 0) {
            return this.juggle_button;
        }
        if (this.jtp.getSelectedIndex() == 1) {
            return this.trans_button;
        }
        return this.gen_button;
    }
}

