/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.ApplicationPanel;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.Pattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.util.OpenFilesServer;
import jugglinglab.util.UpdateChecker;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ApplicationWindow
extends JFrame
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected JMenu windowmenu;
    protected static final String[] fileItems = new String[]{"New Pattern", "New Pattern List", "Open JML...", null, "Quit"};
    protected static final String[] fileCommands = new String[]{"newpat", "newpl", "open", null, "exit"};
    protected static final char[] fileShortcuts = new char[]{'N', 'L', 'O', ' ', 'Q'};
    protected static final String[] helpItems = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
    protected static final String[] helpCommands = new String[]{"about", "online"};

    public ApplicationWindow(String title) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(title);
        this.createMenus();
        this.createContents();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        int locx = Math.max(0, center.x - 600);
        this.setLocation(locx, 50);
        this.setResizable(false);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ApplicationWindow this$0;
            {
                ApplicationWindow applicationWindow = this$0;
                Objects.requireNonNull(applicationWindow);
                this.this$0 = applicationWindow;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    this.this$0.doMenuCommand(MenuCommand.FILE_EXIT);
                }
                catch (Exception ex) {
                    System.exit(0);
                }
            }
        });
        if (!ApplicationWindow.registerOpenFilesHandler()) {
            new OpenFilesServer();
        }
        new UpdateChecker();
        SwingUtilities.invokeLater(new Runnable(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                ApplicationWindow.updateWindowMenus();
            }
        });
    }

    protected void createContents() throws JuggleExceptionUser, JuggleExceptionInternal {
        ApplicationPanel ap = new ApplicationPanel(this);
        ap.setDoubleBuffered(true);
        this.setContentPane(ap);
        ap.setNotation(1);
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.setBackground(new Color(0.9f, 0.9f, 0.9f));
        this.pack();
    }

    protected static boolean registerOpenFilesHandler() {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        if (!Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE)) {
            return false;
        }
        Desktop.getDesktop().setOpenFileHandler(new OpenFilesHandler(){

            @Override
            public void openFiles(OpenFilesEvent ofe) {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
                    Desktop.getDesktop().requestForeground(true);
                }
                try {
                    for (File file : ofe.getFiles()) {
                        try {
                            ApplicationWindow.openJMLFile(file);
                        }
                        catch (JuggleExceptionUser jeu) {
                            String template = errorstrings.getString("Error_reading_file");
                            Object[] arguments = new Object[]{file.getName()};
                            String msg = MessageFormat.format(template, arguments) + ":\n" + jeu.getMessage();
                            new ErrorDialog(null, msg);
                        }
                    }
                }
                catch (JuggleExceptionInternal jei) {
                    ErrorDialog.handleFatalException(jei);
                }
            }
        });
        return true;
    }

    public static void updateWindowMenus() {
        final ArrayList<ApplicationWindow> apps = new ArrayList<ApplicationWindow>();
        final ArrayList<PatternListWindow> pls = new ArrayList<PatternListWindow>();
        final ArrayList<PatternWindow> anims = new ArrayList<PatternWindow>();
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        for (Frame fr : Frame.getFrames()) {
            if (!fr.isVisible()) continue;
            if (fr instanceof ApplicationWindow) {
                apps.add((ApplicationWindow)fr);
                menus.add(((ApplicationWindow)fr).getWindowMenu());
                continue;
            }
            if (fr instanceof PatternListWindow) {
                pls.add((PatternListWindow)fr);
                menus.add(((PatternListWindow)fr).getWindowMenu());
                continue;
            }
            if (!(fr instanceof PatternWindow)) continue;
            anims.add((PatternWindow)fr);
            menus.add(((PatternWindow)fr).getWindowMenu());
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                if (command.equals("front")) {
                    boolean foregroundSupported;
                    boolean bl = foregroundSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND);
                    if (foregroundSupported) {
                        Desktop.getDesktop().requestForeground(true);
                        return;
                    }
                    for (Frame fr : apps) {
                        fr.toFront();
                    }
                    for (Frame fr : pls) {
                        fr.toFront();
                    }
                    for (Frame fr : anims) {
                        fr.toFront();
                    }
                    return;
                }
                int windownum = Integer.parseInt(command);
                if (windownum < apps.size()) {
                    ((ApplicationWindow)apps.get(windownum)).toFront();
                    return;
                }
                if ((windownum -= apps.size()) < pls.size()) {
                    ((PatternListWindow)pls.get(windownum)).toFront();
                    return;
                }
                if ((windownum -= pls.size()) < anims.size()) {
                    ((PatternWindow)anims.get(windownum)).toFront();
                    return;
                }
                ErrorDialog.handleFatalException(new JuggleExceptionInternal("Window number out of range: " + command));
            }
        };
        for (JMenu wm : menus) {
            wm.removeAll();
            JMenuItem alltofront = new JMenuItem(guistrings.getString("Bring_All_To_Front"));
            alltofront.setActionCommand("front");
            alltofront.addActionListener(al);
            wm.add(alltofront);
            wm.addSeparator();
            int windownum = 0;
            for (ApplicationWindow aw : apps) {
                JMenuItem awitem = new JMenuItem(aw.getTitle());
                awitem.setActionCommand(String.valueOf(windownum++));
                awitem.addActionListener(al);
                wm.add(awitem);
            }
            for (PatternListWindow pl : pls) {
                JMenuItem plitem = new JMenuItem(pl.getTitle());
                plitem.setActionCommand(String.valueOf(windownum++));
                plitem.addActionListener(al);
                wm.add(plitem);
            }
            for (PatternWindow anim : anims) {
                JMenuItem animitem = new JMenuItem(anim.getTitle());
                animitem.setActionCommand(String.valueOf(windownum++));
                animitem.addActionListener(al);
                wm.add(animitem);
            }
        }
    }

    public static void newPattern() throws JuggleExceptionInternal {
        try {
            JMLPattern pat = JMLPattern.fromBasePattern("Siteswap", "pattern=3");
            PatternWindow pw = new PatternWindow("3", pat, new AnimationPrefs());
            pw.setViewMode(3);
        }
        catch (JuggleExceptionUser jeu) {
            throw new JuggleExceptionInternal(jeu.getMessage());
        }
    }

    public static void openJMLFile() throws JuggleExceptionInternal {
        JLFunc.jfc().setFileFilter(new FileNameExtensionFilter("JML file", "jml"));
        if (JLFunc.jfc().showOpenDialog(null) != 0) {
            return;
        }
        File file = JLFunc.jfc().getSelectedFile();
        if (file != null) {
            try {
                ApplicationWindow.openJMLFile(file);
            }
            catch (JuggleExceptionUser jeu) {
                String template = errorstrings.getString("Error_reading_file");
                Object[] arguments = new Object[]{file.getName()};
                String msg = MessageFormat.format(template, arguments) + ":\n" + jeu.getMessage();
                new ErrorDialog(null, msg);
            }
        }
    }

    public static void openJMLFile(File jmlf) throws JuggleExceptionUser, JuggleExceptionInternal {
        try {
            JMLParser parser = new JMLParser();
            parser.parse(new FileReader(jmlf));
            switch (parser.getFileType()) {
                case 1: {
                    JMLPattern pat = new JMLPattern(parser.getTree());
                    pat.layoutPattern();
                    if (!PatternWindow.bringToFront(pat.getHashCode())) {
                        PatternWindow pw = new PatternWindow(pat.getTitle(), pat, new AnimationPrefs());
                        pw.setJMLFilename(jmlf.getName());
                    }
                    break;
                }
                case 2: {
                    PatternListWindow plw = new PatternListWindow(parser.getTree());
                    plw.setJMLFilename(jmlf.getName());
                    break;
                }
                default: {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_invalid_JML"));
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_file_not_found") + ": " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_IO") + ": " + ioe.getMessage());
        }
        catch (SAXParseException spe) {
            String template = errorstrings.getString("Error_JML_parsing");
            Object[] arguments = new Object[]{spe.getLineNumber(), spe.getMessage().length() > 0 ? ":\n" + spe.getMessage() : ""};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        catch (SAXException se) {
            throw new JuggleExceptionUser(se.getMessage());
        }
    }

    public static void showAboutBox() {
        ImageIcon aboutPicture;
        final JFrame aboutBox = new JFrame(guistrings.getString("About_Juggling_Lab"));
        aboutBox.setDefaultCloseOperation(2);
        JPanel aboutPanel = new JPanel(new BorderLayout());
        aboutPanel.setOpaque(true);
        URL url = ApplicationWindow.class.getResource("/about.png");
        if (url != null && (aboutPicture = new ImageIcon(url, "A lab")) != null) {
            JLabel aboutLabel = new JLabel(aboutPicture);
            aboutPanel.add((Component)aboutLabel, "Before");
        }
        JPanel textPanel = new JPanel();
        aboutPanel.add((Component)textPanel, "After");
        GridBagLayout gb = new GridBagLayout();
        textPanel.setLayout(gb);
        JLabel abouttext1 = new JLabel("Juggling Lab");
        abouttext1.setFont(new Font("SansSerif", 1, 18));
        textPanel.add(abouttext1);
        gb.setConstraints(abouttext1, JLFunc.constraints(21, 0, 0, new Insets(15, 15, 0, 15)));
        String template = guistrings.getString("Version");
        Object[] arguments = new Object[]{"1.6.6"};
        JLabel abouttext5 = new JLabel(MessageFormat.format(template, arguments));
        abouttext5.setFont(new Font("SansSerif", 0, 16));
        textPanel.add(abouttext5);
        gb.setConstraints(abouttext5, JLFunc.constraints(21, 0, 1, new Insets(0, 15, 0, 15)));
        String template2 = guistrings.getString("Copyright_message");
        Object[] arguments2 = new Object[]{"2025"};
        JLabel abouttext6 = new JLabel(MessageFormat.format(template2, arguments2));
        abouttext6.setFont(new Font("SansSerif", 0, 14));
        textPanel.add(abouttext6);
        gb.setConstraints(abouttext6, JLFunc.constraints(21, 0, 2, new Insets(15, 15, 15, 15)));
        JLabel abouttext3 = new JLabel(guistrings.getString("GPL_message"));
        abouttext3.setFont(new Font("SansSerif", 0, 12));
        textPanel.add(abouttext3);
        gb.setConstraints(abouttext3, JLFunc.constraints(21, 0, 3, new Insets(0, 15, 15, 15)));
        String javaversion = System.getProperty("java.version");
        String javavmname = System.getProperty("java.vm.name");
        String javavmversion = System.getProperty("java.vm.version");
        int gridrow = 4;
        if (javaversion != null) {
            JLabel java1 = new JLabel("Java version " + javaversion);
            java1.setFont(new Font("SansSerif", 0, 12));
            textPanel.add(java1);
            gb.setConstraints(java1, JLFunc.constraints(21, 0, gridrow++, new Insets(0, 15, 0, 15)));
        }
        if (javavmname != null && javavmversion != null) {
            JLabel java2 = new JLabel(javavmname + " (" + javavmversion + ")");
            java2.setFont(new Font("SansSerif", 0, 12));
            textPanel.add(java2);
            gb.setConstraints(java2, JLFunc.constraints(21, 0, gridrow++, new Insets(0, 15, 0, 15)));
        }
        JButton okbutton = new JButton(guistrings.getString("OK"));
        textPanel.add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 0, gridrow++, new Insets(15, 15, 15, 15)));
        okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                aboutBox.setVisible(false);
                aboutBox.dispose();
            }
        });
        aboutBox.setContentPane(aboutPanel);
        Locale loc = Locale.getDefault();
        aboutBox.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        aboutBox.pack();
        aboutBox.setResizable(false);
        aboutBox.setLocationRelativeTo(null);
        aboutBox.setVisible(true);
    }

    public static void showOnlineHelp() {
        boolean browse_supported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        boolean browse_problem = false;
        if (browse_supported) {
            try {
                Desktop.getDesktop().browse(new URI("https://jugglinglab.org/#help"));
            }
            catch (Exception e) {
                browse_problem = true;
            }
        }
        if (!browse_supported || browse_problem) {
            new LabelDialog(null, "Help", "Find online help at https://jugglinglab.org/#help");
        }
    }

    protected void createMenus() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        if (Pattern.builtinNotations.length > 1) {
            JMenu notationmenu = this.createNotationMenu();
            mb.add(notationmenu);
            notationmenu.getItem(0).setSelected(true);
        }
        this.windowmenu = new JMenu(guistrings.getString("Window"));
        mb.add(this.windowmenu);
        mb.add(this.createHelpMenu());
        this.setJMenuBar(mb);
    }

    protected JMenu createFileMenu() {
        boolean quit_handler;
        boolean bl = quit_handler = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_QUIT_HANDLER);
        if (quit_handler) {
            Desktop.getDesktop().setQuitHandler(new QuitHandler(this){
                final /* synthetic */ ApplicationWindow this$0;
                {
                    ApplicationWindow applicationWindow = this$0;
                    Objects.requireNonNull(applicationWindow);
                    this.this$0 = applicationWindow;
                }

                @Override
                public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
                    try {
                        this.this$0.doMenuCommand(MenuCommand.FILE_EXIT);
                    }
                    catch (JuggleExceptionInternal jei) {
                        response.performQuit();
                    }
                }
            });
        }
        JMenu filemenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < (quit_handler ? fileItems.length - 2 : fileItems.length); ++i) {
            if (fileItems[i] == null) {
                filemenu.addSeparator();
                continue;
            }
            JMenuItem fileitem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                fileitem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            fileitem.setActionCommand(fileCommands[i]);
            fileitem.addActionListener(this);
            filemenu.add(fileitem);
        }
        return filemenu;
    }

    protected JMenu createNotationMenu() {
        JMenu notationmenu = new JMenu(guistrings.getString("Notation"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < Pattern.builtinNotations.length; ++i) {
            JRadioButtonMenuItem notationitem = new JRadioButtonMenuItem(Pattern.builtinNotations[i]);
            notationitem.setActionCommand("notation" + (i + 1));
            notationitem.addActionListener(this);
            notationmenu.add(notationitem);
            buttonGroup.add(notationitem);
        }
        return notationmenu;
    }

    public JMenu getWindowMenu() {
        return this.windowmenu;
    }

    protected JMenu createHelpMenu() {
        int i;
        boolean include_about = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT);
        JMenu helpmenu = new JMenu(guistrings.getString("Help"));
        int n = i = include_about ? 0 : 1;
        while (i < helpItems.length) {
            if (helpItems[i] == null) {
                helpmenu.addSeparator();
            } else {
                JMenuItem helpitem = new JMenuItem(guistrings.getString(helpItems[i].replace(' ', '_')));
                helpitem.setActionCommand(helpCommands[i]);
                helpitem.addActionListener(this);
                helpmenu.add(helpitem);
            }
            ++i;
        }
        return helpmenu;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        try {
            if (command.equals("newpat")) {
                this.doMenuCommand(MenuCommand.FILE_NEWPAT);
            } else if (command.equals("newpl")) {
                this.doMenuCommand(MenuCommand.FILE_NEWPL);
            } else if (command.equals("open")) {
                this.doMenuCommand(MenuCommand.FILE_OPEN);
            } else if (command.equals("exit")) {
                this.doMenuCommand(MenuCommand.FILE_EXIT);
            } else if (command.equals("about")) {
                this.doMenuCommand(MenuCommand.HELP_ABOUT);
            } else if (command.equals("online")) {
                this.doMenuCommand(MenuCommand.HELP_ONLINE);
            }
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
        }
    }

    protected void doMenuCommand(MenuCommand action) throws JuggleExceptionInternal {
        switch (action.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                ApplicationWindow.newPattern();
                break;
            }
            case 2: {
                new PatternListWindow("").setTitle(null);
                break;
            }
            case 3: {
                ApplicationWindow.openJMLFile();
                break;
            }
            case 4: {
                boolean noOpenFilesHandler;
                boolean bl = noOpenFilesHandler = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE);
                if (noOpenFilesHandler) {
                    OpenFilesServer.cleanup();
                }
                System.exit(0);
                break;
            }
            case 5: {
                ApplicationWindow.showAboutBox();
                break;
            }
            case 6: {
                ApplicationWindow.showOnlineHelp();
            }
        }
    }

    protected static enum MenuCommand {
        FILE_NONE,
        FILE_NEWPAT,
        FILE_NEWPL,
        FILE_OPEN,
        FILE_EXIT,
        HELP_ABOUT,
        HELP_ONLINE;

    }
}

