/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.core.AnimationEditPanel;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.LadderDiagram;
import jugglinglab.core.LadderEventItem;
import jugglinglab.core.LadderItem;
import jugglinglab.core.LadderPathItem;
import jugglinglab.core.LadderPositionItem;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PropDef;
import jugglinglab.path.Path;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.Permutation;
import jugglinglab.view.View;

public class EditLadderDiagram
extends LadderDiagram
implements ActionListener {
    protected static final double MIN_THROW_SEP_TIME = 0.05;
    protected static final double MIN_EVENT_SEP_TIME = 0.01;
    protected static final double MIN_POSITION_SEP_TIME = 0.02;
    protected static final Color COLOR_SELECTION = Color.green;
    protected static final int STATE_MOVING_EVENT = 2;
    protected static final int STATE_MOVING_POSITION = 3;
    protected static final int STATE_POPUP = 4;
    protected JFrame parentframe;
    protected View parentview;
    protected AnimationEditPanel aep;
    protected LadderEventItem active_eventitem;
    protected LadderPositionItem active_positionitem;
    protected boolean item_was_selected;
    protected int start_y;
    protected int start_ylow;
    protected int start_yhigh;
    protected double start_t;
    protected int delta_y;
    protected int delta_y_min;
    protected int delta_y_max;
    protected JPopupMenu popup;
    protected LadderItem popupitem;
    protected int popup_x;
    protected int popup_y;
    protected ArrayList<JComponent> dialog_controls;
    protected ParameterDescriptor[] dialog_pd;
    protected static final String[] popupItems = new String[]{"Change title...", "Change overall timing...", null, "Add event to L hand", "Add event to R hand", "Remove event", "Add position to juggler", "Remove position", null, "Define prop...", "Define throw...", "Change to normal catch", "Change to soft catch", "Change to grab catch", "Make last in event"};
    protected static final String[] popupCommands = new String[]{"changetitle", "changetiming", null, "addeventtoleft", "addeventtoright", "removeevent", "addposition", "removeposition", null, "defineprop", "definethrow", "changetocatch", "changetosoftcatch", "changetograbcatch", "makelast"};

    public EditLadderDiagram(JMLPattern pat, JFrame pframe, View pview) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(pat);
        this.parentframe = pframe;
        this.parentview = pview;
    }

    public void activeEventChanged() {
        if (this.active_eventitem == null) {
            return;
        }
        int hash = this.active_eventitem.getHashCode();
        this.layoutPattern(false);
        this.createView();
        this.active_eventitem = null;
        for (LadderEventItem item : this.laddereventitems) {
            if (item.getHashCode() != hash) continue;
            this.active_eventitem = item;
            break;
        }
        try {
            if (this.active_eventitem == null) {
                throw new JuggleExceptionInternal("activeEventChanged(): event not found", this.pat);
            }
            if (this.aep != null) {
                this.aep.activateEvent(this.active_eventitem.event);
            }
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
        }
    }

    public void activePositionChanged() {
        if (this.active_positionitem == null) {
            return;
        }
        int hash = this.active_positionitem.getHashCode();
        this.layoutPattern(false);
        this.createView();
        this.active_positionitem = null;
        for (LadderPositionItem item : this.ladderpositionitems) {
            if (item.getHashCode() != hash) continue;
            this.active_positionitem = item;
            break;
        }
        if (this.active_positionitem == null) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("ELD: position not found", this.pat));
        } else if (this.aep != null) {
            this.aep.activatePosition(this.active_positionitem.position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutPattern(boolean undo) {
        block7: {
            try {
                JMLPattern jMLPattern = this.pat;
                synchronized (jMLPattern) {
                    this.pat.setNeedsLayout();
                    this.pat.layoutPattern();
                    if (this.aep != null) {
                        this.aep.getAnimator().initAnimator();
                        this.aep.repaint();
                    }
                }
                if (undo) {
                    this.addToUndoList();
                }
            }
            catch (JuggleException je) {
                ErrorDialog.handleFatalException(je);
                if (this.parentframe == null) break block7;
                this.parentframe.dispose();
                this.parentframe = null;
            }
        }
    }

    public void addToUndoList() {
        this.parentview.addToUndoList(this.pat);
    }

    public void activateEvent(JMLEvent ev) throws JuggleExceptionInternal {
        this.createView();
        this.active_eventitem = null;
        JMLEvent ev_inloop = this.pat.getEventImageInLoop(ev);
        if (ev_inloop == null) {
            throw new JuggleExceptionInternal("activateEvent(): null event", this.pat);
        }
        for (LadderEventItem item : this.laddereventitems) {
            if (item.event != ev_inloop) continue;
            this.active_eventitem = item;
            break;
        }
        if (this.active_eventitem == null) {
            throw new JuggleExceptionInternal("activateEvent(): event not found", this.pat);
        }
    }

    public JMLEvent reactivateEvent() throws JuggleExceptionInternal {
        if (this.active_eventitem == null) {
            throw new JuggleExceptionInternal("reactivateEvent(): null eventitem", this.pat);
        }
        int hash = this.active_eventitem.getHashCode();
        this.createView();
        this.active_eventitem = null;
        for (LadderEventItem item : this.laddereventitems) {
            if (item.getHashCode() != hash) continue;
            this.active_eventitem = item;
            break;
        }
        if (this.active_eventitem == null) {
            throw new JuggleExceptionInternal("reactivateEvent(): event not found", this.pat);
        }
        return this.active_eventitem.event;
    }

    public void activatePosition(JMLPosition pos) throws JuggleExceptionInternal {
        this.createView();
        this.active_positionitem = null;
        for (LadderPositionItem item : this.ladderpositionitems) {
            if (item.position != pos) continue;
            this.active_positionitem = item;
            break;
        }
        if (this.active_positionitem == null) {
            throw new JuggleExceptionInternal("activatePosition(): position not found", this.pat);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.aep != null && (this.aep.writingGIF || !this.aep.engineAnimating)) {
            return;
        }
        int my = me.getY();
        my = Math.min(Math.max(my, 25), this.height - 25);
        if (me.isPopupTrigger()) {
            this.gui_state = 4;
            this.active_eventitem = this.getSelectedLadderEvent(me.getX(), me.getY());
            this.active_positionitem = this.getSelectedLadderPosition(me.getX(), me.getY());
            LadderItem ladderItem = this.popupitem = this.active_eventitem != null ? this.active_eventitem : this.active_positionitem;
            if (this.popupitem == null) {
                this.popupitem = this.getSelectedLadderPath(me.getX(), me.getY(), 5);
            }
            this.popup_x = me.getX();
            this.popup_y = me.getY();
            if (this.aep != null) {
                double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
                double newtime = (double)(my - 25) * scale;
                this.anim_paused = this.aep.isPaused();
                this.aep.setPaused(true);
                this.aep.setTime(newtime);
                this.aep.deactivateEvent();
                this.aep.deactivatePosition();
                if (this.active_eventitem != null) {
                    try {
                        this.aep.activateEvent(this.active_eventitem.event);
                    }
                    catch (JuggleExceptionInternal jei) {
                        jei.attachPattern(this.pat);
                        ErrorDialog.handleFatalException(jei);
                    }
                }
                if (this.active_positionitem != null) {
                    this.aep.activatePosition(this.active_positionitem.position);
                }
                this.aep.repaint();
            }
            this.makePopupMenu(this.popupitem).show(this, me.getX(), me.getY());
        } else {
            switch (this.gui_state) {
                case 0: {
                    this.item_was_selected = false;
                    LadderEventItem old_eventitem = this.active_eventitem;
                    this.active_eventitem = this.getSelectedLadderEvent(me.getX(), me.getY());
                    if (old_eventitem != null && old_eventitem == this.active_eventitem) {
                        this.item_was_selected = true;
                    }
                    if (this.active_eventitem != null) {
                        if (this.aep != null) {
                            try {
                                this.aep.activateEvent(this.active_eventitem.event);
                            }
                            catch (JuggleExceptionInternal jei) {
                                jei.attachPattern(this.pat);
                                ErrorDialog.handleFatalException(jei);
                            }
                        }
                        if (this.active_eventitem.type == 2) break;
                        this.gui_state = 2;
                        this.active_positionitem = null;
                        this.start_y = me.getY();
                        this.start_ylow = this.active_eventitem.ylow;
                        this.start_yhigh = this.active_eventitem.yhigh;
                        this.start_t = this.active_eventitem.event.getT();
                        this.findEventLimits(this.active_eventitem);
                        break;
                    }
                    LadderPositionItem old_positionitem = this.active_positionitem;
                    this.active_positionitem = this.getSelectedLadderPosition(me.getX(), me.getY());
                    if (old_positionitem != null && old_positionitem == this.active_positionitem) {
                        this.item_was_selected = true;
                    }
                    if (this.active_positionitem != null) {
                        this.gui_state = 3;
                        this.active_eventitem = null;
                        this.start_y = me.getY();
                        this.start_ylow = this.active_positionitem.ylow;
                        this.start_yhigh = this.active_positionitem.yhigh;
                        this.start_t = this.active_positionitem.position.getT();
                        this.findPositionLimits(this.active_positionitem);
                        if (this.aep == null) break;
                        this.aep.activatePosition(this.active_positionitem.position);
                        break;
                    }
                    this.gui_state = 1;
                    this.tracker_y = my;
                    if (this.aep == null) break;
                    double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
                    double newtime = (double)(my - 25) * scale;
                    this.anim_paused = this.aep.isPaused();
                    this.aep.setPaused(true);
                    this.aep.setTime(newtime);
                    this.aep.deactivateEvent();
                    this.aep.deactivatePosition();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    this.finishPopup();
                }
            }
            this.repaint();
            if (this.aep != null) {
                this.aep.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.aep != null && (this.aep.writingGIF || !this.aep.engineAnimating)) {
            return;
        }
        if (me.isPopupTrigger()) {
            switch (this.gui_state) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.gui_state != 1 && this.aep != null) {
                        int my = me.getY();
                        my = Math.min(Math.max(my, 25), this.height - 25);
                        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
                        double newtime = (double)(my - 25) * scale;
                        this.anim_paused = this.aep.isPaused();
                        this.aep.setPaused(true);
                        this.aep.setTime(newtime);
                        this.aep.deactivateEvent();
                        this.aep.deactivatePosition();
                        if (this.active_eventitem != null) {
                            try {
                                this.aep.activateEvent(this.active_eventitem.event);
                            }
                            catch (JuggleExceptionInternal jei) {
                                jei.attachPattern(this.pat);
                                ErrorDialog.handleFatalException(jei);
                            }
                        }
                        if (this.active_positionitem != null) {
                            this.aep.activatePosition(this.active_positionitem.position);
                        }
                        this.aep.repaint();
                    }
                    this.gui_state = 4;
                    if (this.delta_y != 0) {
                        this.delta_y = 0;
                        this.repaint();
                    }
                    this.popup_x = me.getX();
                    this.popup_y = me.getY();
                    LadderItem ladderItem = this.popupitem = this.active_eventitem != null ? this.active_eventitem : this.active_positionitem;
                    if (this.popupitem == null) {
                        this.popupitem = this.getSelectedLadderPath(me.getX(), me.getY(), 5);
                    }
                    this.makePopupMenu(this.popupitem).show(this, me.getX(), me.getY());
                    break;
                }
                case 4: {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("tried to enter POPUP state while already in it", this.pat));
                }
            }
        } else {
            switch (this.gui_state) {
                case 0: {
                    break;
                }
                case 2: {
                    this.gui_state = 0;
                    if (this.delta_y != 0) {
                        this.delta_y = 0;
                        this.addToUndoList();
                        break;
                    }
                    if (!this.item_was_selected) break;
                    this.active_eventitem = null;
                    if (this.aep != null) {
                        this.aep.deactivateEvent();
                        this.aep.repaint();
                    }
                    this.repaint();
                    break;
                }
                case 3: {
                    this.gui_state = 0;
                    if (this.delta_y != 0) {
                        this.delta_y = 0;
                        this.addToUndoList();
                        break;
                    }
                    if (!this.item_was_selected) break;
                    this.active_positionitem = null;
                    if (this.aep != null) {
                        this.aep.deactivatePosition();
                        this.aep.repaint();
                    }
                    this.repaint();
                    break;
                }
                case 1: {
                    this.gui_state = 0;
                    if (this.aep != null) {
                        this.aep.setPaused(this.anim_paused);
                    }
                    this.repaint();
                    break;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.aep != null && (this.aep.writingGIF || !this.aep.engineAnimating)) {
            return;
        }
        int my = me.getY();
        my = Math.min(Math.max(my, 25), this.height - 25);
        switch (this.gui_state) {
            case 0: {
                break;
            }
            case 2: {
                int old_delta_y = this.delta_y;
                this.delta_y = this.getClippedEventTime(me, this.active_eventitem.event);
                if (this.delta_y == old_delta_y) break;
                this.moveEventInPattern(this.active_eventitem.eventitem);
                this.activeEventChanged();
                this.repaint();
                break;
            }
            case 3: {
                int old_delta_y = this.delta_y;
                this.delta_y = this.getClippedPositionTime(me, this.active_positionitem.position);
                if (this.delta_y == old_delta_y) break;
                this.movePositionInPattern(this.active_positionitem);
                this.activePositionChanged();
                this.repaint();
                break;
            }
            case 1: {
                this.tracker_y = my;
                this.repaint();
                if (this.aep == null) break;
                double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
                double newtime = (double)(my - 25) * scale;
                this.aep.setTime(newtime);
                this.aep.repaint();
                break;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected void findEventLimits(LadderEventItem item) {
        double tmin = this.pat.getLoopStartTime();
        double tmax = this.pat.getLoopEndTime();
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        block4: for (JMLTransition tr : item.event.transitions()) {
            switch (tr.getType()) {
                case 1: {
                    JMLEvent ev;
                    for (ev = item.event.getPrevious(); ev != null && ev.getPathTransition(tr.getPath(), 2) == null && ev.getPathTransition(tr.getPath(), 3) == null && ev.getPathTransition(tr.getPath(), 4) == null; ev = ev.getPrevious()) {
                    }
                    if (ev == null) {
                        ErrorDialog.handleFatalException(new JuggleExceptionInternal("Null event 1 in mousePressed()", this.pat));
                        if (this.parentframe != null) {
                            this.parentframe.dispose();
                            this.parentframe = null;
                        }
                        return;
                    }
                    tmin = Math.max(tmin, ev.getT() + 0.05);
                    ev = tr.getOutgoingPathLink().getEndEvent();
                    if (ev.hasSameMasterAs(item.event)) continue block4;
                    tmax = Math.min(tmax, ev.getT() - 0.05);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    JMLEvent ev = tr.getIncomingPathLink().getStartEvent();
                    if (!ev.hasSameMasterAs(item.event)) {
                        tmin = Math.max(tmin, ev.getT() + 0.05);
                    }
                    for (ev = item.event.getNext(); ev != null && ev.getPathTransition(tr.getPath(), 1) == null; ev = ev.getNext()) {
                    }
                    if (ev == null) {
                        ErrorDialog.handleFatalException(new JuggleExceptionInternal("Null event 2 in mousePressed()", this.pat));
                        if (this.parentframe != null) {
                            this.parentframe.dispose();
                            this.parentframe = null;
                        }
                        return;
                    }
                    tmax = Math.min(tmax, ev.getT() - 0.05);
                }
            }
        }
        this.delta_y_min = (int)((tmin - item.event.getT()) / scale);
        this.delta_y_max = (int)((tmax - item.event.getT()) / scale);
    }

    protected int getClippedEventTime(MouseEvent me, JMLEvent event) {
        boolean changed;
        double newt;
        int dy = me.getY() - this.start_y;
        dy = Math.min(Math.max(dy, this.delta_y_min), this.delta_y_max);
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double shift = (double)dy * scale;
        double t_excl_min = newt = this.start_t + shift;
        double t_excl_max = newt;
        do {
            changed = false;
            for (JMLEvent ev = this.pat.getEventList(); ev != null; ev = ev.getNext()) {
                if (ev == event || ev.getJuggler() != event.getJuggler() || ev.getHand() != event.getHand()) continue;
                double sep = ev.hasThrow() && event.hasThrowOrCatch() || ev.hasThrowOrCatch() && event.hasThrow() ? 0.05 : 0.01;
                double ev_excl_min = ev.getT() - sep;
                double ev_excl_max = ev.getT() + sep;
                if (ev_excl_max > t_excl_max && ev_excl_min <= t_excl_max) {
                    t_excl_max = ev_excl_max;
                    changed = true;
                }
                if (!(ev_excl_min < t_excl_min) || !(ev_excl_max >= t_excl_min)) continue;
                t_excl_min = ev_excl_min;
                changed = true;
            }
        } while (changed);
        int excl_dy_min = (int)Math.floor((t_excl_min - this.start_t) / scale);
        int excl_dy_max = (int)Math.ceil((t_excl_max - this.start_t) / scale);
        boolean feasible_min = excl_dy_min >= this.delta_y_min && excl_dy_min <= this.delta_y_max;
        boolean feasible_max = excl_dy_max >= this.delta_y_min && excl_dy_max <= this.delta_y_max;
        int result_dy = dy;
        if (feasible_min && feasible_max) {
            double t_midpoint = 0.5 * (t_excl_min + t_excl_max);
            result_dy = newt <= t_midpoint ? excl_dy_min : excl_dy_max;
        } else if (feasible_min && !feasible_max) {
            result_dy = excl_dy_min;
        } else if (!feasible_min && feasible_max) {
            result_dy = excl_dy_max;
        }
        return result_dy;
    }

    protected void moveEventInPattern(LadderEventItem item) {
        JMLEvent ev = item.event;
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double shift = (double)this.delta_y * scale;
        double newt = this.start_t + shift;
        if (newt < this.pat.getLoopStartTime() + scale) {
            shift = this.pat.getLoopStartTime() - this.start_t;
            newt = this.pat.getLoopStartTime();
        } else if (newt >= this.pat.getLoopEndTime()) {
            shift = this.pat.getLoopEndTime() - 1.0E-4 - this.start_t;
            newt = this.pat.getLoopEndTime() - 1.0E-4;
        }
        boolean[] throwpath = new boolean[this.pat.getNumberOfPaths()];
        boolean[] catchpath = new boolean[this.pat.getNumberOfPaths()];
        boolean[] holdpathorig = new boolean[this.pat.getNumberOfPaths()];
        boolean[] holdpathnew = new boolean[this.pat.getNumberOfPaths()];
        for (JMLTransition tr : ev.transitions()) {
            switch (tr.getType()) {
                case 1: {
                    throwpath[tr.getPath() - 1] = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    catchpath[tr.getPath() - 1] = true;
                    break;
                }
                case 5: {
                    holdpathorig[tr.getPath() - 1] = true;
                    holdpathnew[tr.getPath() - 1] = true;
                }
            }
        }
        if (newt < ev.getT()) {
            for (ev = ev.getPrevious(); ev != null && ev.getT() > newt; ev = ev.getPrevious()) {
                int j;
                if (ev.hasSameMasterAs(item.event) || ev.getJuggler() != item.event.getJuggler() || ev.getHand() != item.event.getHand()) continue;
                block17: for (j = 0; j < ev.getNumberOfTransitions(); ++j) {
                    tr = ev.getTransition(j);
                    switch (tr.getType()) {
                        case 1: {
                            holdpathnew[tr.getPath() - 1] = true;
                            continue block17;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            holdpathnew[tr.getPath() - 1] = false;
                            continue block17;
                        }
                        case 5: {
                            if (!throwpath[tr.getPath() - 1]) continue block17;
                            ev.removeTransition(j);
                            if (!ev.isMaster()) {
                                ev.getMaster().removeTransition(j);
                            }
                            --j;
                        }
                    }
                }
                for (j = 0; j < this.pat.getNumberOfPaths(); ++j) {
                    if (!catchpath[j]) continue;
                    tr = new JMLTransition(5, j + 1, null, null);
                    ev.addTransition(tr);
                    if (ev.isMaster()) continue;
                    pp = ev.getPathPermFromMaster().getInverse();
                    tr = new JMLTransition(5, pp.getMapping(j + 1), null, null);
                    ev.getMaster().addTransition(tr);
                }
            }
        } else if (newt > ev.getT()) {
            for (ev = ev.getNext(); ev != null && ev.getT() < newt; ev = ev.getNext()) {
                int j;
                if (ev.hasSameMasterAs(item.event) || ev.getJuggler() != item.event.getJuggler() || ev.getHand() != item.event.getHand()) continue;
                block20: for (j = 0; j < ev.getNumberOfTransitions(); ++j) {
                    tr = ev.getTransition(j);
                    switch (tr.getType()) {
                        case 1: {
                            holdpathnew[tr.getPath() - 1] = false;
                            continue block20;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            holdpathnew[tr.getPath() - 1] = true;
                            continue block20;
                        }
                        case 5: {
                            if (!catchpath[tr.getPath() - 1]) continue block20;
                            ev.removeTransition(j);
                            if (!ev.isMaster()) {
                                ev.getMaster().removeTransition(j);
                            }
                            --j;
                        }
                    }
                }
                for (j = 0; j < this.pat.getNumberOfPaths(); ++j) {
                    if (!throwpath[j]) continue;
                    tr = new JMLTransition(5, j + 1, null, null);
                    ev.addTransition(tr);
                    if (ev.isMaster()) continue;
                    pp = ev.getPathPermFromMaster().getInverse();
                    tr = new JMLTransition(5, pp.getMapping(j + 1), null, null);
                    ev.getMaster().addTransition(tr);
                }
            }
        }
        ev = item.event;
        Permutation pp = ev.getPathPermFromMaster().getInverse();
        double new_master_t = this.start_t + shift;
        if (!ev.isMaster()) {
            double new_event_t = new_master_t;
            new_master_t += ev.getMaster().getT() - ev.getT();
            ev.setT(new_event_t);
            ev = ev.getMaster();
        }
        for (int j = 0; j < this.pat.getNumberOfPaths(); ++j) {
            JMLTransition tr;
            if (holdpathnew[j] == holdpathorig[j]) continue;
            if (holdpathnew[j]) {
                tr = new JMLTransition(5, pp.getMapping(j + 1), null, null);
                ev.addTransition(tr);
                continue;
            }
            tr = ev.getPathTransition(pp.getMapping(j + 1), 5);
            if (tr == null) {
                ErrorDialog.handleFatalException(new JuggleExceptionInternal("Null transition in removing hold", this.pat));
                if (this.parentframe != null) {
                    this.parentframe.dispose();
                    this.parentframe = null;
                }
                return;
            }
            ev.removeTransition(tr);
        }
        this.pat.removeEvent(ev);
        ev.setT(new_master_t);
        this.pat.addEvent(ev);
    }

    protected void findPositionLimits(LadderPositionItem item) {
        double tmin = this.pat.getLoopStartTime();
        double tmax = this.pat.getLoopEndTime();
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        this.delta_y_min = (int)((tmin - item.position.getT()) / scale);
        this.delta_y_max = (int)((tmax - item.position.getT()) / scale);
    }

    protected int getClippedPositionTime(MouseEvent me, JMLPosition position) {
        boolean changed;
        double newt;
        int dy = me.getY() - this.start_y;
        dy = Math.min(Math.max(dy, this.delta_y_min), this.delta_y_max);
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double shift = (double)dy * scale;
        double t_excl_min = newt = this.start_t + shift;
        double t_excl_max = newt;
        do {
            changed = false;
            for (JMLPosition pos = this.pat.getPositionList(); pos != null; pos = pos.getNext()) {
                if (pos == position || pos.getJuggler() != position.getJuggler()) continue;
                double pos_excl_min = pos.getT() - 0.02;
                double pos_excl_max = pos.getT() + 0.02;
                if (pos_excl_max > t_excl_max && pos_excl_min <= t_excl_max) {
                    t_excl_max = pos_excl_max;
                    changed = true;
                }
                if (!(pos_excl_min < t_excl_min) || !(pos_excl_max >= t_excl_min)) continue;
                t_excl_min = pos_excl_min;
                changed = true;
            }
        } while (changed);
        int excl_dy_min = (int)Math.floor((t_excl_min - this.start_t) / scale);
        int excl_dy_max = (int)Math.ceil((t_excl_max - this.start_t) / scale);
        boolean feasible_min = excl_dy_min >= this.delta_y_min && excl_dy_min <= this.delta_y_max;
        boolean feasible_max = excl_dy_max >= this.delta_y_min && excl_dy_max <= this.delta_y_max;
        int result_dy = dy;
        if (feasible_min && feasible_max) {
            double t_midpoint = 0.5 * (t_excl_min + t_excl_max);
            result_dy = newt <= t_midpoint ? excl_dy_min : excl_dy_max;
        } else if (feasible_min && !feasible_max) {
            result_dy = excl_dy_min;
        } else if (!feasible_min && feasible_max) {
            result_dy = excl_dy_max;
        }
        return result_dy;
    }

    protected void movePositionInPattern(LadderPositionItem item) {
        JMLPosition pos = item.position;
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double newt = this.start_t + (double)this.delta_y * scale;
        if (newt < this.pat.getLoopStartTime() + scale) {
            newt = this.pat.getLoopStartTime();
        } else if (newt >= this.pat.getLoopEndTime()) {
            newt = this.pat.getLoopEndTime() - 1.0E-4;
        }
        this.pat.removePosition(pos);
        pos.setT(newt);
        this.pat.addPosition(pos);
    }

    protected JPopupMenu makePopupMenu(LadderItem laditem) {
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < popupItems.length; ++i) {
            String name = popupItems[i];
            if (name == null) {
                popup.addSeparator();
                continue;
            }
            JMenuItem item = new JMenuItem(guistrings.getString(name.replace(' ', '_')));
            String command = popupCommands[i];
            item.setActionCommand(command);
            item.addActionListener(this);
            item.setEnabled(EditLadderDiagram.isCommandEnabled(laditem, command));
            popup.add(item);
        }
        popup.setBorder(new BevelBorder(0));
        popup.addPopupMenuListener(new PopupMenuListener(this){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.this$0.finishPopup();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        return popup;
    }

    protected static boolean isCommandEnabled(LadderItem laditem, String command) {
        if (laditem == null) {
            if (Arrays.asList("removeevent", "removeposition", "defineprop", "definethrow", "changetocatch", "changetosoftcatch", "changetograbcatch", "makelast").contains(command)) {
                return false;
            }
        } else if (laditem.type == 1) {
            if (Arrays.asList("changetitle", "changetiming", "addeventtoleft", "addeventtoright", "addposition", "removeposition", "defineprop", "definethrow", "changetocatch", "changetosoftcatch", "changetograbcatch", "makelast").contains(command)) {
                return false;
            }
            if (command.equals("removeevent")) {
                LadderEventItem evitem = (LadderEventItem)laditem;
                for (JMLTransition tr : evitem.event.transitions()) {
                    if (tr.getType() == 5) continue;
                    return false;
                }
                int hand = evitem.event.getHand();
                int juggler = evitem.event.getJuggler();
                JMLEvent evm1 = evitem.event.isMaster() ? evitem.event : evitem.event.getMaster();
                for (JMLEvent ev = evitem.event.getNext(); ev != null; ev = ev.getNext()) {
                    JMLEvent evm2;
                    if (ev.getHand() != hand || ev.getJuggler() != juggler) continue;
                    JMLEvent jMLEvent = evm2 = ev.isMaster() ? ev : ev.getMaster();
                    if (evm1 == evm2) {
                        return false;
                    }
                    break;
                }
            }
        } else if (laditem.type == 2) {
            if (Arrays.asList("changetitle", "changetiming", "addeventtoleft", "addeventtoright", "addposition", "removeposition", "removeevent").contains(command)) {
                return false;
            }
            LadderEventItem evitem = (LadderEventItem)laditem;
            JMLTransition tr = evitem.event.getTransition(evitem.transnum);
            if (command.equals("makelast") ? evitem.transnum == evitem.event.getNumberOfTransitions() - 1 : (command.equals("definethrow") ? tr.getType() != 1 : (command.equals("changetocatch") ? tr.getType() != 3 && tr.getType() != 4 : (command.equals("changetosoftcatch") ? tr.getType() != 2 && tr.getType() != 4 : command.equals("changetograbcatch") && tr.getType() != 2 && tr.getType() != 3)))) {
                return false;
            }
        } else if (laditem.type == 7 ? Arrays.asList("changetitle", "changetiming", "addeventtoleft", "addeventtoright", "removeevent", "addposition", "defineprop", "definethrow", "changetocatch", "changetosoftcatch", "changetograbcatch", "makelast").contains(command) : Arrays.asList("removeevent", "removeposition", "definethrow", "changetocatch", "changetosoftcatch", "changetograbcatch", "makelast").contains(command)) {
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("changetitle")) {
            this.changeTitle();
        } else if (command.equals("changetiming")) {
            this.changeTiming();
        } else if (command.equals("addeventtoleft")) {
            this.addEventToHand(1);
        } else if (command.equals("addeventtoright")) {
            this.addEventToHand(2);
        } else if (command.equals("removeevent")) {
            this.removeEvent();
        } else if (command.equals("addposition")) {
            this.addPositionToJuggler();
        } else if (command.equals("removeposition")) {
            this.removePosition();
        } else if (command.equals("defineprop")) {
            this.defineProp();
        } else if (command.equals("definethrow")) {
            this.defineThrow();
        } else if (command.equals("changetocatch")) {
            this.changeCatchStyleTo(2);
        } else if (command.equals("changetosoftcatch")) {
            this.changeCatchStyleTo(3);
        } else if (command.equals("changetograbcatch")) {
            this.changeCatchStyleTo(4);
        } else if (command.equals("makelast")) {
            this.makeLastInEvent();
        } else {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("unknown item in ELD popup", this.pat));
        }
        this.finishPopup();
    }

    protected void changeTitle() {
        final JDialog jd = new JDialog(this.parentframe, guistrings.getString("Change_title"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        final JTextField tf = new JTextField(20);
        tf.setText(this.pat.getTitle());
        JButton okbutton = new JButton(guistrings.getString("OK"));
        okbutton.addActionListener(new ActionListener(){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String newtitle = tf.getText();
                this.this$0.pat.setTitle(newtitle);
                jd.dispose();
                this.this$0.addToUndoList();
            }
        });
        jd.getContentPane().add(tf);
        gb.setConstraints(tf, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        jd.pack();
        jd.setResizable(false);
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
        this.parentframe.setTitle(this.pat.getTitle());
    }

    protected void changeTiming() {
        final JDialog jd = new JDialog(this.parentframe, guistrings.getString("Change_timing"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        JPanel p1 = new JPanel();
        p1.setLayout(gb);
        JLabel lab = new JLabel(guistrings.getString("Rescale_percentage"));
        p1.add(lab);
        gb.setConstraints(lab, JLFunc.constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        final JTextField tf = new JTextField(7);
        tf.setText("100");
        p1.add(tf);
        gb.setConstraints(tf, JLFunc.constraints(21, 1, 0, new Insets(0, 5, 0, 0)));
        JButton okbutton = new JButton(guistrings.getString("OK"));
        okbutton.addActionListener(new ActionListener(){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                double scale;
                try {
                    scale = JLFunc.parseDouble(tf.getText()) / 100.0;
                }
                catch (NumberFormatException nfe) {
                    new ErrorDialog(this.this$0, "Number format error in rescale percentage");
                    return;
                }
                if (scale > 0.0) {
                    this.this$0.pat.scaleTime(scale);
                    this.this$0.aep.setTime(0.0);
                    this.this$0.layoutPattern(true);
                    this.this$0.createView();
                }
                jd.dispose();
            }
        });
        jd.getContentPane().add(p1);
        gb.setConstraints(p1, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        jd.pack();
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
    }

    protected JMLEvent addEventToHand(int hand) {
        int juggler = 1;
        if (this.pat.getNumberOfJugglers() > 1) {
            int juggler_right_px = (this.left_x + this.right_x + this.juggler_delta_x) / 2;
            for (int mouse_x = this.popup_x; juggler <= this.pat.getNumberOfJugglers() && mouse_x >= juggler_right_px; mouse_x -= this.juggler_delta_x, ++juggler) {
            }
            if (juggler > this.pat.getNumberOfJugglers()) {
                juggler = this.pat.getNumberOfJugglers();
            }
        }
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double evtime = (double)(this.popup_y - 25) * scale;
        Coordinate evpos = new Coordinate();
        try {
            this.pat.getHandCoordinate(juggler, hand, evtime, evpos);
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
            if (this.parentframe != null) {
                this.parentframe.dispose();
                this.parentframe = null;
            }
            return null;
        }
        JMLEvent ev = new JMLEvent();
        ev.setLocalCoordinate(this.pat.convertGlobalToLocal(evpos, juggler, evtime));
        ev.setT(evtime);
        ev.setHand(juggler, hand);
        this.pat.addEvent(ev);
        for (int i = 0; i < this.pat.getNumberOfPaths(); ++i) {
            JMLTransition tr;
            boolean holding = false;
            for (JMLEvent evt = ev.getPrevious(); evt != null; evt = evt.getPrevious()) {
                tr = evt.getPathTransition(i + 1, 6);
                if (tr == null) continue;
                if (evt.getJuggler() != ev.getJuggler() || evt.getHand() != ev.getHand()) {
                    holding = false;
                    break;
                }
                if (tr.getType() == 1) {
                    holding = false;
                    break;
                }
                holding = true;
                break;
            }
            if (!holding) continue;
            tr = new JMLTransition(5, i + 1, null, null);
            ev.addTransition(tr);
        }
        this.active_eventitem = null;
        if (this.aep != null) {
            this.aep.deactivateEvent();
        }
        this.layoutPattern(true);
        this.createView();
        this.repaint();
        return ev;
    }

    protected void removeEvent() {
        if (!(this.popupitem instanceof LadderEventItem)) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram illegal remove event", this.pat));
            return;
        }
        JMLEvent ev = ((LadderEventItem)this.popupitem).event;
        if (!ev.isMaster()) {
            ev = ev.getMaster();
        }
        this.pat.removeEvent(ev);
        this.active_eventitem = null;
        if (this.aep != null) {
            this.aep.deactivateEvent();
        }
        this.layoutPattern(true);
        this.createView();
        this.repaint();
    }

    protected JMLPosition addPositionToJuggler() {
        int juggler = 1;
        if (this.pat.getNumberOfJugglers() > 1) {
            int juggler_right_px = (this.left_x + this.right_x + this.juggler_delta_x) / 2;
            for (int mouse_x = this.popup_x; juggler <= this.pat.getNumberOfJugglers() && mouse_x >= juggler_right_px; mouse_x -= this.juggler_delta_x, ++juggler) {
            }
            if (juggler > this.pat.getNumberOfJugglers()) {
                juggler = this.pat.getNumberOfJugglers();
            }
        }
        double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double postime = (double)(this.popup_y - 25) * scale;
        JMLPosition pos = new JMLPosition();
        Coordinate loc = new Coordinate();
        this.pat.getJugglerPosition(juggler, postime, loc);
        pos.setCoordinate(loc);
        pos.setAngle(this.pat.getJugglerAngle(juggler, postime));
        pos.setT(postime);
        pos.setJuggler(juggler);
        this.pat.addPosition(pos);
        this.active_eventitem = null;
        if (this.aep != null) {
            this.aep.deactivateEvent();
        }
        this.layoutPattern(true);
        this.createView();
        this.repaint();
        return pos;
    }

    protected void removePosition() {
        if (!(this.popupitem instanceof LadderPositionItem)) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram illegal remove position", this.pat));
            return;
        }
        JMLPosition pos = ((LadderPositionItem)this.popupitem).position;
        this.pat.removePosition(pos);
        this.active_positionitem = null;
        if (this.aep != null) {
            this.aep.deactivatePosition();
        }
        this.layoutPattern(true);
        this.createView();
        this.repaint();
    }

    protected void defineProp() {
        if (this.popupitem == null) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("defineProp() null popupitem", this.pat));
            return;
        }
        int pn = 0;
        if (this.popupitem instanceof LadderEventItem) {
            if (this.popupitem.type != 2) {
                ErrorDialog.handleFatalException(new JuggleExceptionInternal("defineProp() bad LadderItem type", this.pat));
                return;
            }
            JMLEvent ev = ((LadderEventItem)this.popupitem).event;
            int transnum = ((LadderEventItem)this.popupitem).transnum;
            JMLTransition tr = ev.getTransition(transnum);
            pn = tr.getPath();
        } else {
            pn = ((LadderPathItem)this.popupitem).pathnum;
        }
        final int pathnum = pn;
        final int[] animpropnum = this.aep.getAnimator().getAnimPropNum();
        final int propnum = animpropnum[pathnum - 1];
        final Prop startprop = this.pat.getProp(propnum);
        String[] prtypes = Prop.builtinProps;
        final JDialog jd = new JDialog(this.parentframe, guistrings.getString("Define_prop"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        JPanel p1 = new JPanel();
        p1.setLayout(gb);
        JLabel lab = new JLabel(guistrings.getString("Prop_type"));
        p1.add(lab);
        gb.setConstraints(lab, JLFunc.constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        final JPanel p2 = new JPanel();
        p2.setLayout(gb);
        final JComboBox<String> cb1 = new JComboBox<String>(prtypes);
        p1.add(cb1);
        gb.setConstraints(cb1, JLFunc.constraints(21, 1, 0, new Insets(0, 10, 0, 0)));
        cb1.addActionListener(new ActionListener(){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String type = (String)cb1.getItemAt(cb1.getSelectedIndex());
                try {
                    Prop pt = type.equalsIgnoreCase(startprop.getType()) ? startprop : Prop.newProp(type);
                    this.this$0.makeParametersPanel(p2, pt.getParameterDescriptors());
                }
                catch (JuggleExceptionUser jeu) {
                    new ErrorDialog(jd, jeu.getMessage());
                    return;
                }
                jd.pack();
            }
        });
        String[] bp = Prop.builtinProps;
        for (int i = 0; i < bp.length; ++i) {
            if (!bp[i].equalsIgnoreCase(startprop.getType())) continue;
            cb1.setSelectedIndex(i);
            break;
        }
        JPanel p3 = new JPanel();
        p3.setLayout(gb);
        JButton cancelbutton = new JButton(guistrings.getString("Cancel"));
        p3.add(cancelbutton);
        gb.setConstraints(cancelbutton, JLFunc.constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        cancelbutton.addActionListener(new ActionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                jd.dispose();
            }
        });
        JButton okbutton = new JButton(guistrings.getString("OK"));
        p3.add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        okbutton.addActionListener(new ActionListener(){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = (String)cb1.getItemAt(cb1.getSelectedIndex());
                String mod = null;
                try {
                    mod = this.this$0.getParameterList();
                    new PropDef(type.toLowerCase(), mod).layoutProp();
                }
                catch (JuggleExceptionUser jeu) {
                    new ErrorDialog(this.this$0.parentframe, jeu.getMessage());
                    return;
                }
                for (int i = 0; i < this.this$0.pat.getNumberOfPaths(); ++i) {
                    this.this$0.pat.setPropAssignment(i + 1, animpropnum[i]);
                }
                boolean killprop = true;
                for (int i = 0; i < this.this$0.pat.getNumberOfPaths(); ++i) {
                    if (i == pathnum - 1 || animpropnum[i] != propnum) continue;
                    killprop = false;
                    break;
                }
                if (killprop) {
                    this.this$0.pat.removeProp(propnum);
                }
                boolean gotmatch = false;
                int matchingprop = 0;
                for (int i = 1; i <= this.this$0.pat.getNumberOfProps(); ++i) {
                    PropDef pdef = this.this$0.pat.getPropDef(i);
                    if (!type.equalsIgnoreCase(pdef.getType()) || (mod != null || pdef.getMod() != null) && (mod == null || !mod.equalsIgnoreCase(pdef.getMod()))) continue;
                    gotmatch = true;
                    matchingprop = i;
                    break;
                }
                if (gotmatch) {
                    this.this$0.pat.setPropAssignment(pathnum, matchingprop);
                } else {
                    PropDef newprop = new PropDef(type.toLowerCase(), mod);
                    this.this$0.pat.addProp(newprop);
                    this.this$0.pat.setPropAssignment(pathnum, this.this$0.pat.getNumberOfProps());
                }
                if (this.this$0.active_eventitem != null) {
                    this.this$0.activeEventChanged();
                } else {
                    this.this$0.layoutPattern(true);
                }
                jd.dispose();
                this.this$0.repaint();
            }
        });
        jd.getContentPane().add(p1);
        gb.setConstraints(p1, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(p2);
        gb.setConstraints(p2, JLFunc.constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        jd.getContentPane().add(p3);
        gb.setConstraints(p3, JLFunc.constraints(22, 0, 2, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        Locale loc = Locale.getDefault();
        jd.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        jd.pack();
        jd.setResizable(false);
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
        this.dialog_controls = null;
    }

    protected void defineThrow() {
        if (!(this.popupitem instanceof LadderEventItem)) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("defineThrow() class format", this.pat));
            return;
        }
        JMLEvent ev = ((LadderEventItem)this.popupitem).event;
        if (!ev.isMaster()) {
            ev = ev.getMaster();
        }
        final JMLTransition tr = ev.getTransition(((LadderEventItem)this.popupitem).transnum);
        String[] pptypes = Path.builtinPaths;
        final JDialog jd = new JDialog(this.parentframe, guistrings.getString("Define_throw"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        JPanel p1 = new JPanel();
        p1.setLayout(gb);
        JLabel lab = new JLabel(guistrings.getString("Throw_type"));
        p1.add(lab);
        gb.setConstraints(lab, JLFunc.constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        final JPanel p2 = new JPanel();
        p2.setLayout(gb);
        final JComboBox<String> cb1 = new JComboBox<String>(pptypes);
        p1.add(cb1);
        gb.setConstraints(cb1, JLFunc.constraints(21, 1, 0, new Insets(0, 10, 0, 0)));
        cb1.addActionListener(new ActionListener(){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String type = (String)cb1.getItemAt(cb1.getSelectedIndex());
                try {
                    Path ppt = type.equalsIgnoreCase(tr.getThrowType()) ? tr.getOutgoingPathLink().getPath() : Path.newPath(type);
                    this.this$0.makeParametersPanel(p2, ppt.getParameterDescriptors());
                }
                catch (JuggleExceptionUser jeu) {
                    new ErrorDialog(jd, jeu.getMessage());
                    return;
                }
                jd.pack();
            }
        });
        String[] bpp = Path.builtinPaths;
        for (int i = 0; i < bpp.length; ++i) {
            if (!bpp[i].equalsIgnoreCase(tr.getThrowType())) continue;
            cb1.setSelectedIndex(i);
            break;
        }
        JPanel p3 = new JPanel();
        p3.setLayout(gb);
        JButton cancelbutton = new JButton(guistrings.getString("Cancel"));
        p3.add(cancelbutton);
        gb.setConstraints(cancelbutton, JLFunc.constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        cancelbutton.addActionListener(new ActionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                jd.dispose();
            }
        });
        JButton okbutton = new JButton(guistrings.getString("OK"));
        p3.add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        okbutton.addActionListener(new ActionListener(){
            final /* synthetic */ EditLadderDiagram this$0;
            {
                EditLadderDiagram editLadderDiagram = this$0;
                Objects.requireNonNull(editLadderDiagram);
                this.this$0 = editLadderDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = (String)cb1.getItemAt(cb1.getSelectedIndex());
                tr.setThrowType(type.toLowerCase());
                String mod = null;
                try {
                    mod = this.this$0.getParameterList();
                }
                catch (JuggleExceptionUser jeu) {
                    new ErrorDialog(this.this$0.parentframe, jeu.getMessage());
                    return;
                }
                tr.setMod(mod);
                this.this$0.activeEventChanged();
                jd.dispose();
            }
        });
        jd.getContentPane().add(p1);
        gb.setConstraints(p1, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(p2);
        gb.setConstraints(p2, JLFunc.constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        jd.getContentPane().add(p3);
        gb.setConstraints(p3, JLFunc.constraints(22, 0, 2, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        jd.pack();
        jd.setResizable(false);
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
        this.dialog_controls = null;
    }

    protected void changeCatchStyleTo(int type) {
        if (this.popupitem == null) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("No popupitem in case 10", this.pat));
            return;
        }
        if (!(this.popupitem instanceof LadderEventItem)) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram change to catch class format", this.pat));
            return;
        }
        JMLEvent ev = ((LadderEventItem)this.popupitem).event;
        if (!ev.isMaster()) {
            ev = ev.getMaster();
        }
        JMLTransition tr = ev.getTransition(((LadderEventItem)this.popupitem).transnum);
        tr.setType(type);
        this.activeEventChanged();
        this.repaint();
    }

    protected void makeLastInEvent() {
        if (this.popupitem == null) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("No popupitem in case 8", this.pat));
            return;
        }
        if (!(this.popupitem instanceof LadderEventItem)) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram make last transition class format", this.pat));
            return;
        }
        JMLEvent ev = ((LadderEventItem)this.popupitem).event;
        if (!ev.isMaster()) {
            ev = ev.getMaster();
        }
        JMLTransition tr = ev.getTransition(((LadderEventItem)this.popupitem).transnum);
        ev.removeTransition(tr);
        ev.addTransition(tr);
        this.active_eventitem = null;
        if (this.aep != null) {
            this.aep.deactivateEvent();
        }
        this.layoutPattern(true);
        this.createView();
        this.repaint();
    }

    protected void makeParametersPanel(JPanel jp, ParameterDescriptor[] pd) {
        jp.removeAll();
        GridBagLayout gb = new GridBagLayout();
        jp.setLayout(gb);
        this.dialog_controls = new ArrayList();
        this.dialog_pd = pd;
        if (pd.length != 0) {
            JPanel pdp = new JPanel();
            pdp.setLayout(gb);
            block0: for (int i = 0; i < pd.length; ++i) {
                JTextField tf;
                JLabel lab = new JLabel(pd[i].name);
                pdp.add(lab);
                gb.setConstraints(lab, JLFunc.constraints(21, 0, i, new Insets(0, 0, 0, 0)));
                if (pd[i].type == 1) {
                    JCheckBox jcb = new JCheckBox();
                    pdp.add(jcb);
                    gb.setConstraints(jcb, JLFunc.constraints(21, 1, i, new Insets(2, 5, 2, 0)));
                    this.dialog_controls.add(jcb);
                    boolean def = (Boolean)pd[i].value;
                    jcb.setSelected(def);
                    continue;
                }
                if (pd[i].type == 2) {
                    tf = new JTextField(7);
                    pdp.add(tf);
                    gb.setConstraints(tf, JLFunc.constraints(21, 1, i, new Insets(0, 5, 0, 0)));
                    this.dialog_controls.add(tf);
                    Double def = (Double)pd[i].value;
                    tf.setText(def.toString());
                    continue;
                }
                if (pd[i].type == 3) {
                    String[] choices = new String[pd[i].range.size()];
                    pd[i].range.toArray(choices);
                    JComboBox<String> jcb = new JComboBox<String>(choices);
                    jcb.setMaximumRowCount(15);
                    pdp.add(jcb);
                    gb.setConstraints(jcb, JLFunc.constraints(21, 1, i, new Insets(0, 5, 0, 0)));
                    this.dialog_controls.add(jcb);
                    String val = (String)pd[i].value;
                    for (int j = 0; j < choices.length; ++j) {
                        if (!val.equalsIgnoreCase(choices[j])) continue;
                        jcb.setSelectedIndex(j);
                        continue block0;
                    }
                    continue;
                }
                if (pd[i].type == 4) {
                    tf = new JTextField(4);
                    pdp.add(tf);
                    gb.setConstraints(tf, JLFunc.constraints(21, 1, i, new Insets(0, 5, 0, 0)));
                    this.dialog_controls.add(tf);
                    Integer def = (Integer)pd[i].value;
                    tf.setText(def.toString());
                    tf.addCaretListener(new CaretListener(this){
                        {
                            Objects.requireNonNull(this$0);
                        }

                        @Override
                        public void caretUpdate(CaretEvent e) {
                        }
                    });
                    continue;
                }
                if (pd[i].type != 5) continue;
                ParameterDescriptor fpd = pd[i];
                final ParameterDescriptor[] fpds = pd;
                final JPanel fjp = jp;
                URL filename = (URL)fpd.value;
                ImageIcon icon = new ImageIcon(filename, filename.toString());
                float MAX_HEIGHT = 100.0f;
                if ((float)icon.getIconHeight() > 100.0f) {
                    float scaleFactor = 100.0f / (float)icon.getIconHeight();
                    int height = (int)(scaleFactor * (float)icon.getIconHeight());
                    int width = (int)(scaleFactor * (float)icon.getIconWidth());
                    icon.setImage(icon.getImage().getScaledInstance(width, height, 4));
                }
                JLabel label = new JLabel(icon);
                label.addMouseListener(new MouseAdapter(this){
                    final /* synthetic */ EditLadderDiagram this$0;
                    {
                        EditLadderDiagram editLadderDiagram = this$0;
                        Objects.requireNonNull(editLadderDiagram);
                        this.this$0 = editLadderDiagram;
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JLFunc.jfc().setFileFilter(new FileNameExtensionFilter("Image file", "jpg", "jpeg", "gif", "png"));
                        int result = JLFunc.jfc().showOpenDialog(this.this$0);
                        if (result != 0) {
                            return;
                        }
                        try {
                            URL source = JLFunc.jfc().getSelectedFile().toURI().toURL();
                            fpds[0].value = source;
                            this.this$0.makeParametersPanel(fjp, fpds);
                            ((JDialog)fjp.getTopLevelAncestor()).pack();
                        }
                        catch (MalformedURLException ex) {
                            ErrorDialog.handleFatalException(new JuggleExceptionUser(LadderDiagram.errorstrings.getString("Error_malformed_URL.")));
                        }
                    }
                });
                pdp.add(label);
                gb.setConstraints(label, JLFunc.constraints(21, 1, i, new Insets(0, 5, 5, 0)));
                this.dialog_controls.add(label);
            }
            jp.add(pdp);
            gb.setConstraints(pdp, JLFunc.constraints(21, 0, 1, new Insets(10, 10, 0, 10)));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String getParameterList() throws JuggleExceptionUser {
        result = null;
        for (i = 0; i < this.dialog_pd.length; ++i) {
            term = null;
            control = this.dialog_controls.get(i);
            if (this.dialog_pd[i].type == 1) {
                jcb = (JCheckBox)control;
                val = jcb.isSelected();
                if (val != (def_val = ((Boolean)this.dialog_pd[i].default_value).booleanValue())) {
                    term = Boolean.valueOf(val).toString();
                }
            } else if (this.dialog_pd[i].type == 2) {
                tf = (JTextField)control;
                try {
                    val = JLFunc.parseDouble(tf.getText());
                    def_val = (Double)this.dialog_pd[i].default_value;
                    if (val == def_val) ** GOTO lbl48
                    term = tf.getText().trim();
                }
                catch (NumberFormatException nfe) {
                    template = EditLadderDiagram.errorstrings.getString("Error_number_format");
                    arguments = new Object[]{this.dialog_pd[i].name};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            } else if (this.dialog_pd[i].type == 3) {
                jcb = (JComboBox)control;
                ind = jcb.getSelectedIndex();
                val = this.dialog_pd[i].range.get(ind);
                if (!val.equalsIgnoreCase(def_val = (String)this.dialog_pd[i].default_value)) {
                    term = val;
                }
            } else if (this.dialog_pd[i].type == 4) {
                tf = (JTextField)control;
                try {
                    val = Integer.valueOf(tf.getText());
                    def_val = (Integer)this.dialog_pd[i].default_value;
                    if (val == def_val) ** GOTO lbl48
                    term = tf.getText().trim();
                }
                catch (NumberFormatException nfe) {
                    template = EditLadderDiagram.errorstrings.getString("Error_number_format");
                    arguments = new Object[]{this.dialog_pd[i].name};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            } else if (this.dialog_pd[i].type == 5) {
                label = (JLabel)control;
                icon = (ImageIcon)label.getIcon();
                def = ((URL)this.dialog_pd[i].default_value).toString();
                if (!icon.getDescription().equals(def)) {
                    term = icon.getDescription();
                }
            }
lbl48:
            // 11 sources

            if (term == null) continue;
            term = this.dialog_pd[i].name + "=" + (String)term;
            result = result == null ? term : (String)result + ";" + (String)term;
        }
        return result;
    }

    protected void finishPopup() {
        this.popupitem = null;
        if (this.gui_state == 4) {
            this.gui_state = 0;
            if (this.aep != null) {
                this.aep.setPaused(this.anim_paused);
            }
        }
    }

    @Override
    public void setAnimationPanel(AnimationPanel a) {
        super.setAnimationPanel(a);
        if (a instanceof AnimationEditPanel) {
            this.aep = (AnimationEditPanel)a;
        }
    }

    @Override
    protected void paintComponent(Graphics gr) {
        if (gr instanceof Graphics2D) {
            Graphics2D gr2 = (Graphics2D)gr;
            gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (!this.paintLadder(gr)) {
            return;
        }
        if (this.active_positionitem != null) {
            gr.setColor(COLOR_SELECTION);
            gr.drawLine(this.active_positionitem.xlow - 1, this.active_positionitem.ylow - 1, this.active_positionitem.xhigh + 1, this.active_positionitem.ylow - 1);
            gr.drawLine(this.active_positionitem.xhigh + 1, this.active_positionitem.ylow - 1, this.active_positionitem.xhigh + 1, this.active_positionitem.yhigh + 1);
            gr.drawLine(this.active_positionitem.xhigh + 1, this.active_positionitem.yhigh + 1, this.active_positionitem.xlow, this.active_positionitem.yhigh + 1);
            gr.drawLine(this.active_positionitem.xlow - 1, this.active_positionitem.yhigh + 1, this.active_positionitem.xlow - 1, this.active_positionitem.ylow - 1);
        }
        if (this.active_eventitem != null) {
            gr.setColor(COLOR_SELECTION);
            gr.drawLine(this.active_eventitem.xlow - 1, this.active_eventitem.ylow - 1, this.active_eventitem.xhigh + 1, this.active_eventitem.ylow - 1);
            gr.drawLine(this.active_eventitem.xhigh + 1, this.active_eventitem.ylow - 1, this.active_eventitem.xhigh + 1, this.active_eventitem.yhigh + 1);
            gr.drawLine(this.active_eventitem.xhigh + 1, this.active_eventitem.yhigh + 1, this.active_eventitem.xlow, this.active_eventitem.yhigh + 1);
            gr.drawLine(this.active_eventitem.xlow - 1, this.active_eventitem.yhigh + 1, this.active_eventitem.xlow - 1, this.active_eventitem.ylow - 1);
        }
        if (this.gui_state == 1) {
            gr.setColor(COLOR_TRACKER);
            gr.drawString(JLFunc.toStringRounded(this.sim_time, 2) + " s", this.width / 2 - 18, this.tracker_y - 5);
        }
    }
}

