/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.LadderEventItem;
import jugglinglab.core.LadderPathItem;
import jugglinglab.core.LadderPositionItem;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class LadderDiagram
extends JPanel
implements AnimationPanel.AnimationAttachment,
MouseListener,
MouseMotionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final int MAX_JUGGLERS = 8;
    protected static final int LADDER_WIDTH_PER_JUGGLER = 150;
    protected static final int LADDER_MIN_WIDTH_PER_JUGGLER = 60;
    protected static final Font MSGFONT = new Font("SansSerif", 0, 12);
    protected static final int BORDER_TOP = 25;
    protected static final int TRANSITION_RADIUS = 5;
    protected static final int PATH_SLOP = 5;
    protected static final int POSITION_RADIUS = 5;
    protected static final double BORDER_SIDES = 0.15;
    protected static final double JUGGLER_SEPARATION = 0.45;
    protected static final double SELFTHROW_WIDTH = 0.25;
    protected static final Color COLOR_BACKGROUND = Color.white;
    protected static final Color COLOR_HANDS = Color.black;
    protected static final Color COLOR_POSITIONS = Color.black;
    protected static final Color COLOR_SYMMETRIES = Color.lightGray;
    protected static final Color COLOR_TRACKER = Color.red;
    protected static final int IMAGE_DRAW_WAIT = 5;
    protected static final int STATE_INACTIVE = 0;
    protected static final int STATE_MOVING_TRACKER = 1;
    protected AnimationPanel ap;
    protected JMLPattern pat;
    protected int width;
    protected int height;
    protected int right_x;
    protected int left_x;
    protected int juggler_delta_x;
    protected int gui_state = 0;
    protected double sim_time;
    protected int tracker_y = 25;
    protected boolean has_switch_symmetry;
    protected boolean has_switchdelay_symmetry;
    protected ArrayList<LadderEventItem> laddereventitems;
    protected ArrayList<LadderPathItem> ladderpathitems;
    protected ArrayList<LadderPositionItem> ladderpositionitems;
    protected BufferedImage im;
    protected boolean image_valid;
    protected int frames_until_image_draw;
    protected boolean anim_paused;

    public LadderDiagram(JMLPattern p) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.setBackground(COLOR_BACKGROUND);
        this.setOpaque(false);
        this.pat = p;
        int jugglers = this.pat.getNumberOfJugglers();
        if (jugglers > 8) {
            String template = guistrings.getString("Too_many_jugglers");
            Object[] arguments = new Object[]{8};
            String message = MessageFormat.format(template, arguments);
            int mwidth = 20 + this.getFontMetrics(MSGFONT).stringWidth(message);
            this.setPreferredSize(new Dimension(mwidth, 1));
            this.setMinimumSize(new Dimension(mwidth, 1));
            return;
        }
        int pref_width = 150 * jugglers;
        int min_width = 60 * jugglers;
        double[] width_mult = new double[]{1.0, 1.0, 0.85, 0.72, 0.65, 0.55};
        pref_width = (int)((double)pref_width * (jugglers >= width_mult.length ? 0.5 : width_mult[jugglers]));
        pref_width = Math.max(pref_width, min_width);
        this.setPreferredSize(new Dimension(pref_width, 1));
        this.setMinimumSize(new Dimension(min_width, 1));
        this.pat.layoutPattern();
        this.createView();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.ap != null && (this.ap.writingGIF || !this.ap.engineAnimating)) {
            return;
        }
        int my = me.getY();
        my = Math.min(Math.max(my, 25), this.height - 25);
        this.gui_state = 1;
        this.tracker_y = my;
        if (this.ap != null) {
            double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
            double newtime = (double)(my - 25) * scale;
            this.anim_paused = this.ap.isPaused();
            this.ap.setPaused(true);
            this.ap.setTime(newtime);
        }
        this.repaint();
        if (this.ap != null) {
            this.ap.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.ap != null && (this.ap.writingGIF || !this.ap.engineAnimating)) {
            return;
        }
        this.gui_state = 0;
        if (this.ap != null) {
            this.ap.setPaused(this.anim_paused);
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.ap != null && (this.ap.writingGIF || !this.ap.engineAnimating)) {
            return;
        }
        int my = me.getY();
        this.tracker_y = my = Math.min(Math.max(my, 25), this.height - 25);
        this.repaint();
        if (this.ap != null) {
            double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
            double newtime = (double)(my - 25) * scale;
            this.ap.setTime(newtime);
            this.ap.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected LadderEventItem getSelectedLadderEvent(int x, int y) {
        for (LadderEventItem item : this.laddereventitems) {
            if (x < item.xlow || x > item.xhigh || y < item.ylow || y > item.yhigh) continue;
            return item;
        }
        return null;
    }

    protected LadderPositionItem getSelectedLadderPosition(int x, int y) {
        for (LadderPositionItem item : this.ladderpositionitems) {
            if (x < item.xlow || x > item.xhigh || y < item.ylow || y > item.yhigh) continue;
            return item;
        }
        return null;
    }

    protected LadderPathItem getSelectedLadderPath(int x, int y, int slop) {
        LadderPathItem result = null;
        double dmin = 0.0;
        if (y < 25 - slop || y > this.height - 25 + slop) {
            return null;
        }
        for (LadderPathItem item : this.ladderpathitems) {
            double d;
            if (item.type == 3) {
                if (y < item.ystart - slop || y > item.yend + slop) continue;
                d = (x - item.xcenter) * (x - item.xcenter) + (y - item.ycenter) * (y - item.ycenter);
                d = Math.abs(Math.sqrt(d) - (double)item.radius);
            } else {
                int xmax;
                int xmin = item.xstart < item.xend ? item.xstart : item.xend;
                int n = xmax = item.xstart < item.xend ? item.xend : item.xstart;
                if (x < xmin - slop || x > xmax + slop || y < item.ystart - slop || y > item.yend + slop) continue;
                d = (item.xend - item.xstart) * (y - item.ystart) - (x - item.xstart) * (item.yend - item.ystart);
                d = Math.abs(d) / Math.sqrt((item.xend - item.xstart) * (item.xend - item.xstart) + (item.yend - item.ystart) * (item.yend - item.ystart));
            }
            if ((int)d >= slop || result != null && !(d < dmin)) continue;
            result = item;
            dmin = d;
        }
        return result;
    }

    public void setPathColor(int path, Color color) {
        for (LadderPathItem item : this.ladderpathitems) {
            if (item.pathnum != path) continue;
            item.color = color;
        }
    }

    protected void updateTrackerPosition() {
        double loop_start = this.pat.getLoopStartTime();
        double loop_end = this.pat.getLoopEndTime();
        this.tracker_y = (int)(0.5 + (double)(this.height - 50) * (this.sim_time - loop_start) / (loop_end - loop_start)) + 25;
    }

    protected void createView() {
        JMLPosition positionlist;
        JMLPosition pos;
        JMLEvent eventlist;
        this.has_switchdelay_symmetry = false;
        this.has_switch_symmetry = false;
        for (JMLSymmetry sym : this.pat.symmetries()) {
            switch (sym.getType()) {
                case 2: {
                    this.has_switch_symmetry = true;
                    break;
                }
                case 3: {
                    this.has_switchdelay_symmetry = true;
                }
            }
        }
        double loop_start = this.pat.getLoopStartTime();
        double loop_end = this.pat.getLoopEndTime();
        this.laddereventitems = new ArrayList();
        JMLEvent ev = eventlist = this.pat.getEventList();
        while (ev.getT() < loop_start) {
            ev = ev.getNext();
        }
        while (ev.getT() < loop_end) {
            LadderEventItem item = new LadderEventItem();
            item.type = 1;
            item.eventitem = item;
            item.event = ev;
            this.laddereventitems.add(item);
            int i = 0;
            while (i < ev.getNumberOfTransitions()) {
                LadderEventItem item2 = new LadderEventItem();
                item2.type = 2;
                item2.eventitem = item;
                item2.event = ev;
                item2.transnum = i++;
                this.laddereventitems.add(item2);
            }
            ev = ev.getNext();
        }
        this.ladderpathitems = new ArrayList();
        ev = eventlist;
        while (ev.getT() <= loop_end) {
            for (int i = 0; i < ev.getNumberOfTransitions(); ++i) {
                JMLTransition tr = ev.getTransition(i);
                PathLink opl = tr.getOutgoingPathLink();
                if (opl == null) continue;
                LadderPathItem item = new LadderPathItem();
                item.transnum_start = i;
                item.startevent = opl.getStartEvent();
                item.endevent = opl.getEndEvent();
                item.type = opl.isInHand() ? 5 : (item.startevent.getJuggler() != item.endevent.getJuggler() ? 6 : (item.startevent.getHand() == item.endevent.getHand() ? 3 : 4));
                item.pathnum = opl.getPathNum();
                item.color = Color.black;
                this.ladderpathitems.add(item);
            }
            ev = ev.getNext();
        }
        this.ladderpositionitems = new ArrayList();
        for (pos = positionlist = this.pat.getPositionList(); pos != null && pos.getT() < loop_start; pos = pos.getNext()) {
        }
        while (pos != null && pos.getT() < loop_end) {
            LadderPositionItem item = new LadderPositionItem();
            item.type = 7;
            item.position = pos;
            this.ladderpositionitems.add(item);
            pos = pos.getNext();
        }
        this.updateView();
    }

    protected void updateView() {
        Dimension dim = this.getSize();
        this.width = dim.width;
        this.height = dim.height;
        double scale = (double)this.width / (0.3 + 0.45 * (double)(this.pat.getNumberOfJugglers() - 1) + (double)this.pat.getNumberOfJugglers());
        this.left_x = (int)(scale * 0.15 + 0.5);
        this.right_x = (int)(scale * 1.15 + 0.5);
        this.juggler_delta_x = (int)(scale * 1.45 + 0.5);
        this.image_valid = false;
        this.im = null;
        this.frames_until_image_draw = 5;
        double loop_start = this.pat.getLoopStartTime();
        double loop_end = this.pat.getLoopEndTime();
        for (LadderEventItem ladderEventItem : this.laddereventitems) {
            JMLEvent ev = ladderEventItem.event;
            int event_x = (ev.getHand() == 1 ? this.left_x : this.right_x) + (ev.getJuggler() - 1) * this.juggler_delta_x - 5;
            int event_y = (int)(0.5 + (double)(this.height - 50) * (ev.getT() - loop_start) / (loop_end - loop_start)) + 25 - 5;
            if (ladderEventItem.type == 1) {
                ladderEventItem.xlow = event_x;
                ladderEventItem.xhigh = event_x + 10;
                ladderEventItem.ylow = event_y;
                ladderEventItem.yhigh = event_y + 10;
                continue;
            }
            event_x = ev.getHand() == 1 ? (event_x += 10 * (ladderEventItem.transnum + 1)) : (event_x -= 10 * (ladderEventItem.transnum + 1));
            ladderEventItem.xlow = event_x;
            ladderEventItem.xhigh = event_x + 10;
            ladderEventItem.ylow = event_y;
            ladderEventItem.yhigh = event_y + 10;
        }
        for (LadderPathItem ladderPathItem : this.ladderpathitems) {
            ladderPathItem.xstart = (ladderPathItem.startevent.getHand() == 1 ? this.left_x + (ladderPathItem.transnum_start + 1) * 2 * 5 : this.right_x - (ladderPathItem.transnum_start + 1) * 2 * 5) + (ladderPathItem.startevent.getJuggler() - 1) * this.juggler_delta_x;
            ladderPathItem.ystart = (int)(0.5 + (double)(this.height - 50) * (ladderPathItem.startevent.getT() - loop_start) / (loop_end - loop_start)) + 25;
            ladderPathItem.yend = (int)(0.5 + (double)(this.height - 50) * (ladderPathItem.endevent.getT() - loop_start) / (loop_end - loop_start)) + 25;
            int slot = 0;
            for (int j = 0; j < ladderPathItem.endevent.getNumberOfTransitions(); ++j) {
                JMLTransition temp = ladderPathItem.endevent.getTransition(j);
                if (temp.getPath() != ladderPathItem.pathnum) continue;
                slot = j;
                break;
            }
            ladderPathItem.xend = (ladderPathItem.endevent.getHand() == 1 ? this.left_x + (slot + 1) * 2 * 5 : this.right_x - (slot + 1) * 2 * 5) + (ladderPathItem.endevent.getJuggler() - 1) * this.juggler_delta_x;
            if (ladderPathItem.type != 3) continue;
            double a = 0.5 * Math.sqrt((double)((ladderPathItem.xstart - ladderPathItem.xend) * (ladderPathItem.xstart - ladderPathItem.xend)) + (double)((ladderPathItem.ystart - ladderPathItem.yend) * (ladderPathItem.ystart - ladderPathItem.yend)));
            double xt = 0.5 * (double)(ladderPathItem.xstart + ladderPathItem.xend);
            double yt = 0.5 * (double)(ladderPathItem.ystart + ladderPathItem.yend);
            double b = 0.25 * ((double)this.width / (double)this.pat.getNumberOfJugglers());
            double d = 0.5 * (a * a / b - b);
            if (d < 0.5 * b) {
                d = 0.5 * b;
            }
            double mult = ladderPathItem.endevent.getHand() == 1 ? -1.0 : 1.0;
            double xc = xt + mult * d * (yt - (double)ladderPathItem.ystart) / a;
            double yc = yt + mult * d * ((double)ladderPathItem.xstart - xt) / a;
            double rad = Math.sqrt(((double)ladderPathItem.xstart - xc) * ((double)ladderPathItem.xstart - xc) + ((double)ladderPathItem.ystart - yc) * ((double)ladderPathItem.ystart - yc));
            ladderPathItem.xcenter = (int)(0.5 + xc);
            ladderPathItem.ycenter = (int)(0.5 + yc);
            ladderPathItem.radius = (int)(0.5 + rad);
        }
        for (LadderPositionItem ladderPositionItem : this.ladderpositionitems) {
            JMLPosition pos = ladderPositionItem.position;
            int position_x = (this.left_x + this.right_x) / 2 + (pos.getJuggler() - 1) * this.juggler_delta_x - 5;
            int position_y = (int)(0.5 + (double)(this.height - 50) * (pos.getT() - loop_start) / (loop_end - loop_start)) + 25 - 5;
            ladderPositionItem.xlow = position_x;
            ladderPositionItem.xhigh = position_x + 10;
            ladderPositionItem.ylow = position_y;
            ladderPositionItem.yhigh = position_y + 10;
        }
        this.updateTrackerPosition();
    }

    protected boolean paintLadder(Graphics gr) {
        boolean rebuild_ladder_image;
        if (this.pat.getNumberOfJugglers() > 8) {
            Dimension dim = this.getSize();
            gr.setFont(MSGFONT);
            FontMetrics fm = gr.getFontMetrics();
            String template = guistrings.getString("Too_many_jugglers");
            Object[] arguments = new Object[]{8};
            String message = MessageFormat.format(template, arguments);
            int n = fm.stringWidth(message);
            int x = Math.max((dim.width - n) / 2, 0);
            int y = (dim.height + fm.getHeight()) / 2;
            gr.setColor(COLOR_BACKGROUND);
            gr.fillRect(0, 0, dim.width, dim.height);
            gr.setColor(Color.black);
            gr.drawString(message, x, y);
            return false;
        }
        Graphics g = gr;
        Dimension dim = this.getSize();
        if (dim.width != this.width || dim.height != this.height) {
            this.updateView();
        }
        boolean bl = rebuild_ladder_image = !this.image_valid && --this.frames_until_image_draw <= 0;
        if (rebuild_ladder_image) {
            this.im = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.width, this.height, 1);
            g = this.im.getGraphics();
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        if (!this.image_valid) {
            g.setColor(COLOR_BACKGROUND);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(COLOR_SYMMETRIES);
            g.drawLine(0, 25, this.width, 25);
            g.drawLine(0, this.height - 25, this.width, this.height - 25);
            if (this.has_switch_symmetry) {
                g.drawLine(this.left_x, this.height - 12, this.width - this.left_x, this.height - 12);
                g.drawLine(this.left_x, this.height - 12, this.left_x + this.left_x, this.height - 18);
                g.drawLine(this.left_x, this.height - 12, this.left_x + this.left_x, this.height - 6);
                g.drawLine(this.width - this.left_x, this.height - 12, this.width - 2 * this.left_x, this.height - 18);
                g.drawLine(this.width - this.left_x, this.height - 12, this.width - 2 * this.left_x, this.height - 6);
            }
            if (this.has_switchdelay_symmetry) {
                g.drawLine(0, this.height / 2, this.width, this.height / 2);
            }
            g.setColor(COLOR_HANDS);
            for (int j = 0; j < this.pat.getNumberOfJugglers(); ++j) {
                for (int i = -1; i < 2; ++i) {
                    g.drawLine(this.left_x + i + j * this.juggler_delta_x, 25, this.left_x + i + j * this.juggler_delta_x, this.height - 25);
                    g.drawLine(this.right_x + i + j * this.juggler_delta_x, 25, this.right_x + i + j * this.juggler_delta_x, this.height - 25);
                }
            }
            Shape clip = g.getClip();
            for (LadderPathItem ladderPathItem : this.ladderpathitems) {
                g.setColor(ladderPathItem.color);
                Graphics2D gdash = null;
                if (ladderPathItem.type == 6) {
                    gdash = (Graphics2D)g.create();
                    BasicStroke dashed = new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{7.0f, 3.0f}, 0.0f);
                    gdash.setStroke(dashed);
                    gdash.clipRect(this.left_x, 25, this.width - this.left_x, this.height - 50);
                } else {
                    g.clipRect(this.left_x + (ladderPathItem.startevent.getJuggler() - 1) * this.juggler_delta_x, 25, this.right_x - this.left_x + (ladderPathItem.startevent.getJuggler() - 1) * this.juggler_delta_x, this.height - 50);
                }
                if (ladderPathItem.type == 4) {
                    g.drawLine(ladderPathItem.xstart, ladderPathItem.ystart, ladderPathItem.xend, ladderPathItem.yend);
                } else if (ladderPathItem.type == 5) {
                    g.drawLine(ladderPathItem.xstart, ladderPathItem.ystart, ladderPathItem.xend, ladderPathItem.yend);
                } else if (ladderPathItem.type == 6) {
                    gdash.drawLine(ladderPathItem.xstart, ladderPathItem.ystart, ladderPathItem.xend, ladderPathItem.yend);
                    gdash.dispose();
                } else if (ladderPathItem.type == 3 && ladderPathItem.yend >= 25) {
                    g.clipRect(this.left_x + (ladderPathItem.startevent.getJuggler() - 1) * this.juggler_delta_x, ladderPathItem.ystart, this.right_x - this.left_x + (ladderPathItem.startevent.getJuggler() - 1) * this.juggler_delta_x, ladderPathItem.yend - ladderPathItem.ystart);
                    g.drawOval(ladderPathItem.xcenter - ladderPathItem.radius, ladderPathItem.ycenter - ladderPathItem.radius, 2 * ladderPathItem.radius, 2 * ladderPathItem.radius);
                }
                g.setClip(clip);
            }
        }
        if (rebuild_ladder_image) {
            this.image_valid = true;
        }
        if (this.image_valid) {
            gr.drawImage(this.im, 0, 0, this);
        }
        for (LadderPositionItem item : this.ladderpositionitems) {
            if (item.ylow < 25 && item.yhigh > this.height + 25) continue;
            gr.setColor(COLOR_BACKGROUND);
            gr.fillRect(item.xlow, item.ylow, item.xhigh - item.xlow, item.yhigh - item.ylow);
            gr.setColor(COLOR_POSITIONS);
            gr.drawRect(item.xlow, item.ylow, item.xhigh - item.xlow, item.yhigh - item.ylow);
        }
        int[] animpropnum = null;
        if (this.ap != null && this.ap.getAnimator() != null) {
            animpropnum = this.ap.getAnimator().getAnimPropNum();
        }
        for (LadderEventItem ladderEventItem : this.laddereventitems) {
            if (ladderEventItem.type == 1) {
                gr.setColor(COLOR_HANDS);
                gr.fillOval(ladderEventItem.xlow, ladderEventItem.ylow, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
                continue;
            }
            if (ladderEventItem.ylow < 25 && ladderEventItem.yhigh > this.height + 25) continue;
            if (animpropnum == null) {
                gr.setColor(COLOR_BACKGROUND);
            } else {
                JMLTransition tr = ladderEventItem.event.getTransition(ladderEventItem.transnum);
                int propnum = animpropnum[tr.getPath() - 1];
                gr.setColor(this.pat.getProp(propnum).getEditorColor());
            }
            gr.fillOval(ladderEventItem.xlow, ladderEventItem.ylow, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
            gr.setColor(COLOR_HANDS);
            gr.drawOval(ladderEventItem.xlow, ladderEventItem.ylow, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
        }
        gr.setColor(COLOR_TRACKER);
        gr.drawLine(0, this.tracker_y, this.width, this.tracker_y);
        return true;
    }

    @Override
    public void setAnimationPanel(AnimationPanel a) {
        this.ap = a;
    }

    @Override
    public void setTime(double time) {
        if (this.sim_time == time) {
            return;
        }
        this.sim_time = time;
        this.updateTrackerPosition();
        this.repaint();
    }

    @Override
    public void repaintAttachment() {
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics gr) {
        if (gr instanceof Graphics2D) {
            Graphics2D gr2 = (Graphics2D)gr;
            gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintLadder(gr);
        if (this.gui_state == 1) {
            gr.setColor(COLOR_TRACKER);
            gr.drawString(JLFunc.toStringRounded(this.sim_time, 2) + " s", this.width / 2 - 18, this.tracker_y - 5);
        }
    }
}

